/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoIdItem
extends Item<ProtoIdItem> {
    private int hashCode = 0;
    private StringIdItem shortyDescriptor;
    private TypeIdItem returnType;
    private TypeListItem parameters;
    private String cachedPrototypeString = null;

    protected ProtoIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private ProtoIdItem(DexFile dexFile, TypeIdItem returnType, TypeListItem parameters) {
        this(dexFile);
        String shortyString = returnType.toShorty();
        if (parameters != null) {
            shortyString = shortyString + parameters.getShortyString();
        }
        this.shortyDescriptor = StringIdItem.internStringIdItem(dexFile, shortyString);
        this.returnType = returnType;
        this.parameters = parameters;
    }

    public static ProtoIdItem internProtoIdItem(DexFile dexFile, TypeIdItem returnType, TypeListItem parameters) {
        ProtoIdItem protoIdItem = new ProtoIdItem(dexFile, returnType, parameters);
        return dexFile.ProtoIdsSection.intern(protoIdItem);
    }

    public static ProtoIdItem lookupProtoIdItem(DexFile dexFile, TypeIdItem returnType, TypeListItem parameters) {
        ProtoIdItem protoIdItem = new ProtoIdItem(dexFile, returnType, parameters);
        return dexFile.ProtoIdsSection.getInternedItem(protoIdItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.shortyDescriptor = this.dexFile.StringIdsSection.getItemByIndex(in.readInt());
        this.returnType = this.dexFile.TypeIdsSection.getItemByIndex(in.readInt());
        this.parameters = (TypeListItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_TYPE_LIST, in.readInt());
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 12;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(4, "shorty_descriptor: " + this.shortyDescriptor.getStringValue());
            out.annotate(4, "return_type: " + this.returnType.getTypeDescriptor());
            if (this.parameters == null) {
                out.annotate(4, "parameters:");
            } else {
                out.annotate(4, "parameters: " + this.parameters.getTypeListString(""));
            }
        }
        out.writeInt(this.shortyDescriptor.getIndex());
        out.writeInt(this.returnType.getIndex());
        out.writeInt(this.parameters == null ? 0 : this.parameters.getOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_PROTO_ID_ITEM;
    }

    @Override
    public int compareTo(ProtoIdItem o2) {
        int result = this.returnType.compareTo(o2.returnType);
        if (result != 0) {
            return result;
        }
        if (this.parameters == null) {
            if (o2.parameters == null) {
                return 0;
            }
            return -1;
        }
        if (o2.parameters == null) {
            return 1;
        }
        return this.parameters.compareTo(o2.parameters);
    }

    @Override
    public String getConciseIdentity() {
        return "proto_id_item: " + this.getPrototypeString();
    }

    public String getPrototypeString() {
        if (this.cachedPrototypeString == null) {
            StringBuilder sb = new StringBuilder("(");
            if (this.parameters != null) {
                sb.append(this.parameters.getTypeListString(""));
            }
            sb.append(")");
            sb.append(this.returnType.getTypeDescriptor());
            this.cachedPrototypeString = sb.toString();
        }
        return this.cachedPrototypeString;
    }

    public TypeIdItem getReturnType() {
        return this.returnType;
    }

    public TypeListItem getParameters() {
        return this.parameters;
    }

    public int getParameterRegisterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.getRegisterCount();
    }

    private void calcHashCode() {
        this.hashCode = this.returnType.hashCode();
        this.hashCode = 31 * this.hashCode + (this.parameters == null ? 0 : this.parameters.hashCode());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !this.getClass().equals(o2.getClass())) {
            return false;
        }
        ProtoIdItem other = (ProtoIdItem)o2;
        return this.returnType == other.returnType && this.parameters == other.parameters;
    }
}

