/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

public class AnnotationEncodedSubValue
extends EncodedValue {
    private int hashCode = 0;
    public final TypeIdItem annotationType;
    public final StringIdItem[] names;
    public final EncodedValue[] values;

    public AnnotationEncodedSubValue(DexFile dexFile, Input in) {
        this.annotationType = dexFile.TypeIdsSection.getItemByIndex(in.readUnsignedLeb128());
        this.names = new StringIdItem[in.readUnsignedLeb128()];
        this.values = new EncodedValue[this.names.length];
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.names[i2] = dexFile.StringIdsSection.getItemByIndex(in.readUnsignedLeb128());
            this.values[i2] = EncodedValue.readEncodedValue(dexFile, in);
        }
    }

    public AnnotationEncodedSubValue(TypeIdItem annotationType, StringIdItem[] names, EncodedValue[] values) {
        this.annotationType = annotationType;
        if (names.length != values.length) {
            throw new RuntimeException("The names and values parameters must be the same length");
        }
        this.names = names;
        this.values = values;
    }

    public void writeValue(AnnotatedOutput out) {
        out.annotate("annotation_type: " + this.annotationType.getTypeDescriptor());
        out.writeUnsignedLeb128(this.annotationType.getIndex());
        out.annotate("element_count: 0x" + Integer.toHexString(this.names.length) + " (" + this.names.length + ")");
        out.writeUnsignedLeb128(this.names.length);
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            out.annotate(0, "[" + i2 + "] annotation_element");
            out.indent();
            out.annotate("element_name: " + this.names[i2].getStringValue());
            out.writeUnsignedLeb128(this.names[i2].getIndex());
            out.annotate(0, "element_value:");
            out.indent();
            this.values[i2].writeValue(out);
            out.deindent();
            out.deindent();
        }
    }

    public int placeValue(int offset) {
        offset += Leb128Utils.unsignedLeb128Size(this.annotationType.getIndex());
        offset += Leb128Utils.unsignedLeb128Size(this.names.length);
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            offset += Leb128Utils.unsignedLeb128Size(this.names[i2].getIndex());
            offset = this.values[i2].placeValue(offset);
        }
        return offset;
    }

    protected int compareValue(EncodedValue o2) {
        AnnotationEncodedSubValue other = (AnnotationEncodedSubValue)o2;
        int comp = this.annotationType.compareTo(other.annotationType);
        if (comp != 0) {
            return comp;
        }
        comp = this.names.length - other.names.length;
        if (comp != 0) {
            return comp;
        }
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            comp = this.names[i2].compareTo(other.names[i2]);
            if (comp != 0) {
                return comp;
            }
            comp = this.values[i2].compareTo(other.values[i2]);
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public ValueType getValueType() {
        return ValueType.VALUE_ANNOTATION;
    }

    private void calcHashCode() {
        this.hashCode = this.annotationType.hashCode();
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.hashCode = 31 * this.hashCode + this.names[i2].hashCode();
            this.hashCode = 31 * this.hashCode + this.values[i2].hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }
}

