/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22c
extends InstructionWithReference
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;

    public Instruction22c(Opcode opcode, byte regA, byte regB, Item referencedItem) {
        super(opcode, referencedItem);
        if (regA >= 16 || regB >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        this.regA = regA;
        this.regB = regB;
    }

    private Instruction22c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regB << 4 | this.regA);
        out.writeShort(this.getReferencedItem().getIndex());
    }

    public Format getFormat() {
        return Format.Format22c;
    }

    public int getRegisterA() {
        return this.regA;
    }

    public int getRegisterB() {
        return this.regB;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

