/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSetItem
extends Item<AnnotationSetItem> {
    private int hashCode = 0;
    private AnnotationItem[] annotations;

    protected AnnotationSetItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationSetItem(DexFile dexFile, AnnotationItem[] annotations) {
        super(dexFile);
        this.annotations = annotations;
    }

    public static AnnotationSetItem internAnnotationSetItem(DexFile dexFile, List<AnnotationItem> annotations) {
        AnnotationSetItem annotationSetItem;
        if (annotations == null) {
            annotationSetItem = new AnnotationSetItem(dexFile, new AnnotationItem[0]);
        } else {
            AnnotationItem[] annotationsArray = new AnnotationItem[annotations.size()];
            annotations.toArray(annotationsArray);
            annotationSetItem = new AnnotationSetItem(dexFile, annotationsArray);
        }
        return dexFile.AnnotationSetsSection.intern(annotationSetItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.annotations = new AnnotationItem[in.readInt()];
        for (int i2 = 0; i2 < this.annotations.length; ++i2) {
            this.annotations[i2] = (AnnotationItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_ITEM, in.readInt());
        }
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 4 + this.annotations.length * 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        Arrays.sort(this.annotations, new Comparator<AnnotationItem>(){

            @Override
            public int compare(AnnotationItem annotationItem, AnnotationItem annotationItem2) {
                int annotationItemIndex2;
                int annotationItemIndex = annotationItem.getEncodedAnnotation().annotationType.getIndex();
                if (annotationItemIndex < (annotationItemIndex2 = annotationItem2.getEncodedAnnotation().annotationType.getIndex())) {
                    return -1;
                }
                if (annotationItemIndex == annotationItemIndex2) {
                    return 0;
                }
                return 1;
            }
        });
        if (out.annotates()) {
            out.annotate(4, "size: 0x" + Integer.toHexString(this.annotations.length) + " (" + this.annotations.length + ")");
            for (AnnotationItem annotationItem : this.annotations) {
                out.annotate(4, "annotation_off: 0x" + Integer.toHexString(annotationItem.getOffset()) + " - " + annotationItem.getEncodedAnnotation().annotationType.getTypeDescriptor());
            }
        }
        out.writeInt(this.annotations.length);
        for (AnnotationItem annotationItem : this.annotations) {
            out.writeInt(annotationItem.getOffset());
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATION_SET_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "annotation_set_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(AnnotationSetItem o2) {
        if (o2 == null) {
            return 1;
        }
        int comp = this.annotations.length - o2.annotations.length;
        if (comp == 0) {
            for (int i2 = 0; i2 < this.annotations.length; ++i2) {
                comp = this.annotations[i2].compareTo(o2.annotations[i2]);
                if (comp == 0) continue;
                return comp;
            }
        }
        return comp;
    }

    public AnnotationItem[] getAnnotations() {
        return this.annotations;
    }

    private void calcHashCode() {
        this.hashCode = 0;
        for (AnnotationItem annotationItem : this.annotations) {
            this.hashCode = this.hashCode * 31 + annotationItem.hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !this.getClass().equals(o2.getClass())) {
            return false;
        }
        AnnotationSetItem other = (AnnotationSetItem)o2;
        return this.compareTo(other) == 0;
    }
}

