/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.AnnotationVisibility;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.AnnotationEncodedSubValue;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationItem
extends Item<AnnotationItem> {
    private int hashCode = 0;
    private AnnotationVisibility visibility;
    private AnnotationEncodedSubValue annotationValue;

    protected AnnotationItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationItem(DexFile dexFile, AnnotationVisibility visibility, AnnotationEncodedSubValue annotationValue) {
        super(dexFile);
        this.visibility = visibility;
        this.annotationValue = annotationValue;
    }

    public static AnnotationItem internAnnotationItem(DexFile dexFile, AnnotationVisibility visibility, AnnotationEncodedSubValue annotationValue) {
        AnnotationItem annotationItem = new AnnotationItem(dexFile, visibility, annotationValue);
        return dexFile.AnnotationsSection.intern(annotationItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.visibility = AnnotationVisibility.fromByte(in.readByte());
        this.annotationValue = new AnnotationEncodedSubValue(this.dexFile, in);
    }

    @Override
    protected int placeItem(int offset) {
        return this.annotationValue.placeValue(offset + 1);
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate("visibility: " + this.visibility.name());
            out.writeByte(this.visibility.value);
            this.annotationValue.writeValue(out);
        } else {
            out.writeByte(this.visibility.value);
            this.annotationValue.writeValue(out);
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATION_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "annotation_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(AnnotationItem o2) {
        int comp = this.visibility.value - o2.visibility.value;
        if (comp == 0) {
            comp = this.annotationValue.compareTo(o2.annotationValue);
        }
        return comp;
    }

    public AnnotationVisibility getVisibility() {
        return this.visibility;
    }

    public AnnotationEncodedSubValue getEncodedAnnotation() {
        return this.annotationValue;
    }

    private void calcHashCode() {
        this.hashCode = this.visibility.value;
        this.hashCode = this.hashCode * 31 + this.annotationValue.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !this.getClass().equals(o2.getClass())) {
            return false;
        }
        AnnotationItem other = (AnnotationItem)o2;
        return this.visibility == other.visibility && this.annotationValue.equals(other.annotationValue);
    }
}

