/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.DexFile;
import org.jf.util.ClassFileNameHandler;
import org.jf.util.IndentingWriter;

public class baksmali {
    public static boolean noParameterRegisters = false;
    public static boolean useLocalsDirective = false;
    public static boolean useSequentialLabels = false;
    public static boolean outputDebugInfo = true;
    public static boolean addCodeOffsets = false;
    public static boolean deodex = false;
    public static boolean verify = false;
    public static int registerInfo = 0;
    public static String bootClassPath;
    private static final Pattern extJarPattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassembleDexFile(String dexFilePath, DexFile dexFile, boolean deodex, String outputDirectory, String[] classPathDirs, String bootClassPath, String extraBootClassPath, boolean noParameterRegisters, boolean useLocalsDirective, boolean useSequentialLabels, boolean outputDebugInfo, boolean addCodeOffsets, int registerInfo, boolean verify, boolean ignoreErrors) {
        File outputDirectoryFile;
        baksmali.noParameterRegisters = noParameterRegisters;
        baksmali.useLocalsDirective = useLocalsDirective;
        baksmali.useSequentialLabels = useSequentialLabels;
        baksmali.outputDebugInfo = outputDebugInfo;
        baksmali.addCodeOffsets = addCodeOffsets;
        baksmali.deodex = deodex;
        baksmali.registerInfo = registerInfo;
        baksmali.bootClassPath = bootClassPath;
        baksmali.verify = verify;
        ClassPath.ClassPathErrorHandler classPathErrorHandler = null;
        if (ignoreErrors) {
            classPathErrorHandler = new ClassPath.ClassPathErrorHandler(){

                public void ClassPathError(String className, Exception ex) {
                    System.err.println(String.format("Skipping %s", className));
                    ex.printStackTrace(System.err);
                }
            };
        }
        if (registerInfo != 0 || deodex || verify) {
            try {
                String[] extraBootClassPathArray = null;
                if (extraBootClassPath != null && extraBootClassPath.length() > 0) {
                    assert (extraBootClassPath.charAt(0) == ':');
                    extraBootClassPathArray = extraBootClassPath.substring(1).split(":");
                }
                if (dexFile.isOdex() && bootClassPath == null) {
                    if (extraBootClassPathArray == null && baksmali.isExtJar(dexFilePath)) {
                        extraBootClassPathArray = new String[]{"framework.jar"};
                    }
                    ClassPath.InitializeClassPathFromOdex(classPathDirs, extraBootClassPathArray, dexFilePath, dexFile, classPathErrorHandler);
                } else {
                    String[] bootClassPathArray = null;
                    if (bootClassPath != null) {
                        bootClassPathArray = bootClassPath.split(":");
                    }
                    ClassPath.InitializeClassPath(classPathDirs, bootClassPathArray, extraBootClassPathArray, dexFilePath, dexFile, classPathErrorHandler);
                }
            }
            catch (Exception ex) {
                System.err.println("\n\nError occured while loading boot class path files. Aborting.");
                ex.printStackTrace(System.err);
                System.exit(1);
            }
        }
        if (!(outputDirectoryFile = new File(outputDirectory)).exists() && !outputDirectoryFile.mkdirs()) {
            System.err.println("Can't create the output directory " + outputDirectory);
            System.exit(1);
        }
        ArrayList classDefItems = new ArrayList(dexFile.ClassDefsSection.getItems());
        Collections.sort(classDefItems, new Comparator<ClassDefItem>(){

            @Override
            public int compare(ClassDefItem classDefItem1, ClassDefItem classDefItem2) {
                return classDefItem1.getClassType().getTypeDescriptor().compareTo(classDefItem1.getClassType().getTypeDescriptor());
            }
        });
        ClassFileNameHandler fileNameHandler = new ClassFileNameHandler(outputDirectoryFile, ".smali");
        for (ClassDefItem classDefItem : classDefItems) {
            ClassPath.ClassDef classDef;
            if ((registerInfo != 0 || deodex || verify) && ((classDef = ClassPath.getClassDef(classDefItem.getClassType(), false)) == null || classDef instanceof ClassPath.UnresolvedClassDef)) continue;
            String classDescriptor = classDefItem.getClassType().getTypeDescriptor();
            if (classDescriptor.charAt(0) != 'L' || classDescriptor.charAt(classDescriptor.length() - 1) != ';') {
                System.err.println("Unrecognized class descriptor - " + classDescriptor + " - skipping class");
                continue;
            }
            File smaliFile = fileNameHandler.getUniqueFilenameForClass(classDescriptor);
            ClassDefinition classDefinition = new ClassDefinition(classDefItem);
            Writer writer = null;
            try {
                File smaliParent = smaliFile.getParentFile();
                if (!smaliParent.exists() && !smaliParent.mkdirs()) {
                    System.err.println("Unable to create directory " + smaliParent.toString() + " - skipping class");
                    continue;
                }
                if (!smaliFile.exists() && !smaliFile.createNewFile()) {
                    System.err.println("Unable to create file " + smaliFile.toString() + " - skipping class");
                    continue;
                }
                BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(smaliFile), "UTF8"));
                writer = new IndentingWriter(bufWriter);
                classDefinition.writeTo((IndentingWriter)writer);
            }
            catch (Exception ex) {
                System.err.println("\n\nError occured while disassembling class " + classDescriptor.replace('/', '.') + " - skipping class");
                ex.printStackTrace();
            }
            finally {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (Throwable ex) {
                    System.err.println("\n\nError occured while closing file " + smaliFile.toString());
                    ex.printStackTrace();
                }
                continue;
            }
            if (ignoreErrors || !classDefinition.hadValidationErrors()) continue;
            System.exit(1);
        }
    }

    private static boolean isExtJar(String dexFilePath) {
        Matcher m2 = extJarPattern.matcher(dexFilePath);
        return m2.find();
    }

    static {
        extJarPattern = Pattern.compile("(?:^|\\\\|/)ext.(?:jar|odex)$");
    }
}

