/*
 * Decompiled with CFR 0.152.
 */
package ds.tree;

import ds.tree.DuplicateKeyException;
import ds.tree.RadixTree;
import ds.tree.RadixTreeNode;
import ds.tree.Visitor;
import ds.tree.VisitorImpl;
import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadixTreeImpl<T>
implements RadixTree<T>,
Formattable {
    protected RadixTreeNode<T> root = new RadixTreeNode();
    protected long size;

    public RadixTreeImpl() {
        this.root.setKey("");
        this.size = 0L;
    }

    @Override
    public T find(String key) {
        VisitorImpl visitor = new VisitorImpl<T, T>(){

            @Override
            public void visit(String key, RadixTreeNode<T> parent, RadixTreeNode<T> node2) {
                if (node2.isReal()) {
                    this.result = node2.getValue();
                }
            }
        };
        this.visit(key, visitor);
        return (T)visitor.getResult();
    }

    @Override
    public boolean replace(String key, final T value) {
        VisitorImpl visitor = new VisitorImpl<T, T>(){

            @Override
            public void visit(String key, RadixTreeNode<T> parent, RadixTreeNode<T> node2) {
                if (node2.isReal()) {
                    node2.setValue(value);
                    this.result = value;
                } else {
                    this.result = null;
                }
            }
        };
        this.visit(key, visitor);
        return visitor.getResult() != null;
    }

    @Override
    public boolean delete(String key) {
        VisitorImpl visitor = new VisitorImpl<T, Boolean>(Boolean.FALSE){

            @Override
            public void visit(String key, RadixTreeNode<T> parent, RadixTreeNode<T> node2) {
                this.result = node2.isReal();
                if (((Boolean)this.result).booleanValue()) {
                    if (node2.getChildern().size() == 0) {
                        Iterator it = parent.getChildern().iterator();
                        while (it.hasNext()) {
                            if (!it.next().getKey().equals(node2.getKey())) continue;
                            it.remove();
                            break;
                        }
                        if (parent.getChildern().size() == 1 && !parent.isReal()) {
                            this.mergeNodes(parent, parent.getChildern().get(0));
                        }
                    } else if (node2.getChildern().size() == 1) {
                        this.mergeNodes(node2, node2.getChildern().get(0));
                    } else {
                        node2.setReal(false);
                    }
                }
            }

            private void mergeNodes(RadixTreeNode<T> parent, RadixTreeNode<T> child) {
                parent.setKey(parent.getKey() + child.getKey());
                parent.setReal(child.isReal());
                parent.setValue(child.getValue());
                parent.setChildern(child.getChildern());
            }
        };
        this.visit(key, visitor);
        if (((Boolean)visitor.getResult()).booleanValue()) {
            --this.size;
        }
        return (Boolean)visitor.getResult();
    }

    @Override
    public void insert(String key, T value) throws DuplicateKeyException {
        try {
            this.insert(key, this.root, value);
        }
        catch (DuplicateKeyException e2) {
            throw new DuplicateKeyException("Duplicate key: '" + key + "'");
        }
        ++this.size;
    }

    private void insert(String key, RadixTreeNode<T> node2, T value) throws DuplicateKeyException {
        int numberOfMatchingCharacters = node2.getNumberOfMatchingCharacters(key);
        if (node2.getKey().equals("") || numberOfMatchingCharacters == 0 || numberOfMatchingCharacters < key.length() && numberOfMatchingCharacters >= node2.getKey().length()) {
            boolean flag = false;
            String newText = key.substring(numberOfMatchingCharacters, key.length());
            for (RadixTreeNode<T> child : node2.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                flag = true;
                this.insert(newText, child, value);
                break;
            }
            if (!flag) {
                RadixTreeNode<T> n2 = new RadixTreeNode<T>();
                n2.setKey(newText);
                n2.setReal(true);
                n2.setValue(value);
                node2.getChildern().add(n2);
            }
        } else if (numberOfMatchingCharacters == key.length() && numberOfMatchingCharacters == node2.getKey().length()) {
            if (node2.isReal()) {
                throw new DuplicateKeyException("Duplicate key");
            }
            node2.setReal(true);
            node2.setValue(value);
        } else if (numberOfMatchingCharacters > 0 && numberOfMatchingCharacters < node2.getKey().length()) {
            RadixTreeNode<T> n1 = new RadixTreeNode<T>();
            n1.setKey(node2.getKey().substring(numberOfMatchingCharacters, node2.getKey().length()));
            n1.setReal(node2.isReal());
            n1.setValue(node2.getValue());
            n1.setChildern(node2.getChildern());
            node2.setKey(key.substring(0, numberOfMatchingCharacters));
            node2.setReal(false);
            node2.setChildern(new ArrayList());
            node2.getChildern().add(n1);
            if (numberOfMatchingCharacters < key.length()) {
                RadixTreeNode<T> n2 = new RadixTreeNode<T>();
                n2.setKey(key.substring(numberOfMatchingCharacters, key.length()));
                n2.setReal(true);
                n2.setValue(value);
                node2.getChildern().add(n2);
            } else {
                node2.setValue(value);
                node2.setReal(true);
            }
        } else {
            RadixTreeNode<T> n3 = new RadixTreeNode<T>();
            n3.setKey(node2.getKey().substring(numberOfMatchingCharacters, node2.getKey().length()));
            n3.setChildern(node2.getChildern());
            n3.setReal(node2.isReal());
            n3.setValue(node2.getValue());
            node2.setKey(key);
            node2.setReal(true);
            node2.setValue(value);
            node2.getChildern().add(n3);
        }
    }

    @Override
    public ArrayList<T> searchPrefix(String key, int recordLimit) {
        ArrayList<T> keys = new ArrayList<T>();
        RadixTreeNode<T> node2 = this.searchPefix(key, this.root);
        if (node2 != null) {
            if (node2.isReal()) {
                keys.add(node2.getValue());
            }
            this.getNodes(node2, keys, recordLimit);
        }
        return keys;
    }

    private void getNodes(RadixTreeNode<T> parent, ArrayList<T> keys, int limit) {
        LinkedList queue = new LinkedList();
        queue.addAll(parent.getChildern());
        while (!queue.isEmpty()) {
            RadixTreeNode node2 = (RadixTreeNode)queue.remove();
            if (node2.isReal()) {
                keys.add(node2.getValue());
            }
            if (keys.size() == limit) break;
            queue.addAll(node2.getChildern());
        }
    }

    private RadixTreeNode<T> searchPefix(String key, RadixTreeNode<T> node2) {
        RadixTreeNode<T> result = null;
        int numberOfMatchingCharacters = node2.getNumberOfMatchingCharacters(key);
        if (numberOfMatchingCharacters == key.length() && numberOfMatchingCharacters <= node2.getKey().length()) {
            result = node2;
        } else if (node2.getKey().equals("") || numberOfMatchingCharacters < key.length() && numberOfMatchingCharacters >= node2.getKey().length()) {
            String newText = key.substring(numberOfMatchingCharacters, key.length());
            for (RadixTreeNode<T> child : node2.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                result = this.searchPefix(newText, child);
                break;
            }
        }
        return result;
    }

    @Override
    public boolean contains(String key) {
        VisitorImpl visitor = new VisitorImpl<T, Boolean>(Boolean.FALSE){

            @Override
            public void visit(String key, RadixTreeNode<T> parent, RadixTreeNode<T> node2) {
                this.result = node2.isReal();
            }
        };
        this.visit(key, visitor);
        return (Boolean)visitor.getResult();
    }

    public <R> void visit(String key, Visitor<T, R> visitor) {
        if (this.root != null) {
            this.visit(key, visitor, null, this.root);
        }
    }

    private <R> void visit(String prefix, Visitor<T, R> visitor, RadixTreeNode<T> parent, RadixTreeNode<T> node2) {
        int numberOfMatchingCharacters = node2.getNumberOfMatchingCharacters(prefix);
        if (numberOfMatchingCharacters == prefix.length() && numberOfMatchingCharacters == node2.getKey().length()) {
            visitor.visit(prefix, parent, node2);
        } else if (node2.getKey().equals("") || numberOfMatchingCharacters < prefix.length() && numberOfMatchingCharacters >= node2.getKey().length()) {
            String newText = prefix.substring(numberOfMatchingCharacters, prefix.length());
            for (RadixTreeNode<T> child : node2.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                this.visit(newText, visitor, node2, child);
                break;
            }
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Deprecated
    public void display() {
        this.formatNodeTo(new Formatter(System.out), 0, this.root);
    }

    @Deprecated
    private void display(int level, RadixTreeNode<T> node2) {
        this.formatNodeTo(new Formatter(System.out), level, node2);
    }

    private void formatNodeTo(Formatter f2, int level, RadixTreeNode<T> node2) {
        int i2;
        for (i2 = 0; i2 < level; ++i2) {
            f2.format(" ", new Object[0]);
        }
        f2.format("|", new Object[0]);
        for (i2 = 0; i2 < level; ++i2) {
            f2.format("-", new Object[0]);
        }
        if (node2.isReal()) {
            f2.format("%s[%s]*%n", node2.getKey(), node2.getValue());
        } else {
            f2.format("%s%n", node2.getKey());
        }
        for (RadixTreeNode<T> child : node2.getChildern()) {
            this.formatNodeTo(f2, level + 1, child);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        this.formatNodeTo(formatter, 0, this.root);
    }

    @Override
    public String complete(String prefix) {
        return this.complete(prefix, this.root, "");
    }

    private String complete(String key, RadixTreeNode<T> node2, String base) {
        int i2;
        int keylen = key.length();
        int nodelen = node2.getKey().length();
        for (i2 = 0; i2 < keylen && i2 < nodelen && key.charAt(i2) == node2.getKey().charAt(i2); ++i2) {
        }
        if (i2 == keylen && i2 <= nodelen) {
            return base + node2.getKey();
        }
        if (nodelen == 0 || i2 < keylen && i2 >= nodelen) {
            String beginning = key.substring(0, i2);
            String ending = key.substring(i2, keylen);
            for (RadixTreeNode<T> child : node2.getChildern()) {
                if (!child.getKey().startsWith(ending.charAt(0) + "")) continue;
                return this.complete(ending, child, base + beginning);
            }
        }
        return "";
    }
}

