/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.Cf;
import com.rsa.certj.cert.Cg;
import com.rsa.certj.cert.NameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class AttributeValueAssertion
implements Cloneable,
Serializable {
    public static final int UNKNOWN_ATTRIBUTE_TYPE = -1;
    public static final int BOUND_UNLIMITED = -1;
    public static int UNSUPPORTED_ASN1_TYPE = -1;
    public static final int COMMON_NAME = 0;
    public static byte[] COMMON_NAME_OID = new byte[]{85, 4, 3};
    public static final int UB_COMMON_NAME = 64;
    private static final int a = 500;
    public static final int COUNTRY_NAME = 1;
    public static byte[] COUNTRY_NAME_OID = new byte[]{85, 4, 6};
    public static final int COUNTRY_NAME_LENGTH = 2;
    public static final int LOCALITY_NAME = 2;
    public static byte[] LOCALITY_NAME_OID = new byte[]{85, 4, 7};
    public static final int UB_LOCALITY_NAME = 128;
    public static final int STATE_NAME = 3;
    public static byte[] STATE_NAME_OID = new byte[]{85, 4, 8};
    public static final int UB_STATE_NAME = 128;
    public static final int ORGANIZATION_NAME = 4;
    public static byte[] ORGANIZATION_NAME_OID = new byte[]{85, 4, 10};
    public static final int UB_ORGANIZATION_NAME = 64;
    public static final int ORGANIZATIONAL_UNIT_NAME = 5;
    public static byte[] ORGANIZATIONAL_UNIT_NAME_OID = new byte[]{85, 4, 11};
    public static final int UB_ORGANIZATIONAL_UNIT_NAME = 128;
    public static final int TELEPHONE_NUMBER = 6;
    public static byte[] TELEPHONE_NUMBER_OID = new byte[]{85, 4, 20};
    public static final int UB_TELEPHONE_NUMBER = 32;
    public static final int EMAIL_ADDRESS = 7;
    public static byte[] EMAIL_ADDRESS_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    public static final int UB_EMAIL_ADDRESS = 64;
    public static final int TITLE = 8;
    public static byte[] TITLE_OID = new byte[]{85, 4, 12};
    public static final int UB_TITLE = 64;
    public static final int STREET_ADDRESS = 9;
    public static byte[] STREET_ADDRESS_OID = new byte[]{85, 4, 9};
    public static final int UB_STREET_ADDRESS = 128;
    public static final int BUSINESS_CATEGORY = 10;
    public static byte[] BUSINESS_CATEGORY_OID = new byte[]{85, 4, 15};
    public static final int UB_BUSINESS_CATEGORY = 128;
    public static final int POSTAL_CODE = 11;
    public static byte[] POSTAL_CODE_OID = new byte[]{85, 4, 17};
    public static final int UB_POSTAL_CODE = 40;
    public static final int SURNAME = 12;
    public static byte[] SURNAME_OID = new byte[]{85, 4, 4};
    public static final int UB_SURNAME = 32768;
    public static final int GIVEN_NAME = 13;
    public static byte[] GIVEN_NAME_OID = new byte[]{85, 4, 42};
    public static final int UB_GIVEN_NAME = 32768;
    public static final int SERIAL_NUMBER = 14;
    public static byte[] SERIAL_NUMBER_OID = new byte[]{85, 4, 5};
    public static final int UB_SERIAL_NUMBER = 64;
    public static final int INITIALS = 15;
    public static byte[] INITIALS_OID = new byte[]{85, 4, 43};
    public static final int UB_INITIALS = 32768;
    public static final int GENERATION_QUALIFIER = 16;
    public static byte[] GENERATION_QUALIFIER_OID = new byte[]{85, 4, 44};
    public static final int UB_GENERATION_QUALIFIER = 32768;
    public static final int NAME = 17;
    public static byte[] NAME_OID = new byte[]{85, 4, 41};
    public static final int UB_NAME = 32768;
    public static final int DN_QUALIFIER = 18;
    public static byte[] DN_QUALIFIER_OID = new byte[]{85, 4, 46};
    public static final int UB_DN_QUALIFIER = -1;
    public static final int DOMAIN_COMPONENT = 19;
    public static byte[] DOMAIN_COMPONENT_OID = new byte[]{9, -110, 38, -119, -109, -14, 44, 100, 1, 25};
    public static final int UB_DOMAIN_COMPONENT = 64;
    public static final int POSTAL_ADDRESS = 20;
    public static byte[] POSTAL_ADDRESS_OID = new byte[]{85, 4, 16};
    public static final int UB_POSTAL_ADDRESS = -1;
    public static final int PSEUDONYM = 21;
    public static byte[] PSEUDONYM_OID = new byte[]{85, 4, 65};
    public static final int UB_PSEUDONYM = -1;
    public static final int DATE_OF_BIRTH = 22;
    public static byte[] DATE_OF_BIRTH_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 1};
    public static final int UB_DATE_OF_BIRTH = -1;
    public static final int PLACE_OF_BIRTH = 23;
    public static byte[] PLACE_OF_BIRTH_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 2};
    public static final int UB_PLACE_OF_BIRTH = 32768;
    public static final int GENDER = 24;
    public static byte[] GENDER_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 3};
    public static final int UB_GENDER = 1;
    public static final int COUNTRY_OF_CITIZENSHIP = 25;
    public static byte[] COUNTRY_OF_CITIZENSHIP_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 4};
    public static final int UB_COUNTRY_OF_CITIZENSHIP = 2;
    public static final int COUNTRY_OF_RESIDENCE = 26;
    public static byte[] COUNTRY_OF_RESIDENCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 5};
    public static final int UB_COUNTRY_OF_RESIDENCE = 2;
    protected static final Cg[] allNameAttributeIDs = new Cg[]{new Cg(COMMON_NAME_OID, "CN"), new Cg(COUNTRY_NAME_OID, "C"), new Cg(LOCALITY_NAME_OID, "L"), new Cg(STATE_NAME_OID, "ST"), new Cg(ORGANIZATION_NAME_OID, "O"), new Cg(ORGANIZATIONAL_UNIT_NAME_OID, "OU"), new Cg(TELEPHONE_NUMBER_OID, "TEL"), new Cg(EMAIL_ADDRESS_OID, "E"), new Cg(TITLE_OID, "TITLE"), new Cg(STREET_ADDRESS_OID, "STREET"), new Cg(BUSINESS_CATEGORY_OID, "BC"), new Cg(POSTAL_CODE_OID, "postalCode"), new Cg(SURNAME_OID, "SN"), new Cg(GIVEN_NAME_OID, "givenName"), new Cg(SERIAL_NUMBER_OID, "serialNumber"), new Cg(INITIALS_OID, "initials"), new Cg(GENERATION_QUALIFIER_OID, "generationQualifier"), new Cg(NAME_OID, "name"), new Cg(DN_QUALIFIER_OID, "dnQualifier"), new Cg(DOMAIN_COMPONENT_OID, "dc"), new Cg(POSTAL_ADDRESS_OID, "postalAddress"), new Cg(PSEUDONYM_OID, "pseudonym"), new Cg(DATE_OF_BIRTH_OID, "dateOfBirth"), new Cg(PLACE_OF_BIRTH_OID, "placeOfBirth"), new Cg(GENDER_OID, "gender"), new Cg(COUNTRY_OF_CITIZENSHIP_OID, "citizenship"), new Cg(COUNTRY_OF_RESIDENCE_OID, "residence")};
    protected static final Cf[] alternativeAttributeNames = new Cf[]{new Cf(7, "email"), new Cf(7, "EmailAddress"), new Cf(7, "Ea")};
    private int b;
    private byte[] c;
    private byte[] d;
    private int e;
    private int f;
    private int g = UNSUPPORTED_ASN1_TYPE;
    private String h = null;
    protected ASN1Template asn1Template = null;

    protected AttributeValueAssertion() {
    }

    public AttributeValueAssertion(int n2, byte[] byArray, byte[] byArray2, int n3, int n4) throws NameException {
        this.b = n2;
        if (n2 >= allNameAttributeIDs.length) {
            this.b = -1;
        }
        if (byArray2 == null || n4 == 0) {
            throw new NameException("BER encoding is null.");
        }
        this.d = byArray2;
        this.e = n3;
        this.f = n4;
        if (this.b == -1) {
            if (byArray == null) {
                throw new NameException("AVA type is missing.");
            }
            this.c = byArray;
            try {
                this.a(this.d, this.e, -1);
            }
            catch (NameException nameException) {
                this.h = null;
            }
            return;
        }
        switch (n2) {
            case 0: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray2, n3, 64);
                    break;
                }
                this.a(byArray2, n3, 500);
                break;
            }
            case 1: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray2, n3, 2, 2);
                    break;
                }
                this.a(byArray2, n3, 2);
                this.g = 4864;
                break;
            }
            case 2: {
                this.a(byArray2, n3, 128);
                break;
            }
            case 3: {
                this.a(byArray2, n3, 128);
                break;
            }
            case 4: {
                this.a(byArray2, n3, 64);
                break;
            }
            case 5: {
                this.a(byArray2, n3, 128);
                break;
            }
            case 6: {
                this.a(byArray2, n3, 1, 32);
                break;
            }
            case 7: {
                this.a(byArray2, n3, 64);
                break;
            }
            case 8: {
                this.a(byArray2, n3, 64);
                break;
            }
            case 9: {
                this.a(byArray2, n3, 128);
                break;
            }
            case 10: {
                this.a(byArray2, n3, 128);
                break;
            }
            case 11: {
                this.a(byArray2, n3, 40);
                break;
            }
            case 12: {
                this.a(byArray2, n3, 32768);
                break;
            }
            case 13: {
                this.a(byArray2, n3, 32768);
                break;
            }
            case 14: {
                this.a(byArray2, n3, 1, 64);
                break;
            }
            case 15: {
                this.a(byArray2, n3, 32768);
                break;
            }
            case 16: {
                this.a(byArray2, n3, 32768);
                break;
            }
            case 17: {
                this.a(byArray2, n3, 32768);
                break;
            }
            case 18: {
                this.a(byArray2, n3, 1, -1);
                break;
            }
            case 19: {
                this.b(byArray2, n3, 1, 19);
                break;
            }
            case 20: {
                this.b(byArray2, n3, -1);
                break;
            }
            case 21: {
                this.a(byArray2, n3, -1);
                break;
            }
            case 22: {
                this.a(byArray2, n3);
                break;
            }
            case 23: {
                this.a(byArray2, n3, 32768);
                break;
            }
            case 24: {
                this.a(byArray2, n3, 1, 1);
                break;
            }
            case 25: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray2, n3, 2, 2);
                    break;
                }
                this.a(byArray2, n3, 2);
                this.g = 4864;
                break;
            }
            case 26: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray2, n3, 2, 2);
                    break;
                }
                this.a(byArray2, n3, 2);
                this.g = 4864;
            }
        }
    }

    public AttributeValueAssertion(int n2, byte[] byArray, int n3, String string) throws NameException {
        this.b = n2;
        if (n2 >= allNameAttributeIDs.length) {
            this.b = -1;
        }
        if (n3 == 0) {
            switch (n2) {
                case 1: 
                case 6: 
                case 14: 
                case 18: 
                case 24: 
                case 25: 
                case 26: {
                    n3 = 4864;
                    break;
                }
                case 7: 
                case 19: {
                    n3 = 5632;
                    break;
                }
                case 22: {
                    n3 = 6144;
                    break;
                }
                case -1: {
                    throw new NameException("ASN.1 type is missing.");
                }
                default: {
                    n3 = 3072;
                }
            }
        }
        this.g = n3;
        if (this.b == -1) {
            if (byArray == null) {
                throw new NameException("AVA type is missing.");
            }
            this.c = byArray;
        } else {
            this.a(this.b, this.g, string);
        }
        if (!this.a(this.g)) {
            throw new NameException("Unsupported ASN1 type. Use another constructor that takes the DER form.");
        }
        if (string == null) {
            throw new NameException("AVA value is missing.");
        }
        this.h = string;
    }

    public AttributeValueAssertion(byte[] byArray, byte[] byArray2) throws NameException {
        if (byArray == null || byArray2 == null) {
            throw new NameException("AVA data is missing.");
        }
        this.b = AttributeValueAssertion.c(byArray, 0, byArray.length);
        this.c = byArray;
        this.d = byArray2;
        this.e = 0;
        this.f = byArray2.length;
        try {
            this.a(this.d, this.e, -1);
        }
        catch (NameException nameException) {
            this.h = null;
        }
    }

    public int getAttributeType() {
        return this.b;
    }

    public int getValueType() {
        return this.g;
    }

    public void setAttributeValue(String string) {
        if (string != null) {
            this.h = string;
        }
    }

    public void setAttributeValue(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null || n3 == 0) {
            throw new NameException("BER encoding is null.");
        }
        this.d = byArray;
        this.e = n2;
        this.f = n3;
        if (this.b == -1) {
            return;
        }
        switch (this.b) {
            case 0: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray, n2, 64);
                    break;
                }
                this.a(byArray, n2, 500);
                break;
            }
            case 1: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray, n2, 2, 2);
                    break;
                }
                this.a(byArray, n2, 2);
                this.g = 4864;
                break;
            }
            case 2: {
                this.a(byArray, n2, 128);
                break;
            }
            case 3: {
                this.a(byArray, n2, 128);
                break;
            }
            case 4: {
                this.a(byArray, n2, 64);
                break;
            }
            case 5: {
                this.a(byArray, n2, 128);
                break;
            }
            case 6: {
                this.a(byArray, n2, 1, 32);
                break;
            }
            case 7: {
                this.a(byArray, n2, 64);
                break;
            }
            case 8: {
                this.a(byArray, n2, 64);
                break;
            }
            case 9: {
                this.a(byArray, n2, 128);
                break;
            }
            case 10: {
                this.a(byArray, n2, 128);
                break;
            }
            case 11: {
                this.a(byArray, n2, 40);
                break;
            }
            case 12: {
                this.a(byArray, n2, 32768);
                break;
            }
            case 13: {
                this.a(byArray, n2, 32768);
                break;
            }
            case 14: {
                this.a(byArray, n2, 1, 64);
                break;
            }
            case 15: {
                this.a(byArray, n2, 32768);
                break;
            }
            case 16: {
                this.a(byArray, n2, 32768);
                break;
            }
            case 17: {
                this.a(byArray, n2, 32768);
                break;
            }
            case 18: {
                this.a(byArray, n2, 1, -1);
                break;
            }
            case 19: {
                this.b(byArray, n2, 1, 64);
                break;
            }
            case 20: {
                this.b(byArray, n2, -1);
                break;
            }
            case 21: {
                this.a(byArray, n2, -1);
                break;
            }
            case 22: {
                this.a(byArray, n2);
                break;
            }
            case 23: {
                this.a(byArray, n2, 32768);
                break;
            }
            case 24: {
                this.a(byArray, n2, 1, 1);
                break;
            }
            case 25: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray, n2, 2, 2);
                    break;
                }
                this.a(byArray, n2, 2);
                this.g = 4864;
                break;
            }
            case 26: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(byArray, n2, 2, 2);
                    break;
                }
                this.a(byArray, n2, 2);
                this.g = 4864;
            }
        }
    }

    public String getStringAttribute() throws NameException {
        return this.getStringAttribute(true);
    }

    public String getStringAttribute(boolean bl2) throws NameException {
        boolean bl3;
        String string;
        if (this.h == null) {
            if (this.d == null) {
                throw new NameException("Cannot form the attribute's value as a String.");
            }
            return this.b();
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.h, ",+\"\\<>;", true);
        block5: while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            if (string.length() == 1) {
                char c2 = string.charAt(0);
                switch (c2) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append(c2);
                        continue block5;
                    }
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(string);
        }
        string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        stringTokenizer = new StringTokenizer(string, "#", true);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("#")) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("\\#");
                    continue;
                }
                stringBuffer.append("\\23");
                continue;
            }
            stringBuffer.append(string2);
        }
        String string3 = stringBuffer.toString();
        boolean bl4 = bl3 = string3.length() == 1;
        if (string3.startsWith(" ")) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("\\");
            stringBuffer.append(string3);
            string3 = stringBuffer.toString();
        }
        if (string3.endsWith(" ") && !bl3) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.insert(string3.length() - 1, "\\");
            string3 = stringBuffer.toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl2) {
            return string3;
        }
        for (int i2 = 0; i2 < string3.length(); ++i2) {
            char c3 = string3.charAt(i2);
            char c4 = c3;
            if (c4 > '\u0080' || c4 < ' ') {
                String string4 = string3.substring(i2, i2 + 1);
                byte[] byArray = null;
                try {
                    byArray = string4.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    stringBuffer2.append('\\');
                    String string5 = Integer.toHexString(byArray[i3] & 0xFF).toUpperCase();
                    if (string5.length() == 1) {
                        stringBuffer2.append('0');
                    }
                    stringBuffer2.append(string5);
                }
                continue;
            }
            stringBuffer2.append(c3);
        }
        return stringBuffer2.toString();
    }

    public String getStringAttributeNoEscapeSequences() throws NameException {
        if (this.h == null && this.d == null) {
            throw new NameException("Cannot form the attribute's value as a String.");
        }
        if (this.h == null) {
            return this.b();
        }
        return this.h;
    }

    protected Object clone() throws CloneNotSupportedException {
        AttributeValueAssertion attributeValueAssertion = new AttributeValueAssertion();
        attributeValueAssertion.b = this.b;
        if (this.c == null) {
            attributeValueAssertion.c = null;
        } else {
            attributeValueAssertion.c = new byte[this.c.length];
            System.arraycopy(this.c, 0, attributeValueAssertion.c, 0, this.c.length);
        }
        if (this.d == null) {
            attributeValueAssertion.d = null;
        } else {
            attributeValueAssertion.d = new byte[this.d.length];
            System.arraycopy(this.d, 0, attributeValueAssertion.d, 0, this.d.length);
        }
        attributeValueAssertion.e = this.e;
        attributeValueAssertion.f = this.f;
        attributeValueAssertion.g = this.g;
        attributeValueAssertion.h = this.h;
        return attributeValueAssertion;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AttributeValueAssertion)) {
            return false;
        }
        AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)object;
        if (!this.a(attributeValueAssertion)) {
            return false;
        }
        return this.valueEquals(attributeValueAssertion);
    }

    private boolean a(AttributeValueAssertion attributeValueAssertion) {
        if (this.c == null) {
            if (attributeValueAssertion.c == null) {
                return this.b == attributeValueAssertion.b;
            }
            byte[] byArray = AttributeValueAssertion.allNameAttributeIDs[this.b].a;
            return this.a(byArray, 0, byArray.length, attributeValueAssertion.c, 0, attributeValueAssertion.c.length);
        }
        if (attributeValueAssertion.c == null) {
            byte[] byArray = AttributeValueAssertion.allNameAttributeIDs[attributeValueAssertion.b].a;
            return this.a(this.c, 0, this.c.length, byArray, 0, byArray.length);
        }
        return this.a(this.c, 0, this.c.length, attributeValueAssertion.c, 0, attributeValueAssertion.c.length);
    }

    public boolean valueEquals(AttributeValueAssertion attributeValueAssertion) {
        if (this.h != null) {
            if (attributeValueAssertion.h == null) {
                return false;
            }
            return this.h.equals(attributeValueAssertion.h);
        }
        if (this.d != null) {
            if (attributeValueAssertion.d == null) {
                return false;
            }
            return this.a(this.d, this.e, this.f, attributeValueAssertion.d, attributeValueAssertion.e, attributeValueAssertion.f);
        }
        return false;
    }

    private boolean a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (byArray == null) {
            return byArray2 == null;
        }
        if (byArray2 == null) {
            return false;
        }
        if (n3 != n5) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[n2 + i2] == byArray2[n4 + i2]) continue;
            return false;
        }
        return true;
    }

    private static int c(byte[] byArray, int n2, int n3) {
        if (byArray == null || n3 == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < allNameAttributeIDs.length; ++i2) {
            int n4;
            if (n3 != AttributeValueAssertion.allNameAttributeIDs[i2].a.length) continue;
            for (n4 = 0; n4 < n3 && (byArray[n4 + n2] & 0xFF) == (AttributeValueAssertion.allNameAttributeIDs[i2].a[n4] & 0xFF); ++n4) {
            }
            if (n4 < n3) continue;
            return i2;
        }
        return -1;
    }

    protected static int findAttributeType(String string) {
        int n2;
        if (string == null) {
            return -1;
        }
        for (n2 = 0; n2 < allNameAttributeIDs.length; ++n2) {
            if (!string.equalsIgnoreCase(AttributeValueAssertion.allNameAttributeIDs[n2].b)) continue;
            return n2;
        }
        for (n2 = 0; n2 < alternativeAttributeNames.length; ++n2) {
            if (!string.equalsIgnoreCase(AttributeValueAssertion.alternativeAttributeNames[n2].b)) continue;
            return AttributeValueAssertion.alternativeAttributeNames[n2].a;
        }
        return -1;
    }

    protected static byte[] getAttributeOID(int n2) {
        if (n2 < 0 || n2 >= allNameAttributeIDs.length) {
            return null;
        }
        return AttributeValueAssertion.allNameAttributeIDs[n2].a;
    }

    private void a(int n2, int n3, String string) throws NameException {
        if (string == null) {
            throw new NameException("AVA value is null.");
        }
        switch (n2) {
            case 0: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(n3, string, 64);
                    break;
                }
                this.a(n3, string, 500);
                break;
            }
            case 1: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(n3, string, 2, 2);
                    break;
                }
                this.a(n3, string, 2);
                this.g = 4864;
                break;
            }
            case 2: {
                this.a(n3, string, 128);
                break;
            }
            case 3: {
                this.a(n3, string, 128);
                break;
            }
            case 4: {
                this.a(n3, string, 64);
                break;
            }
            case 5: {
                this.a(n3, string, 128);
                break;
            }
            case 6: {
                this.a(n3, string, 1, 32);
                break;
            }
            case 7: {
                this.b(n3, string, 1, 64);
                break;
            }
            case 8: {
                this.a(n3, string, 64);
                break;
            }
            case 9: {
                this.a(n3, string, 128);
                break;
            }
            case 10: {
                this.a(n3, string, 128);
                break;
            }
            case 11: {
                this.a(n3, string, 40);
                break;
            }
            case 12: {
                this.a(n3, string, 32768);
                break;
            }
            case 13: {
                this.a(n3, string, 32768);
                break;
            }
            case 14: {
                this.a(n3, string, 1, 64);
                break;
            }
            case 15: {
                this.a(n3, string, 32768);
                break;
            }
            case 16: {
                this.a(n3, string, 32768);
                break;
            }
            case 17: {
                this.a(n3, string, 32768);
                break;
            }
            case 18: {
                this.a(n3, string, 1, -1);
                break;
            }
            case 19: {
                this.b(n3, string, 1, 64);
                break;
            }
            case 20: {
                this.a(n3, string, -1);
                break;
            }
            case 21: {
                this.a(n3, string, -1);
                break;
            }
            case 22: {
                this.a(n3, string);
                break;
            }
            case 23: {
                this.a(n3, string, 32768);
                break;
            }
            case 24: {
                this.a(n3, string, 1, 1);
                break;
            }
            case 25: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(n3, string, 2, 2);
                    break;
                }
                this.a(n3, string, 2);
                this.g = 4864;
                break;
            }
            case 26: {
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                    this.a(n3, string, 2, 2);
                    break;
                }
                this.a(n3, string, 2);
                this.g = 4864;
            }
        }
    }

    private void a(int n2, String string, int n3) throws NameException {
        if (n2 != 4864 && n2 != 5120 && n2 != 7168 && n2 != 3072 && n2 != 7680 && n2 != 5632) {
            throw new NameException("DirectoryString expected.");
        }
        if (string.length() < 1) {
            throw new NameException("DirectoryString too small.");
        }
        if (n3 != -1 && string.length() > n3) {
            throw new NameException("DirectoryString too large.");
        }
    }

    private void a(int n2, String string, int n3, int n4) throws NameException {
        if (n2 != 4864) {
            throw new NameException("PrintableString expected.");
        }
        if (n3 != -1 && string.length() < n3) {
            throw new NameException("PrintableString too small.");
        }
        if (n4 != -1 && string.length() > n4) {
            throw new NameException("PrintableString too large.");
        }
    }

    private void a(int n2, String string) throws NameException {
        if (n2 != 6144) {
            throw new NameException("GenTime is expected expected.");
        }
    }

    private void b(int n2, String string, int n3, int n4) throws NameException {
        if (n2 != 5632) {
            throw new NameException("IA5String expected.");
        }
        if (n3 != -1 && string.length() < n3) {
            throw new NameException("IA5String too small.");
        }
        if (n4 != -1 && string.length() > n4) {
            throw new NameException("IA5String too large.");
        }
    }

    private boolean a(int n2) {
        if (n2 == 4864) {
            return true;
        }
        if (n2 == 5120) {
            return true;
        }
        if (n2 == 7168) {
            return true;
        }
        if (n2 == 5632) {
            return true;
        }
        if (n2 == 7680) {
            return true;
        }
        if (n2 == 3072) {
            return true;
        }
        return n2 == 6144;
    }

    void a(byte[] byArray, int n2, int n3) throws NameException {
        IA5StringContainer iA5StringContainer;
        UTF8StringContainer uTF8StringContainer;
        BMPStringContainer bMPStringContainer;
        UniversalStringContainer universalStringContainer;
        TeletexStringContainer teletexStringContainer;
        PrintStringContainer printStringContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            printStringContainer = new PrintStringContainer(0, 1, n3);
            teletexStringContainer = new TeletexStringContainer(0, 1, n3);
            universalStringContainer = new UniversalStringContainer(0, 1, n3);
            bMPStringContainer = new BMPStringContainer(0, 1, n3);
            uTF8StringContainer = new UTF8StringContainer(0);
            iA5StringContainer = new IA5StringContainer(0, 1, n3);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, uTF8StringContainer, bMPStringContainer, iA5StringContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("DirectoryString expected.");
        }
        if (printStringContainer.dataPresent) {
            this.g = 4864;
            this.h = printStringContainer.getValueAsString();
        } else if (teletexStringContainer.dataPresent) {
            this.g = 5120;
            this.h = teletexStringContainer.getValueAsString();
        } else if (universalStringContainer.dataPresent) {
            this.g = 7168;
            this.h = universalStringContainer.getValueAsString();
        } else if (bMPStringContainer.dataPresent) {
            this.g = 7680;
            this.h = bMPStringContainer.getValueAsString();
        } else if (uTF8StringContainer.dataPresent) {
            this.g = 3072;
            this.h = this.d(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
        } else if (iA5StringContainer.dataPresent) {
            this.g = 5632;
            this.h = iA5StringContainer.getValueAsString();
        } else {
            throw new NameException("DirectoryString expected.");
        }
    }

    void b(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, new EncodedContainer(65280));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            EncodedContainer encodedContainer = null;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < ofContainer.getContainerCount(); ++i2) {
                encodedContainer = (EncodedContainer)ofContainer.containerAt(i2);
                this.a(encodedContainer.data, encodedContainer.dataOffset, n3);
                if (i2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.h);
            }
            this.h = stringBuffer.toString();
            this.g = 3072;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid encoding. " + aSN_Exception.getMessage());
        }
    }

    void a(byte[] byArray, int n2, int n3, int n4) throws NameException {
        PrintStringContainer printStringContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            printStringContainer = new PrintStringContainer(0, n3, n4);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{printStringContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("PrintableString expected.");
        }
        this.g = 4864;
        this.h = printStringContainer.getValueAsString();
    }

    void a(byte[] byArray, int n2) throws NameException {
        Object object;
        GenTimeContainer genTimeContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            genTimeContainer = new GenTimeContainer(0);
            object = new ASN1Container[]{genTimeContainer};
            ASN1.berDecode(byArray, n2, (ASN1Container[])object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("GenTime expected." + aSN_Exception.getMessage());
        }
        this.g = 6144;
        object = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z");
        this.h = ((DateFormat)object).format(genTimeContainer.theTime);
    }

    void b(byte[] byArray, int n2, int n3, int n4) throws NameException {
        IA5StringContainer iA5StringContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            iA5StringContainer = new IA5StringContainer(0, n3, n4);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{iA5StringContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("IA5String expected.");
        }
        this.g = 5632;
        this.h = iA5StringContainer.getValueAsString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl2) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.h != null) {
                string = this.getStringAttribute(bl2);
            }
        }
        catch (NameException nameException) {
            // empty catch block
        }
        if (this.b == -1) {
            stringBuffer.append(this.a());
            stringBuffer.append("=");
            if (string != null) {
                stringBuffer.append(string);
            } else if (this.d != null) {
                stringBuffer.append(this.b());
            }
        } else {
            if (this.b == 7 && CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_EMAIL_AVA_EA)) {
                stringBuffer.append("Ea");
            } else {
                stringBuffer.append(AttributeValueAssertion.allNameAttributeIDs[this.b].b);
            }
            stringBuffer.append("=");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String a() {
        if (this.c == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        stringBuffer = stringBuffer.append((this.c[n2] & 0xFF) / 40);
        stringBuffer = stringBuffer.append('.');
        stringBuffer = stringBuffer.append((this.c[n2] & 0xFF) % 40);
        ++n2;
        while (n2 < this.c.length) {
            stringBuffer = stringBuffer.append('.');
            do {
                n3 = (n3 << 7) + (this.c[n2] & 0x7F & 0xFF);
            } while ((this.c[n2++] & 0x80) != 0 && n2 < this.c.length);
            stringBuffer = stringBuffer.append(n3);
            n3 = 0;
        }
        return stringBuffer.toString();
    }

    private String b() {
        if (this.d == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("#");
        for (int i2 = this.e; i2 < this.f + this.e; ++i2) {
            int n2 = this.d[i2] & 0xFF;
            String string = Integer.toHexString(n2);
            if (string.length() == 1) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer = stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private ASN1Container c() throws NameException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(this.h, parsePosition);
        return new GenTimeContainer(0, true, 0, date);
    }

    private ASN1Container a(int n2, int n3) throws NameException {
        try {
            ASN1Container aSN1Container = this.b(n2, n3);
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, aSN1Container, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            int n4 = this.asn1Template.derEncodeInit();
            byte[] byArray = new byte[n4];
            n4 = this.asn1Template.derEncode(byArray, 0);
            return new EncodedContainer(12288, true, 0, byArray, 0, n4);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid String." + aSN_Exception.getMessage());
        }
    }

    private ASN1Container b(int n2, int n3) throws NameException {
        try {
            switch (this.g) {
                case 4864: {
                    return new PrintStringContainer(0, true, 0, this.h, n2, n3);
                }
                case 5120: {
                    return new TeletexStringContainer(0, true, 0, this.h, n2, n3);
                }
                case 7168: {
                    return new UniversalStringContainer(0, true, 0, this.h, n2, n3);
                }
                case 5632: {
                    return new IA5StringContainer(0, true, 0, this.h, n2, n3);
                }
                case 3072: {
                    byte[] byArray = this.a(this.h);
                    if (byArray.length < 2) {
                        throw new NameException("AttributeValueAssertion.createStringContainer: DataOutputStream.writeUTF() did not contain necessary 2 bytes specifying the encoding length.");
                    }
                    return new UTF8StringContainer(0, true, 0, byArray, 2, byArray.length - 2);
                }
                case 7680: {
                    return new BMPStringContainer(0, true, 0, this.h, n2, n3);
                }
            }
            return null;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid String." + aSN_Exception.getMessage());
        }
    }

    private byte[] a(String string) throws NameException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new NameException("AttributeValueAssertion.utf8Encode: unable to utf8-encode " + string + "(" + iOException.getMessage() + ").");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String d(byte[] byArray, int n2, int n3) throws NameException {
        byte[] byArray2 = new byte[n3 + 2];
        byArray2[0] = (byte)(n3 >> 8 & 0xFF);
        byArray2[1] = (byte)(n3 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, 2, n3);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, byArray2.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            throw new NameException("AttributeValueAssertion.utf8Decode: " + iOException.getMessage() + ").");
        }
    }

    public int getDERLen() {
        try {
            Object object;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            OIDContainer oIDContainer = null;
            if (this.b != -1) {
                object = AttributeValueAssertion.allNameAttributeIDs[this.b].a;
                oIDContainer = new OIDContainer(0x1000000, true, 0, (byte[])object, 0, ((byte[])object).length);
            } else {
                oIDContainer = new OIDContainer(0x1000000, true, 0, this.c, 0, this.c.length);
            }
            try {
                switch (this.b) {
                    case 0: {
                        if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
                            object = this.b(1, 64);
                            break;
                        }
                        object = this.b(1, 500);
                        break;
                    }
                    case 1: {
                        object = this.b(2, 2);
                        break;
                    }
                    case 2: {
                        object = this.b(1, 128);
                        break;
                    }
                    case 3: {
                        object = this.b(1, 128);
                        break;
                    }
                    case 4: {
                        object = this.b(1, 64);
                        break;
                    }
                    case 5: {
                        object = this.b(1, 128);
                        break;
                    }
                    case 6: {
                        object = this.b(1, 32);
                        break;
                    }
                    case 7: {
                        object = this.b(1, 64);
                        break;
                    }
                    case 8: {
                        object = this.b(1, 64);
                        break;
                    }
                    case 9: {
                        object = this.b(1, 128);
                        break;
                    }
                    case 10: {
                        object = this.b(1, 128);
                        break;
                    }
                    case 11: {
                        object = this.b(1, 40);
                        break;
                    }
                    case 12: {
                        object = this.b(1, 32768);
                        break;
                    }
                    case 13: {
                        object = this.b(1, 32768);
                        break;
                    }
                    case 14: {
                        object = this.b(1, 64);
                        break;
                    }
                    case 15: {
                        object = this.b(1, 32768);
                        break;
                    }
                    case 16: {
                        object = this.b(1, 32768);
                        break;
                    }
                    case 17: {
                        object = this.b(1, 32768);
                        break;
                    }
                    case 18: {
                        object = this.b(1, -1);
                        break;
                    }
                    case 19: {
                        object = this.b(1, 64);
                        break;
                    }
                    case 20: {
                        object = this.a(1, -1);
                        break;
                    }
                    case 21: {
                        object = this.b(1, -1);
                        break;
                    }
                    case 22: {
                        object = this.c();
                        break;
                    }
                    case 23: {
                        object = this.b(1, 32768);
                        break;
                    }
                    case 24: {
                        object = this.b(1, 1);
                        break;
                    }
                    case 25: {
                        object = this.b(2, 2);
                        break;
                    }
                    case 26: {
                        object = this.b(2, 2);
                        break;
                    }
                    default: {
                        if (this.g == UNSUPPORTED_ASN1_TYPE) {
                            object = new EncodedContainer(65280, true, 0, this.d, this.e, this.f);
                            break;
                        }
                        object = this.b(-1, -1);
                        break;
                    }
                }
            }
            catch (NameException nameException) {
                return 0;
            }
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, object, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getDEREncoding(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3;
            if (this.asn1Template == null && (n3 = this.getDERLen()) == 0) {
                throw new NameException("Could not encode AVA. ");
            }
            n3 = this.asn1Template.derEncode(byArray, n2);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Could not encode: " + aSN_Exception.getMessage());
        }
    }
}

