/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CompatibilityType;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.Service;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.pkcs12.PKCS12;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.provider.random.DefaultRandom;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathInterface;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.certj.spi.random.RandomInterface;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import java.io.File;
import java.util.Vector;

public final class CertJ {
    public static final int SPT_RANDOM = 0;
    public static final int SPT_DATABASE = 1;
    public static final int SPT_CERT_STATUS = 2;
    public static final int SPT_CERT_PATH = 3;
    public static final int SPT_PKI = 4;
    private static final int a = 0;
    private static final int b = 4;
    public static final int SERVICE_ORDER_FIRST = 0;
    public static final int SERVICE_ORDER_LAST = 1;
    public static final String CERT_J_VERSION = "2.1.2.0";
    private static String c = "Native/Java";
    private Vector[] d = new Vector[5];
    private String e;
    private JSAFE_Session[] f = null;
    private static Vector g = new Vector(1);
    private static boolean h = false;
    public static final int NOT_INITIALIZED = 0;
    public static final int UNDER_SELF_TEST = 1;
    public static final int OPERATIONAL = 2;
    public static final int FAILED = 3;
    public static final int FIPS_MODE = 0;
    public static final int NON_FIPS_MODE = 1;
    public static final int FIPS_TESTING_MODE = 2;
    public static final int CRYPTO_OFFICER_ROLE = 0;
    public static final int USER_ROLE = 1;

    public void setPKCS11Sessions(JSAFE_Session[] jSAFE_SessionArray) {
        this.f = jSAFE_SessionArray;
    }

    public JSAFE_Session[] getPKCS11Sessions() {
        return this.f;
    }

    public static String getDefaultDevice() {
        return c;
    }

    public static void setDefaultDevice(String string) {
        c = string;
    }

    public CertJ() throws ProviderManagementException, InvalidUseException {
        this(null);
    }

    public CertJ(Provider[] providerArray) throws ProviderManagementException, InvalidUseException {
        int n2;
        CertJ.isFIPS140Compliant();
        this.e = c;
        for (n2 = 0; n2 <= 4; ++n2) {
            this.d[n2] = new Vector();
        }
        try {
            if (providerArray != null) {
                for (n2 = 0; n2 < providerArray.length; ++n2) {
                    this.registerService(providerArray[n2], 1);
                }
            }
            if (this.d[0].size() == 0) {
                this.registerService(new DefaultRandom("Default Random"), 1);
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            this.unregisterAll();
            throw new ProviderManagementException("CertJ.CertJ: " + invalidParameterException.getMessage());
        }
        catch (ProviderManagementException providerManagementException) {
            this.unregisterAll();
            throw providerManagementException;
        }
    }

    public void unregisterAll() {
        for (int i2 = 0; i2 <= 4; ++i2) {
            Vector vector = this.d[i2];
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                try {
                    this.unregisterService(i2, ((ProviderImplementation)vector.elementAt(i3)).getName());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            vector.removeAllElements();
        }
    }

    public void registerService(Provider provider) throws InvalidParameterException, ProviderManagementException {
        this.registerService(provider, 1);
    }

    public void registerService(Provider provider, int n2) throws InvalidParameterException, ProviderManagementException {
        Object object;
        if (provider == null) {
            throw new InvalidParameterException("CertJ.registerService: provider can not be null.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new InvalidParameterException("CertJ.registerService: order should be either SERVICE_ORDER_LAST or SERVICE_ORDER_FIRST.");
        }
        if (provider.getName() == null) {
            throw new ProviderManagementException("CertJ.registerService: provider has to have a name.");
        }
        int n3 = provider.getType();
        if (n3 < 0 || n3 > 4) {
            throw new ProviderManagementException("CertJ.registerService: service type(" + n3 + ") of the provider is not between " + 0 + " and " + 4 + ".");
        }
        if (n3 == 0) {
            if (this.d[0] != null && this.d[0].size() != 0) {
                throw new ProviderManagementException("CertJ.registerService: a random service is already registered. Do unregister it first.");
            }
        } else {
            object = null;
            try {
                object = this.bindService(provider.getType(), provider.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                this.unbindService((Service)object);
                throw new ProviderManagementException("CertJ.registerService: " + CertJ.serviceTypeToString(provider.getType()) + " service named " + provider.getName() + " is already registered.");
            }
        }
        object = provider.instantiate(this);
        Vector vector = this.d[n3];
        switch (n2) {
            case 0: {
                vector.insertElementAt(object, 0);
                break;
            }
            case 1: {
                vector.addElement(object);
            }
        }
    }

    public void unregisterService(int n2, String string) throws InvalidParameterException {
        if (n2 < 0 || n2 > 4) {
            throw new InvalidParameterException("CertJ.unregisterService: type (" + n2 + ") is not between SPT_FIRST and SPT_LAST.");
        }
        if (string == null) {
            throw new InvalidParameterException("CertJ.unregisterService: name should not be null.");
        }
        Vector vector = this.d[n2];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ProviderImplementation providerImplementation = (ProviderImplementation)vector.elementAt(i2);
            if (!providerImplementation.getName().equals(string)) continue;
            providerImplementation.unregister();
            vector.removeElementAt(i2);
            break;
        }
    }

    public void addProvider(Provider provider) throws InvalidParameterException, ProviderManagementException {
        this.registerService(provider);
    }

    public void addProvider(Provider provider, int n2) throws InvalidParameterException, ProviderManagementException {
        this.registerService(provider, n2);
    }

    public void removeProvider(int n2, String string) throws InvalidParameterException {
        this.unregisterService(n2, string);
    }

    public Service bindService(int n2, String string) throws InvalidParameterException, ProviderManagementException {
        String[] stringArray = new String[1];
        if (string == null) {
            Vector vector = this.d[n2];
            if (vector.size() == 0) {
                throw new ProviderManagementException("CertJ.bindService: no provider is registered for type" + CertJ.serviceTypeToString(n2));
            }
            stringArray[0] = ((ProviderImplementation)vector.elementAt(0)).getName();
        } else {
            stringArray[0] = string;
        }
        return this.bindServices(n2, stringArray);
    }

    public Service bindServices(int n2, String[] stringArray) throws InvalidParameterException, ProviderManagementException {
        if (n2 < 0 || n2 > 4) {
            throw new InvalidParameterException("CertJ.bindServices: type (" + n2 + ") is not between SPT_FIRST and SPT_LAST.");
        }
        if (stringArray == null) {
            return this.bindServices(n2);
        }
        Vector vector = this.d[n2];
        Service service = Service.getInstance(this, n2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            boolean bl2 = false;
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                ProviderImplementation providerImplementation = (ProviderImplementation)vector.elementAt(i3);
                if (!string.equals(providerImplementation.getName())) continue;
                service.addProvider(providerImplementation);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            throw new ProviderManagementException("CertJ.bindServices: provider of type: " + CertJ.serviceTypeToString(n2) + " with name: " + stringArray[i2] + " not found.");
        }
        return service;
    }

    public Service bindServices(int n2) throws InvalidParameterException, ProviderManagementException {
        if (n2 < 0 || n2 > 4) {
            throw new InvalidParameterException("CertJ.bindServices: type (" + n2 + ") is not between SPT_FIRST and SPT_LAST.");
        }
        Service service = Service.getInstance(this, n2);
        Vector vector = this.d[n2];
        if (vector.size() == 0) {
            throw new ProviderManagementException("CertJ.bindServices: no providere is registered for type: " + CertJ.serviceTypeToString(n2));
        }
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            service.addProvider((ProviderImplementation)vector.elementAt(i2));
        }
        return service;
    }

    public void unbindService(Service service) {
        service.unbind();
    }

    public String[] listAllProviders() {
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 <= 4; ++i2) {
            Vector vector2 = this.d[i2];
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                vector.addElement(vector2.elementAt(i3).toString());
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int i4 = 0; i4 < vector.size(); ++i4) {
            stringArray[i4] = (String)vector.elementAt(i4);
        }
        return stringArray;
    }

    public String[] listProviderNames(int n2) {
        Vector vector = this.d[n2];
        Vector<String> vector2 = new Vector<String>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            vector2.addElement(((ProviderImplementation)vector.elementAt(i2)).getName());
        }
        String[] stringArray = new String[vector2.size()];
        for (int i3 = 0; i3 < vector2.size(); ++i3) {
            stringArray[i3] = (String)vector2.elementAt(i3);
        }
        return stringArray;
    }

    public JSAFE_SecureRandom getRandomObject() throws NoServiceException, RandomException {
        if (this.d[0].size() == 0) {
            throw new NoServiceException("CertJ.getRandomObject: no random service is registered.");
        }
        RandomInterface randomInterface = (RandomInterface)this.d[0].elementAt(0);
        try {
            return randomInterface.getRandomObject();
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("CertJ.getRandomObject: " + notSupportedException.getMessage());
        }
    }

    public String getDevice() {
        return this.e;
    }

    public void setDevice(String string) {
        this.e = string;
    }

    public boolean verifyCertPath(CertPathCtx certPathCtx, Object object) throws InvalidParameterException, NoServiceException, CertPathException {
        return this.buildCertPath(certPathCtx, object, null, null, null, null);
    }

    public boolean buildCertPath(CertPathCtx certPathCtx, Object object, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws InvalidParameterException, NoServiceException, CertPathException {
        if (certPathCtx == null) {
            throw new InvalidParameterException("CertJ.buildCertPath: pathCtx should not be null.");
        }
        if (!(object instanceof Certificate) && !(object instanceof CRL)) {
            throw new InvalidParameterException("CertJ.buildCertPath: startObject should be either Certificate or CRL.");
        }
        Vector vector5 = this.d[3];
        for (int i2 = 0; i2 < vector5.size(); ++i2) {
            try {
                return ((CertPathInterface)vector5.elementAt(i2)).buildCertPath(certPathCtx, object, vector, vector2, vector3, vector4);
            }
            catch (NotSupportedException notSupportedException) {
                continue;
            }
        }
        throw new NoServiceException("CertJ.buildCertPath: no provider is found to handle this method.");
    }

    public void getNextCertInPath(CertPathCtx certPathCtx, Object object, Vector vector) throws InvalidParameterException, NoServiceException, CertPathException {
        if (certPathCtx == null) {
            throw new InvalidParameterException("CertJ.getNextCertInPath: pathCtx should not be null.");
        }
        if (!(object instanceof Certificate) && !(object instanceof CRL)) {
            throw new InvalidParameterException("CertJ.getNextCertInPath: baseObject should be either Certificate or CRL.");
        }
        Vector vector2 = this.d[3];
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            try {
                ((CertPathInterface)vector2.elementAt(i2)).getNextCertInPath(certPathCtx, object, vector);
                return;
            }
            catch (NotSupportedException notSupportedException) {
                continue;
            }
        }
        throw new NoServiceException("CertJ.getNextCertInPath: no provider is found to handle this method.");
    }

    public boolean validateCertificate(CertPathCtx certPathCtx, Certificate certificate, JSAFE_PublicKey jSAFE_PublicKey) throws InvalidParameterException, NoServiceException, CertPathException {
        if (certPathCtx == null) {
            throw new InvalidParameterException("CertJ.validateCertificate: pathCtx should not be null.");
        }
        if (certificate == null) {
            throw new InvalidParameterException("CertJ.validateCertificate: cert should not be null.");
        }
        if (jSAFE_PublicKey == null) {
            throw new InvalidParameterException("CertJ.validateCertificate: validationKey should not be null.");
        }
        Vector vector = this.d[3];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            try {
                return ((CertPathInterface)vector.elementAt(i2)).validateCertificate(certPathCtx, certificate, jSAFE_PublicKey);
            }
            catch (NotSupportedException notSupportedException) {
                continue;
            }
        }
        throw new NoServiceException("CertJ.validateCertificate: no provider is found to handle this method.");
    }

    public CertRevocationInfo checkCertRevocation(CertPathCtx certPathCtx, Certificate certificate) throws InvalidParameterException, NoServiceException, CertStatusException {
        if (certPathCtx == null) {
            throw new InvalidParameterException("CertJ.checkCertRevocation: pathCtx should not be null.");
        }
        if (certificate == null) {
            throw new InvalidParameterException("CertJ.checkCertRevocation: cert should not be null.");
        }
        Vector vector = this.d[2];
        CertRevocationInfo certRevocationInfo = null;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            try {
                CertRevocationInfo certRevocationInfo2 = ((CertStatusInterface)vector.elementAt(i2)).checkCertRevocation(certPathCtx, certificate);
                if (certRevocationInfo2.getStatus() == 2) {
                    if (certRevocationInfo == null) {
                        certRevocationInfo = certRevocationInfo2;
                    }
                    continue;
                }
                return certRevocationInfo2;
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        if (certRevocationInfo != null) {
            return certRevocationInfo;
        }
        throw new NoServiceException("CertJ.checkCertRevocation: no provider is found to handle this method or no registered provider can determine the revocation status of the given certificate.");
    }

    public void importPKCS12(String string, char[] cArray, DatabaseService databaseService) throws PKCS12Exception {
        new PKCS12(this, databaseService, cArray, string);
    }

    public void importPKCS12(File file, char[] cArray, DatabaseService databaseService) throws PKCS12Exception {
        new PKCS12(this, databaseService, cArray, file);
    }

    public static String serviceTypeToString(int n2) {
        switch (n2) {
            case 0: {
                return "SPT_RANDOM";
            }
            case 1: {
                return "SPT_DATABASE";
            }
            case 2: {
                return "SPT_CERT_STATUS";
            }
            case 3: {
                return "SPT_CERT_PATH";
            }
            case 4: {
                return "SPT_PKI";
            }
        }
        return "Unknown service type: " + n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCompatibilityType(CompatibilityType compatibilityType) {
        Vector vector = g;
        synchronized (vector) {
            if (!g.contains(compatibilityType)) {
                g.addElement(compatibilityType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCompatibilityType(CompatibilityType compatibilityType) {
        Vector vector = g;
        synchronized (vector) {
            g.removeElement(compatibilityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompatibilityTypeSet(CompatibilityType compatibilityType) {
        boolean bl2;
        Vector vector = g;
        synchronized (vector) {
            bl2 = g.contains(compatibilityType);
        }
        return bl2;
    }

    public static final boolean isFIPS140Compliant() throws InvalidUseException {
        boolean bl2 = CryptoJ.isFIPS140Compliant();
        if (bl2 && !h || !bl2 && h) {
            throw new InvalidUseException("Attempt to mix FIPS compliant and non-complaint versions of Cert-J and Crypto-J");
        }
        return h;
    }

    public static int getState() {
        return CryptoJ.getState();
    }

    public static int getMode() {
        return CryptoJ.getMode();
    }

    public static void setMode(int n2) throws InvalidUseException {
        try {
            CryptoJ.setMode(n2);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new InvalidUseException(jSAFE_InvalidUseException.getMessage());
        }
    }

    public static int getRole() {
        return CryptoJ.getRole();
    }

    public static void setRole(int n2) throws InvalidUseException {
        try {
            CryptoJ.setRole(n2);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new InvalidUseException(jSAFE_InvalidUseException.getMessage());
        }
    }

    public static boolean selfTestPassed() {
        return CryptoJ.selfTestPassed();
    }

    public static synchronized boolean runSelfTests() throws InvalidUseException {
        try {
            return CryptoJ.runSelfTests();
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new InvalidUseException(jSAFE_InvalidUseException.getMessage());
        }
    }
}

