/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator20;
import com.adobe.air.validator.DescriptorValidator;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorValidator25
extends ApplicationDescriptorValidator20 {
    public static final String PROFILE_TV = "tv";
    public static final String PROFILE_EXTENDED_TV = "extendedTV";
    private String _versionLabel = "";
    private String _versionNumber = "";
    private String _manifestAdditions;
    private Set<String> _requiredExtensions = new HashSet<String>();

    public ApplicationDescriptorValidator25() {
        this.getValidProfiles().add(PROFILE_TV);
        this.getValidProfiles().add(PROFILE_EXTENDED_TV);
    }

    @Override
    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        DescriptorValidator.ElementInfo temp = root.getChild("fileTypes").getChild("fileType").getChild("icon");
        temp.addChild(new DescriptorValidator.ElementInfo("image36x36", 0, 1));
        temp = root.getChild("icon");
        temp.addChild(new DescriptorValidator.ElementInfo("image36x36", 0, 1));
        DescriptorValidator.ElementInfo removeVersion = root.getChild("version");
        root.removeChild(removeVersion);
        root.addChild(new DescriptorValidator.ElementInfo("versionNumber", 1, 1));
        root.addChild(new DescriptorValidator.ElementInfo("versionLabel", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("extensions", 0, 1));
        temp = root.getChild("extensions");
        temp.addChild(new DescriptorValidator.ElementInfo("extensionID", 0, -1));
        root.addChild(new DescriptorValidator.ElementInfo("android", 0, 1));
        temp = root.getChild("android");
        temp.addChild(new DescriptorValidator.ElementInfo("manifestAdditions", 0, 1));
        return root;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        String imageUri;
        int size;
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.icon.image36x36")) {
            size = this.getIntFromIconSize(elementPath);
            imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
            this._appIcons.put(this.getIntFromIconSize(elementPath), imageUri);
        }
        if (elementPath.equals("application.fileTypes.fileType.icon.image36x36")) {
            size = this.getIntFromIconSize(elementPath);
            imageUri = this.validateImageUri(value, size, size);
            boolean bl2 = valid = imageUri != null;
        }
        if (elementPath.equals("application.version")) {
            return false;
        }
        if (elementPath.equals("application.extensions.extensionID")) {
            if (!ApplicationDescriptorValidator25.validateAppId(value)) {
                return false;
            }
            if (this._requiredExtensions.contains(value)) {
                this.dispatchError(109, new String[]{"extensionID", value});
            }
            this._requiredExtensions.add(value);
        }
        if (elementPath.equals("application.versionNumber")) {
            this._versionNumber = value;
            return ApplicationDescriptorValidator.validateVersionNumber(value);
        }
        if (elementPath.equals("application.versionLabel")) {
            this._versionLabel = value;
        }
        if (elementPath.equals("application.android.manifestAdditions")) {
            String manifestAdditions = "<list><dict>" + value + "</dict></list>";
            valid = this.validateManifestAdditions(manifestAdditions);
            this._manifestAdditions = value;
        }
        return valid;
    }

    @Override
    protected void finalizeValidation() throws SAXException {
        super.finalizeValidation();
        if (this._requiredExtensions.size() > 0 && this.supportedProfiles().size() == 1 && this.supportedProfiles().contains("desktop")) {
            this.dispatchError(111, null);
        }
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/2.5";
    }

    public String versionLabel() {
        return this._versionLabel.equals("") ? this._versionNumber : this._versionLabel;
    }

    public String versionNumber() {
        return this._versionNumber;
    }

    public Set<String> getRequiredExtensions() {
        return this._requiredExtensions;
    }

    public String manifestAdditions() {
        return this._manifestAdditions;
    }
}

