/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ADTException;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.ucf.UCF;
import com.adobe.ucf.UCFOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

public class EXEPackager
extends NativePackager {
    private File m_tempExecutable;
    private File m_installApp;
    private File m_launch;

    public EXEPackager() {
        super("Windows-x86", false, false);
    }

    public void setNativeSigningOptions(UCF.SigningOptions options) {
        this.m_nativeSigningOptions = options;
        String noParam = "\"\"";
        if (this.m_nativeSigningOptions.storeType == null) {
            this.m_nativeSigningOptions.storeType = noParam;
        }
        if (this.m_nativeSigningOptions.keyStoreFile == null) {
            this.m_nativeSigningOptions.keyStoreFile = noParam;
        }
        if (this.m_nativeSigningOptions.storePass == null) {
            this.m_nativeSigningOptions.storePass = noParam;
        }
        if (this.m_nativeSigningOptions.alias == null) {
            this.m_nativeSigningOptions.alias = noParam;
        }
        if (this.m_nativeSigningOptions.providerName == null) {
            this.m_nativeSigningOptions.providerName = noParam;
        }
        if (this.m_nativeSigningOptions.keyPass == null) {
            this.m_nativeSigningOptions.keyPass = noParam;
        }
        if (this.m_nativeSigningOptions.timestampURL == null) {
            this.m_nativeSigningOptions.timestampURL = noParam;
        }
    }

    protected void assembleInternalFiles() throws IOException, SDKDamagedException {
        File bootstrapper = new File(this.getNAISDKLibDir(), "naib.exe");
        if (!bootstrapper.exists()) {
            throw new SDKDamagedException(bootstrapper.getPath());
        }
        this.m_installApp = new File(this.getTempFile(), "Install " + this.m_appName + ".exe").getCanonicalFile();
        Utils.copyTo(bootstrapper, this.m_installApp);
        this.m_launch = new File(this.getTempFile(), ".launch");
        FileOutputStream launchOut = new FileOutputStream(this.m_launch);
        ((OutputStream)launchOut).write(this.m_installApp.getName().getBytes("UTF-8"));
        ((OutputStream)launchOut).close();
    }

    protected void signInternalFiles() throws IOException, SDKDamagedException, GeneralSecurityException {
        File msi = new File(this.m_conversionOutput, "setup.msi");
        this.signFile(msi);
        File appEntry = new File(this.m_conversionOutput, this.m_appName + ".exe").getCanonicalFile();
        this.signFile(appEntry);
    }

    protected void createFinalPackage() throws IOException, SDKDamagedException {
        File zip = new File(this.getTempFile(), "temp.zip");
        UCFOutputStream zipOut = new UCFOutputStream();
        zipOut.setOutput(zip);
        this.addToZip(zipOut, this.m_installApp, this.m_installApp.getName());
        this.addToZip(zipOut, this.m_launch, this.m_launch.getName());
        this.addToZip(zipOut, this.m_conversionOutput, this.m_appName);
        zipOut.close();
        File sea = new File(this.getNAISDKLibDir(), "sea.exe");
        if (!sea.exists()) {
            throw new SDKDamagedException(sea.getPath());
        }
        this.m_tempExecutable = new File(this.getTempFile(), "temp.exe");
        FileOutputStream installerOut = new FileOutputStream(this.m_tempExecutable);
        FileInputStream seaIn = new FileInputStream(sea);
        Utils.copyTo(seaIn, installerOut);
        ((InputStream)seaIn).close();
        FileInputStream zipIn = new FileInputStream(zip);
        Utils.copyTo(zipIn, installerOut);
        ((InputStream)zipIn).close();
        ((OutputStream)installerOut).close();
    }

    protected void signFinalPackage() throws IOException, SDKDamagedException, GeneralSecurityException {
        if (!this.m_tempExecutable.exists()) {
            throw new IllegalStateException("File " + this.m_tempExecutable + " failed to generate");
        }
        this.signFile(this.m_tempExecutable);
    }

    protected void finalizePackage() throws IOException {
        Utils.copyTo(this.m_tempExecutable, this.getOutput());
    }

    private void signFile(File fileToSign) throws IOException, SDKDamagedException, GeneralSecurityException {
        File signer = new File(this.getNAISDKBinDir(), "nais.exe");
        if (!signer.exists()) {
            throw new SDKDamagedException("lib/" + signer.getName());
        }
        if (!fileToSign.exists()) {
            throw new IOException("Missing " + fileToSign.getName());
        }
        try {
            Process signing = new ProcessBuilder(signer.getAbsolutePath(), this.m_nativeSigningOptions.storeType, this.m_nativeSigningOptions.keyStoreFile, this.m_nativeSigningOptions.storePass, this.m_nativeSigningOptions.alias, this.m_nativeSigningOptions.providerName, this.m_nativeSigningOptions.keyPass, this.m_nativeSigningOptions.timestampURL, fileToSign.getAbsolutePath()).start();
            Utils.consumeOutput(signing);
            signing.waitFor();
            switch (signing.exitValue()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException("NAIS wasn't invoked properly");
                }
                case 7: {
                    throw new ADTException("Certificate in " + this.m_nativeSigningOptions.keyStoreFile + " could not be accessed", 7);
                }
                case 8: {
                    throw new ADTException("Certificate in " + this.m_nativeSigningOptions.keyStoreFile + " is invalid", 8);
                }
                case 9: {
                    throw new ADTException("Certificate in " + this.m_nativeSigningOptions.keyStoreFile + " could not be used to sign " + fileToSign.getName(), 9);
                }
                case 10: {
                    throw new ADTException("Could not apply timestamp to " + fileToSign.getName(), 10);
                }
                default: {
                    throw new ADTException("Signing " + fileToSign.getName() + " failed", 9);
                }
            }
        }
        catch (InterruptedException e2) {
            throw new GeneralSecurityException("Failed to sign " + fileToSign.getName());
        }
    }

    protected String getPlatformConverterName() {
        return ENTRYPOINT_NAME + ".exe";
    }

    private void addToZip(UCFOutputStream out, File source, String path) throws IOException {
        if (!source.exists() || !source.canRead()) {
            return;
        }
        if (source.isDirectory()) {
            File[] children;
            for (File child : children = source.listFiles()) {
                this.addToZip(out, child, path + "/" + child.getName());
            }
        } else {
            out.addFile(source, path, false);
        }
    }

    protected void parseDescriptorValues() {
        try {
            ApplicationDescriptor descriptor = new ApplicationDescriptor(new File(this.m_conversionOutput, "META-INF/AIR/application.xml"));
            this.m_appName = descriptor.filename();
        }
        catch (DescriptorValidationException e2) {
            throw new IllegalStateException("Conversion produced an invalid descriptor");
        }
    }
}

