/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.apk.AndroidManifestXMLParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class StringPoolHandler
extends DefaultHandler {
    static HashMap<String, String> mAttributeFormat = new HashMap();
    static HashMap<String, Integer> mAttributeRefValue = new HashMap();
    static HashMap<String, Integer> mAttributeConstantValue = new HashMap();
    static HashMap<String, Integer> mStringPoolMapNonRes = new HashMap();
    static HashMap<String, Integer> mStringPoolMapRes = new HashMap();
    static Set<String> mStringTagNames = new HashSet<String>();
    private static int mCountRes = -1;
    private static int mCountNonRes = -1;
    private static int hashIntCount = 0;
    private static int hashStringConstCount = 0;
    private static final String ANDROID_XML_ATTRIBUTE_NAME = "name";
    private static final String ANDROID_XML_ATTRIBUTE_VALUE = "value";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER = "integer";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_STRING = "string";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_FLOAT = "float";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_COLOR = "color";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN = "boolean";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE = "reference";
    public static final String ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT = "constant";
    private static final String ANDROID_XML_ATTRIBUTE_FORMAT = "format";
    private static final String ANDROID_XML_ATTRIBUTE_ENUM = "enum";
    private static final String ANDROID_XML_ATTRIBUTE_FLAG = "flag";
    private static final String ANDROID_XML_NODE_NAME_ATTR = "attr";
    private static final String ANDROID_XML_NODE_NAME_DECLARE_STYLEABLE = "declare-styleable";
    private static final String ANDROID_MANIFEST_PREFIX = "androidmanifest";

    private static void insertInHashMapRes(String val) {
        if (mStringPoolMapRes.get(val) == null) {
            mStringPoolMapRes.put(val, ++mCountRes);
        }
    }

    private static void insertInHashMapNonRes(String val) {
        if (mStringPoolMapNonRes.get(val) == null) {
            mStringPoolMapNonRes.put(val, ++mCountNonRes);
        }
    }

    public static void PopulateStringPool(String dataPath) throws IOException {
        if (dataPath != null) {
            StringPoolHandler.PopulateStringPoolFromFile(dataPath + "/res/values/attrs_manifest.xml");
            StringPoolHandler.PopulateStringPoolFromFile(dataPath + "/res/values/attrs.xml");
        } else {
            StringPoolHandler.PopulateStringPoolSelf();
        }
        mStringTagNames.add("manifest");
        mAttributeRefValue.put("android:style/Theme.NoTitleBar", 16973830);
        mAttributeRefValue.put("drawable/icon", 2130837504);
    }

    private static void PopulateStringPoolSelf() {
        boolean hashCount = false;
        mAttributeFormat.put("theme", ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE);
        mAttributeFormat.put("label", "reference|string");
        mAttributeFormat.put("icon", ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE);
        mAttributeFormat.put("manageSpaceActivity", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("allowClearUserData", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("testOnly", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put(ANDROID_XML_ATTRIBUTE_NAME, ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("permission", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("readPermission", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("writePermission", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("grantUriPermissions", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("protectionLevel", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("permissionGroup", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("sharedUserId", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("sharedUserLabel", ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE);
        mAttributeFormat.put("versionCode", ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER);
        mAttributeFormat.put("versionName", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("installLocation", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("persistent", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("debuggable", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("exported", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("process", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("taskAffinity", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("allowTaskReparenting", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("multiprocess", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("finishOnTaskLaunch", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("finishOnCloseSystemDialogs", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("clearTaskOnLaunch", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("noHistory", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("alwaysRetainTaskState", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("stateNotNeeded", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("excludeFromRecents", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("authorities", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("syncable", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("initOrder", ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER);
        mAttributeFormat.put("priority", ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER);
        mAttributeFormat.put("launchMode", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("screenOrientation", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("configChanges", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("description", ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE);
        mAttributeFormat.put("targetPackage", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("handleProfiling", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("functionalTest", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("reqTouchScreen", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("reqKeyboardType", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("reqHardKeyboard", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("reqNavigation", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeFormat.put("reqFiveWayNav", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("backupAgent", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("allowBackup", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("killAfterRestore", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("restoreNeedsApplication", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("hasCode", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("glEsVersion", ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER);
        mAttributeFormat.put("required", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("minSdkVersion", "integer|string");
        mAttributeFormat.put("targetSdkVersion", "integer|string");
        mAttributeFormat.put("maxSdkVersion", ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER);
        mAttributeFormat.put("smallScreens", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("normalScreens", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("largeScreens", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("resizeable", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("anyDensity", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("path", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("pathPrefix", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("pathPattern", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("targetActivity", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put(ANDROID_XML_ATTRIBUTE_VALUE, "string|integer|color|float|boolean");
        mAttributeFormat.put("resource", ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE);
        mAttributeFormat.put("mimeType", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("scheme", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("host", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("port", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("action", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("data", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("targetClass", ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
        mAttributeFormat.put("enabled", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("restoreAnyVersion", ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN);
        mAttributeFormat.put("windowSoftInputMode", ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
        mAttributeConstantValue.put("configChanges_mcc", 1);
        mAttributeConstantValue.put("configChanges_mnc", 2);
        mAttributeConstantValue.put("configChanges_locale", 4);
        mAttributeConstantValue.put("configChanges_touchscreen", 8);
        mAttributeConstantValue.put("configChanges_keyboard", 16);
        mAttributeConstantValue.put("configChanges_keyboardHidden", 32);
        mAttributeConstantValue.put("configChanges_navigation", 64);
        mAttributeConstantValue.put("configChanges_orientation", 128);
        mAttributeConstantValue.put("configChanges_screenLayout", 256);
        mAttributeConstantValue.put("configChanges_fontScale", 0x40000000);
        mAttributeConstantValue.put("launchMode_standard", 0);
        mAttributeConstantValue.put("launchMode_singleTop", 1);
        mAttributeConstantValue.put("launchMode_singleTask", 2);
        mAttributeConstantValue.put("launchMode_singleInstance", 3);
        mAttributeConstantValue.put("screenOrientation_landscape", 0);
        mAttributeConstantValue.put("screenOrientation_portrait", 1);
        mAttributeConstantValue.put("screenOrientation_user", 2);
        mAttributeConstantValue.put("screenOrientation_behind", 3);
        mAttributeConstantValue.put("screenOrientation_sensor", 4);
        mAttributeConstantValue.put("screenOrientation_nosensor", 5);
        mAttributeConstantValue.put("windowSoftInputMode_stateUnspecified", 0);
        mAttributeConstantValue.put("windowSoftInputMode_stateUnchanged", 1);
        mAttributeConstantValue.put("windowSoftInputMode_stateHidden", 2);
        mAttributeConstantValue.put("windowSoftInputMode_stateAlwaysHidden", 3);
        mAttributeConstantValue.put("windowSoftInputMode_stateVisible", 4);
        mAttributeConstantValue.put("windowSoftInputMode_stateAlwaysVisible", 5);
        mAttributeConstantValue.put("windowSoftInputMode_adjustUnspecified", 0);
        mAttributeConstantValue.put("windowSoftInputMode_adjustResize", 16);
        mAttributeConstantValue.put("windowSoftInputMode_adjustPan", 32);
        mAttributeConstantValue.put("reqTouchScreen_undefined", 0);
        mAttributeConstantValue.put("reqTouchScreen_notouch", 1);
        mAttributeConstantValue.put("reqTouchScreen_stylus", 2);
        mAttributeConstantValue.put("reqTouchScreen_finger", 3);
        mAttributeConstantValue.put("reqKeyboardType_undefined", 0);
        mAttributeConstantValue.put("reqKeyboardType_nokeys", 1);
        mAttributeConstantValue.put("reqKeyboardType_qwerty", 2);
        mAttributeConstantValue.put("reqKeyboardType_twelvekey", 3);
        mAttributeConstantValue.put("reqNavigation_undefined", 0);
        mAttributeConstantValue.put("reqNavigation_nonav", 1);
        mAttributeConstantValue.put("reqNavigation_dpad", 2);
        mAttributeConstantValue.put("reqNavigation_trackball", 3);
        mAttributeConstantValue.put("reqNavigation_wheel", 4);
        mAttributeConstantValue.put("protectionLevel_normal", 0);
        mAttributeConstantValue.put("protectionLevel_dangerous", 1);
        mAttributeConstantValue.put("protectionLevel_signature", 2);
        mAttributeConstantValue.put("protectionLevel_signatureOrSystem", 3);
        mAttributeConstantValue.put("installLocation_auto", 0);
        mAttributeConstantValue.put("installLocation_internalOnly", 1);
        mAttributeConstantValue.put("installLocation_preferExternal", 2);
        mStringTagNames.add("application");
        mStringTagNames.add("permission");
        mStringTagNames.add("permissiongroup");
        mStringTagNames.add("permissiontree");
        mStringTagNames.add("usespermission");
        mStringTagNames.add("usesconfiguration");
        mStringTagNames.add("usesfeature");
        mStringTagNames.add("usessdk");
        mStringTagNames.add("useslibrary");
        mStringTagNames.add("supportsscreens");
        mStringTagNames.add("protectedbroadcast");
        mStringTagNames.add("provider");
        mStringTagNames.add("granturipermission");
        mStringTagNames.add("pathpermission");
        mStringTagNames.add("service");
        mStringTagNames.add("receiver");
        mStringTagNames.add("activity");
        mStringTagNames.add("activityalias");
        mStringTagNames.add("metadata");
        mStringTagNames.add("intentfilter");
        mStringTagNames.add("action");
        mStringTagNames.add("data");
        mStringTagNames.add("category");
        mStringTagNames.add("instrumentation");
    }

    private static void PopulateStringPoolFromFile(String path) throws IOException {
        try {
            FileInputStream attrInfo = new FileInputStream(path);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document manifestDoc = docBuilder.parse(attrInfo);
            NodeList lst = manifestDoc.getElementsByTagName(ANDROID_XML_NODE_NAME_DECLARE_STYLEABLE);
            int length = lst.getLength();
            for (int i2 = 0; i2 < length; ++i2) {
                String acceptedTag;
                String tagName;
                Element attr = (Element)lst.item(i2);
                if (!attr.hasAttribute(ANDROID_XML_ATTRIBUTE_NAME) || !(tagName = attr.getAttribute(ANDROID_XML_ATTRIBUTE_NAME).toLowerCase()).startsWith(ANDROID_MANIFEST_PREFIX) || (acceptedTag = tagName.substring(ANDROID_MANIFEST_PREFIX.length())).length() <= 0) continue;
                mStringTagNames.add(acceptedTag);
            }
            NodeList attributeList = manifestDoc.getElementsByTagName(ANDROID_XML_NODE_NAME_ATTR);
            length = attributeList.getLength();
            for (int i3 = 0; i3 < length; ++i3) {
                Element attr = (Element)attributeList.item(i3);
                String name = attr.getAttribute(ANDROID_XML_ATTRIBUTE_NAME);
                if (attr.hasAttribute(ANDROID_XML_ATTRIBUTE_FORMAT)) {
                    String format = attr.getAttribute(ANDROID_XML_ATTRIBUTE_FORMAT);
                    mAttributeFormat.put(name, format);
                    continue;
                }
                NodeList childNodeList = attr.getChildNodes();
                int childCount = childNodeList.getLength();
                boolean childNodesExist = false;
                for (int j2 = 0; j2 < childCount; ++j2) {
                    Element el;
                    Node child = childNodeList.item(j2);
                    if (!child.getNodeName().equals(ANDROID_XML_ATTRIBUTE_ENUM) && !child.getNodeName().equals(ANDROID_XML_ATTRIBUTE_FLAG) || !(el = (Element)child).hasAttribute(ANDROID_XML_ATTRIBUTE_NAME) || !el.hasAttribute(ANDROID_XML_ATTRIBUTE_VALUE)) continue;
                    String enumValName = el.getAttribute(ANDROID_XML_ATTRIBUTE_NAME);
                    String enumValId = el.getAttribute(ANDROID_XML_ATTRIBUTE_VALUE);
                    int index = enumValId.toLowerCase().indexOf(120);
                    if (index != -1) {
                        enumValId = enumValId.substring(index + 1);
                    }
                    childNodesExist = true;
                    mAttributeConstantValue.put(name + "_" + enumValName, new Integer(Integer.parseInt(enumValId, 16)));
                }
                if (!childNodesExist) continue;
                mAttributeFormat.put(name, ANDROID_XML_ATTRIBUTE_FORMAT_CONSTANT);
            }
            ((InputStream)attrInfo).close();
        }
        catch (Exception ex) {
            System.err.println("\"ANDROID_SDK_PATH\" might not be set properly\n");
            throw new IOException("Error in reading the file " + path);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        StringPoolHandler.insertInHashMapNonRes(prefix);
        StringPoolHandler.insertInHashMapNonRes(uri);
        StringPoolHandler.insertInHashMapNonRes("");
    }

    public void startElement(String uri, String localName, String rawName, Attributes attrs) throws SAXException {
        if (rawName.equals("manifest")) {
            StringPoolHandler.insertInHashMapNonRes("package");
            StringPoolHandler.insertInHashMapNonRes("manifest");
        } else {
            StringPoolHandler.insertInHashMapNonRes(rawName);
        }
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            if (attrs.getLocalName(i2).equals("package")) {
                StringPoolHandler.insertInHashMapNonRes(AndroidManifestXMLParser.mPackageName);
                continue;
            }
            String name = attrs.getLocalName(i2);
            String value = attrs.getValue(i2);
            StringPoolHandler.insertInHashMapRes(name);
            String format = mAttributeFormat.get(name);
            if (format == null) {
                throw new SAXException(name + " is an invalid attribute name");
            }
            if (format.contains("|")) {
                if (StringPoolHandler.isFloat(format, value)) {
                    format = ANDROID_XML_ATTRIBUTE_FORMAT_FLOAT;
                } else if (StringPoolHandler.isInteger(format, value)) {
                    format = ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER;
                } else if (StringPoolHandler.isBoolean(format, value)) {
                    format = ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN;
                } else if (StringPoolHandler.isReference(format, value)) {
                    format = ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE;
                } else if (StringPoolHandler.isColor(format, value)) {
                    format = ANDROID_XML_ATTRIBUTE_FORMAT_COLOR;
                } else if (StringPoolHandler.isString(format, value)) {
                    format = ANDROID_XML_ATTRIBUTE_FORMAT_STRING;
                } else {
                    throw new SAXException("Value " + value + " does not match with any of the supported formats");
                }
            }
            if (!format.equals(ANDROID_XML_ATTRIBUTE_FORMAT_STRING)) continue;
            if (value.equals("AppEntry") && name.equals("label")) {
                StringPoolHandler.insertInHashMapNonRes(AndroidManifestXMLParser.mAppName);
                continue;
            }
            if (name.equals("versionName")) {
                StringPoolHandler.insertInHashMapNonRes(AndroidManifestXMLParser.mAppVersionName);
                continue;
            }
            StringPoolHandler.insertInHashMapNonRes(value);
        }
    }

    public static boolean isString(String format, String value) {
        return format.contains(ANDROID_XML_ATTRIBUTE_FORMAT_STRING);
    }

    public static boolean isBoolean(String format, String value) {
        if (!format.contains(ANDROID_XML_ATTRIBUTE_FORMAT_BOOLEAN)) {
            return false;
        }
        return value.equals("true") || value.equals("false");
    }

    public static boolean isReference(String format, String value) {
        if (!format.contains(ANDROID_XML_ATTRIBUTE_FORMAT_REFERENCE)) {
            return false;
        }
        return value.length() > 0 && value.charAt(0) == '@';
    }

    public static boolean isFloat(String format, String value) {
        if (!format.contains(ANDROID_XML_ATTRIBUTE_FORMAT_FLOAT)) {
            return false;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException e2) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String format, String value) {
        if (!format.contains(ANDROID_XML_ATTRIBUTE_FORMAT_INTEGER)) {
            return false;
        }
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e2) {
            return false;
        }
        return true;
    }

    public static boolean isColor(String format, String value) {
        if (!format.contains(ANDROID_XML_ATTRIBUTE_FORMAT_COLOR)) {
            return false;
        }
        int length = value.length();
        if (length < 0) {
            return false;
        }
        return value.charAt(0) == '#' && (length == 4 || length == 5 || length == 7 || length == 9) && value.substring(1).matches("[0-9A-Fa-f]");
    }
}

