/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.ANEFile;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKOutputStream;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.zip.ZipFile;

public final class APKPackager
extends ApplicationPackager {
    public APKPackager() {
        super("AIR", "Android-ARM", false, false);
        this.setStream(new APKOutputStream());
    }

    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
    }

    public void setApplicationDescriptor(File descriptorFile) {
        try {
            super.setApplicationDescriptor(descriptorFile);
            this.getAPKStream().addApplicationDescriptorFile(descriptorFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void validateApplicationDescriptor() throws DescriptorValidationException {
        this.m_applicationDescriptor = new ApplicationDescriptor(this.m_applicationDescriptorFile);
        this.getApplicationDescriptor().validateForAPKPackaging(this.getSources());
        this.getAPKStream().setSources(this.getSources());
    }

    protected void addExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        super.addExtensions();
        File tempDir = Utils.createTempDirectory("apk-jars", "", null);
        this.addFileForCleanup(tempDir);
        byte[] buf = new byte[1024];
        for (ANEFile ane : this.getExtensions()) {
            try {
                String nativeLibraryPath = ane.getNativeLibraryPath("Android-ARM");
                if (nativeLibraryPath == null) continue;
                ZipFile zipFile = new ZipFile(ane.getFile());
                InputStream in = zipFile.getInputStream(zipFile.getEntry(nativeLibraryPath));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(tempDir, ane.id() + ".jar")));
                int n2 = 0;
                while ((n2 = in.read(buf, 0, 1024)) > -1) {
                    ((OutputStream)out).write(buf, 0, n2);
                }
                in.close();
                ((OutputStream)out).close();
                zipFile.close();
            }
            catch (IOException e2) {
                throw new InvalidInputException(ane.getFile().getAbsoluteFile() + " is not a valid native extension file.");
            }
        }
        this.getAPKStream().setExtensionsJars(tempDir.listFiles());
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("apk");
    }

    public void setPackageConfiguration(String configType) {
        this.getAPKStream().setConfigType(configType);
    }

    public void setDebugHost(String host) {
        this.getAPKStream().setDebugHost(host);
    }

    protected APKOutputStream getStream() {
        return (APKOutputStream)super.getStream();
    }

    private APKOutputStream getAPKStream() {
        return this.getStream();
    }

    public void setDeviceSDKDirectory(File sdkDir) throws InvalidInputException {
        this.getAPKStream().setAndroidDeviceSDK(new AndroidDeviceSDK(sdkDir));
    }

    public void setTimestampURL(String url) {
        throw new UnsupportedOperationException("timestamp not supported for APK");
    }
}

