/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.ADTException;
import com.adobe.air.ADTOutputStream;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ExtensionDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKSigner;
import com.adobe.air.apk.AndroidManifestXMLParser;
import com.adobe.air.apk.OrderManifestHandler;
import com.adobe.air.apk.ReplaceStringFile;
import com.adobe.air.apk.StringPoolHandler;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCFOutputStream;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jf.smali.main;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APKOutputStream
extends ADTOutputStream {
    protected static final String ASSETS_FOLDER = "assets/";
    protected static final String METAINF_FOLDER = "META-INF/AIR/";
    protected static final String RES_RAW_FOLDER = "res/raw/";
    protected static final String DEBUGGER_INFO = "debugger.info";
    protected static final String RES_DRAWABLE_FOLDER = "res/drawable/";
    protected static final String RES_DRAWABLE_H_FOLDER = "res/drawable-hdpi/";
    protected static final String RES_DRAWABLE_L_FOLDER = "res/drawable-ldpi/";
    protected static final String RES_DRAWABLE_M_FOLDER = "res/drawable-mdpi/";
    protected static final String ICON_NAME = "icon.png";
    protected static final String ANDROID_MANIFEST_PATH = "AndroidManifest_template.xml";
    protected static final String ANDROID_MANIFEST_BIN = "AndroidManifest.xml";
    protected static final String RESOURCES_ARSC = "resources.arsc";
    protected static final String CLASSES_DEX_RELEASE_PATH = "Dex/classes_release.dex";
    protected static final String CLASSES_DEX_DEBUG_PATH = "Dex/classes_debug.dex";
    protected static final String CLASSES_DEX_OUT = "classes.dex";
    protected static final String PACKAGE_NAME_PRE = "air.";
    protected static final String APPLICATION_XML_FILE = "application.xml";
    protected static final String SMALI_OUT_DIR = "/out/air/com/adobe/appentry/";
    protected static final String PACKAGE_TO_REPLACE = "air/com/adobe/appentry";
    protected static final String VERSION_CODE_TO_REPLACE = "__VERSION_CODE_TO_REPLACE__";
    protected static final String ARMEABI_V7A_MARKER = "lib/armeabi-v7a/libNativeABI.so";
    private final int MAX_ASSET_FILE_NAME = 100;
    protected static final int ANDROID_LOW_DENSITY_ICON_SIZE = 36;
    protected static final int ANDROID_MEDIUM_DENSITY_ICON_SIZE = 48;
    protected static final int ANDROID_HIGH_DENSITY_ICON_SIZE = 72;
    protected File OsTempDir = new File(System.getProperty("java.io.tmpdir"));
    private Map<String, File> _sources;
    private static String m_configType = "apk";
    private static String m_debugHost;
    private AndroidDeviceSDK m_androidSDK;
    private File[] m_extensionsJars;
    private File m_tmpJarsDir;
    private DescriptorValidationException mFailureException = null;
    private String mDescriptorFileName = null;
    private Listener mLocalListener = null;
    private int index = 0;

    @Override
    public void close() throws IOException {
        if (this.m_tmpJarsDir != null) {
            this.m_tmpJarsDir.delete();
        }
        super.close();
    }

    public void setAndroidDeviceSDK(AndroidDeviceSDK sdk) throws InvalidInputException {
        if (sdk == null) {
            throw new InvalidInputException("sdk must be non-null");
        }
        this.m_androidSDK = sdk;
    }

    public AndroidDeviceSDK getAndroidSDKDirectory() throws InvalidInputException {
        if (this.m_androidSDK == null) {
            this.m_androidSDK = new AndroidDeviceSDK(null);
        }
        return this.m_androidSDK;
    }

    protected void setConfigType(String config) {
        m_configType = config;
    }

    protected void setDebugHost(String host) {
        m_debugHost = host;
    }

    @Override
    protected CodeSigner getCodeSigner() {
        return new APKSigner();
    }

    public static String getPackageName(String appID) {
        String packageName = appID;
        packageName = PACKAGE_NAME_PRE + packageName;
        packageName = packageName.replace('-', '_');
        packageName = packageName.replaceAll("\\.([0-9])", "\\.A$1");
        return packageName;
    }

    @Override
    public void addApplicationDescriptor(ApplicationDescriptor descriptor, boolean sign) throws IOException {
        super.addApplicationDescriptor(descriptor, sign);
        if (this._sources != null) {
            this.addIconFolder();
        }
        if (this._sources == null) {
            this.getApplicationDescriptor().validateForAPKPackaging();
        }
        this.mDescriptorFileName = descriptor.getDescriptorFileName();
        if (this.mLocalListener == null) {
            this.mLocalListener = new Listener(){

                public void message(Message message) {
                    if (APKOutputStream.this.mFailureException == null) {
                        APKOutputStream.this.mFailureException = new DescriptorValidationException(message);
                    } else {
                        APKOutputStream.this.mFailureException.appendErrorMessage(message);
                    }
                }

                public void progress(int soFar, int total) {
                }
            };
        }
        this.addResourcesArsc();
        String packageName = APKOutputStream.getPackageName(descriptor.id());
        String[] version = descriptor.versionNumber().split("\\.");
        int versionNumber = 0;
        int multiplier = 1000000;
        for (int i2 = 0; i2 < version.length; ++i2) {
            versionNumber += Integer.parseInt(version[i2]) * multiplier;
            multiplier /= 1000;
        }
        this.addAndroidManifest(packageName, descriptor, versionNumber, descriptor.versionLabel());
        this.addClassesDex(packageName);
        this.addARMEABIv7AMarker();
        if (m_debugHost != null) {
            this.addDebuggerInfo(m_debugHost);
        }
    }

    public void setSources(Map<String, File> sources) {
        this._sources = sources;
    }

    @Override
    protected void addAIRFile(ZipFile inputFile, String expectedMimetype, String targetPlatform, Set<String> exclusionList) throws InvalidInputException {
        HashMap<String, String> nativeLibs = new HashMap<String, String>();
        try {
            Pattern extensionDescriptorPattern = Pattern.compile("META-INF/AIR/extensions/([^/]+)/META-INF/ANE/extension.xml");
            Enumeration<? extends ZipEntry> entries = inputFile.entries();
            while (entries.hasMoreElements()) {
                ExtensionDescriptor ed;
                String nativeLibrary;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                Matcher em = extensionDescriptorPattern.matcher(name);
                if (!em.matches() || (nativeLibrary = (ed = new ExtensionDescriptor(inputFile.getInputStream(entry), true, entry.getName())).getNativeLibrary("Android-ARM")) == null) continue;
                String extensionId = em.group(1);
                nativeLibs.put(extensionId, "META-INF/AIR/extensions/" + extensionId + "/" + "META-INF/ANE" + "/" + "Android-ARM" + "/" + nativeLibrary);
            }
            this.m_tmpJarsDir = Utils.createTempDirectory("apk-jars", null, null);
            for (String extId : nativeLibs.keySet()) {
                String nativeLibPath = (String)nativeLibs.get(extId);
                InputStream inStream = inputFile.getInputStream(inputFile.getEntry(nativeLibPath));
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(this.m_tmpJarsDir + File.separator + extId + ".jar"));
                byte[] buf = new byte[1024];
                int n2 = 0;
                while ((n2 = inStream.read(buf, 0, 1024)) > -1) {
                    ((OutputStream)outStream).write(buf, 0, n2);
                }
                inStream.close();
                ((OutputStream)outStream).close();
            }
            this.m_extensionsJars = this.m_tmpJarsDir.listFiles();
        }
        catch (DescriptorValidationException e2) {
            throw new InvalidInputException("File " + inputFile.getName() + " has an invalid extension descriptor: " + e2.getMessage());
        }
        catch (IOException e3) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed. " + e3.getMessage());
        }
        super.addAIRFile(inputFile, expectedMimetype, targetPlatform, new HashSet<String>(nativeLibs.values()));
        if (this.m_applicationDescriptor != null && this.m_applicationDescriptor.appIcons().isEmpty()) {
            try {
                this.addIconFolder();
            }
            catch (IOException e4) {
                throw new InvalidInputException("Unable to add default icon");
            }
        }
    }

    public void addApplicationDescriptorFile(File desFile) throws IOException {
        FileInputStream in = new FileInputStream(desFile);
        this.addFileFromStream(APPLICATION_XML_FILE, in, DEFAULT_FILE_PERMISSONS, true, "assets/META-INF/AIR/");
    }

    private int getClosestIconSize(int size) {
        int closestSize = size;
        if (this.getApplicationDescriptor().getIcon(size) == null) {
            int i2;
            int[] iconSizes = new int[]{16, 29, 32, 36, 48, 57, 72, 128, 512};
            int iconSizesLen = iconSizes.length;
            closestSize = 0;
            for (i2 = 0; i2 < iconSizesLen; ++i2) {
                if (iconSizes[i2] <= size || closestSize != 0 && iconSizes[i2] - size >= closestSize - size || this.getApplicationDescriptor().getIcon(iconSizes[i2]) == null) continue;
                closestSize = iconSizes[i2];
            }
            if (closestSize == 0) {
                for (i2 = 0; i2 < iconSizesLen && iconSizes[i2] < size; ++i2) {
                    if (closestSize != 0 && iconSizes[i2] - size <= closestSize - size || this.getApplicationDescriptor().getIcon(iconSizes[i2]) == null) continue;
                    closestSize = iconSizes[i2];
                }
            }
        }
        return closestSize;
    }

    private void addAndroidIcon(int size) throws IOException {
        String folder = null;
        switch (size) {
            case 36: {
                folder = RES_DRAWABLE_L_FOLDER;
                break;
            }
            case 48: {
                folder = RES_DRAWABLE_M_FOLDER;
                break;
            }
            case 72: {
                folder = RES_DRAWABLE_H_FOLDER;
            }
        }
        String iconPath = this.getApplicationDescriptor().getIcon(this.getClosestIconSize(size));
        if (iconPath != null) {
            File file = this._sources.get(iconPath);
            this.addFileFromStream(ICON_NAME, new FileInputStream(file), DEFAULT_FILE_PERMISSONS, true, folder);
        } else {
            this.addFileFromResource(ICON_NAME, true, folder);
        }
    }

    private void addIconFolder() throws IOException {
        this.addAndroidIcon(36);
        this.addAndroidIcon(48);
        this.addAndroidIcon(72);
    }

    public void addResourcesArsc() throws IOException {
        this.addFileFromResource(RESOURCES_ARSC, true, "");
    }

    private void failIfError() throws DescriptorValidationException {
        if (this.mFailureException != null) {
            throw this.mFailureException;
        }
    }

    public void addAndroidManifest(String packageName, ApplicationDescriptor descriptor, int appVersionCode, String appVersionName) throws IOException {
        File tempAMF = this.createTempFileInTempFolder();
        if (tempAMF != null) {
            this.editAndroidManifest(descriptor, tempAMF);
            this.failIfError();
            Map<String, String> localizedNames = descriptor.localizedNames();
            String appName = localizedNames.size() > 0 && localizedNames.containsKey("en") ? localizedNames.get("en") : descriptor.name();
            AndroidManifestXMLParser xp = new AndroidManifestXMLParser();
            String binAndroidManifest = xp.createBinary(tempAMF.getCanonicalPath(), packageName, appName, appVersionCode, appVersionName, this.mLocalListener, this.mDescriptorFileName);
            this.failIfError();
            if (binAndroidManifest != null) {
                File source = new File(binAndroidManifest);
                File target = new File(source.getParentFile() + "/" + ANDROID_MANIFEST_BIN);
                source.renameTo(target);
                FileInputStream in = new FileInputStream(target);
                this.addFileFromStream(ANDROID_MANIFEST_BIN, in, DEFAULT_FILE_PERMISSONS, true, "");
                ((InputStream)in).close();
                source.delete();
                target.delete();
                APKOutputStream.recursiveFileOrFolderDelete(tempAMF.getParentFile());
            } else {
                throw new IOException("Unable to convert AndroidManifest to binary ");
            }
        }
    }

    private void replaceVersionCode(File smaliFile, String versionCode) throws IOException {
        char[] buffer = new char[(int)smaliFile.length()];
        FileReader inFile = new FileReader(smaliFile);
        inFile.read(buffer);
        inFile.close();
        String s2 = new String(buffer);
        s2 = s2.replace(VERSION_CODE_TO_REPLACE, versionCode);
        FileWriter outFile = new FileWriter(smaliFile);
        outFile.write(s2);
        outFile.close();
    }

    private File renameAppEntryPackage(String outputDexPath, String tmpFolderPath, String packageName) throws IOException {
        String[] argsDecompile = new String[]{outputDexPath, "-o", tmpFolderPath + "/out"};
        org.jf.baksmali.main.main(argsDecompile);
        File inputDir = new File(tmpFolderPath + SMALI_OUT_DIR);
        File[] listOfFiles = inputDir.listFiles();
        for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
            File input = listOfFiles[i2];
            if (!input.isFile()) continue;
            File output = new File(input.getCanonicalPath() + ".temp");
            input.renameTo(output);
            ReplaceStringFile.replace(output.getCanonicalPath(), input.getCanonicalPath(), PACKAGE_TO_REPLACE, packageName);
            if (!input.getName().equals("GetVersionCode.smali")) continue;
            this.replaceVersionCode(input, this.m_applicationDescriptor.versionNumber());
        }
        File input = new File(tmpFolderPath + "/out");
        File target = new File(tmpFolderPath + "/out/classes.dex");
        String[] args = new String[]{input.getCanonicalPath(), "-o", target.getCanonicalPath()};
        main.main(args);
        return target;
    }

    private String getAndroidSDKToolPath() throws IOException, ADTException {
        if (null == this.getAndroidSDKDirectory()) {
            throw new ADTException("Could not locate Android SDK tools directory", 13);
        }
        File androidSDKToolPath = new File(this.m_androidSDK.getSDKLocation(), "tools");
        if (!androidSDKToolPath.exists()) {
            throw new ADTException("Could not locate Android SDK tools directory", 13);
        }
        return androidSDKToolPath.getCanonicalPath();
    }

    private String getAndroidSDKPlatformToolPath() throws IOException, ADTException {
        if (null == this.getAndroidSDKDirectory()) {
            throw new ADTException("Could not locate Android SDK platforms tools directory", 13);
        }
        File androidSDKPlatformToolPath = new File(this.m_androidSDK.getPlatformDirectoryForLatestAPI(), "tools");
        if (!androidSDKPlatformToolPath.exists()) {
            throw new ADTException("Could not locate Android SDK platforms tools directory", 13);
        }
        return androidSDKPlatformToolPath.getCanonicalPath();
    }

    private String getAndroidSDKPlatformDataPath() throws IOException {
        File androidSDKPlatformDataPath;
        if (null != this.getAndroidSDKDirectory() && (androidSDKPlatformDataPath = new File(this.m_androidSDK.getPlatformDirectoryForLatestAPI(), "data")).exists()) {
            return androidSDKPlatformDataPath.getCanonicalPath();
        }
        throw new IOException("Could not locate Android SDK platforms data directory");
    }

    private void generateClassesDex(String packageName) throws IOException {
        int len;
        String outClsDx;
        InputStream inClsJarStream;
        if (m_configType.equals("apk") || m_configType.equals("apk-emulator")) {
            inClsJarStream = this.getClass().getResourceAsStream("Dex/AppEntry_release.jar");
            outClsDx = "AppEntry_classes_release.dex";
        } else if (m_configType.equals("apk-debug")) {
            inClsJarStream = this.getClass().getResourceAsStream("Dex/AppEntry_debug.jar");
            outClsDx = "AppEntry_classes_debug.dex";
        } else {
            throw new IOException("Unknown APK Config Type");
        }
        String randomDirName = UUID.randomUUID().toString();
        String tmpFolderPath = this.OsTempDir.getCanonicalPath() + "/" + randomDirName;
        File dirToDel = new File(tmpFolderPath);
        dirToDel.mkdir();
        dirToDel.deleteOnExit();
        String inputJarPath = tmpFolderPath + "/inputJAR.jar";
        String outputDexPath = tmpFolderPath + "/outputDEX.dex";
        String flashRuntimeExtensionsJarPath = tmpFolderPath + "/FlashRuntimeExtensions.jar";
        File inputJar = new File(inputJarPath);
        FileOutputStream outTmpClsJarStream = new FileOutputStream(inputJar);
        byte[] buf = new byte[1024];
        while ((len = inClsJarStream.read(buf)) > 0) {
            ((OutputStream)outTmpClsJarStream).write(buf, 0, len);
        }
        ((OutputStream)outTmpClsJarStream).close();
        inClsJarStream.close();
        InputStream inFlashRuntimeJarStream = this.getClass().getResourceAsStream("Dex/FlashRuntimeExtensions.jar");
        File flashRuntimeExtensionsJar = new File(flashRuntimeExtensionsJarPath);
        FileOutputStream outTmpFlashRuntimeJarStream = new FileOutputStream(flashRuntimeExtensionsJar);
        while ((len = inFlashRuntimeJarStream.read(buf)) > 0) {
            ((OutputStream)outTmpFlashRuntimeJarStream).write(buf, 0, len);
        }
        ((OutputStream)outTmpFlashRuntimeJarStream).close();
        inFlashRuntimeJarStream.close();
        int sizeOfArgsArray = 5;
        int numberOfExtensions = 0;
        if (this.m_extensionsJars != null) {
            numberOfExtensions = this.m_extensionsJars.length;
        }
        String[] dexArgs = new String[sizeOfArgsArray + numberOfExtensions];
        dexArgs[0] = this.getAndroidSDKPlatformToolPath() + "/dx";
        dexArgs[1] = "--dex";
        dexArgs[2] = "--output=" + outputDexPath;
        dexArgs[3] = inputJarPath;
        dexArgs[4] = flashRuntimeExtensionsJarPath;
        if (this.m_extensionsJars != null) {
            for (int j2 = 0; j2 < numberOfExtensions; ++j2) {
                dexArgs[j2 + sizeOfArgsArray] = this.m_extensionsJars[j2].getCanonicalPath();
            }
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(dexArgs);
            Map<String, String> env = pb.environment();
            env.put("PATH", env.get("PATH") + ":" + this.getAndroidSDKToolPath());
            Process p2 = pb.start();
            p2.waitFor();
        }
        catch (Exception e2) {
            throw new IOException("Unable to run dx");
        }
        File target = this.renameAppEntryPackage(outputDexPath, tmpFolderPath, packageName);
        FileInputStream inClsDexStream = new FileInputStream(target);
        this.addFileFromStream(outClsDx, inClsDexStream, DEFAULT_FILE_PERMISSONS, true, "");
        ((InputStream)inClsDexStream).close();
        APKOutputStream.recursiveFileOrFolderDelete(dirToDel);
    }

    public void addClassesDex(String packageName) throws IOException {
        File inputDirToDel;
        String outFolderPath;
        InputStream inClsDex = m_configType.equals("apk") || m_configType.equals("apk-emulator") ? this.getClass().getResourceAsStream(CLASSES_DEX_RELEASE_PATH) : this.getClass().getResourceAsStream(CLASSES_DEX_DEBUG_PATH);
        File tempDexFile = this.createTempFileInTempFolder();
        if (tempDexFile != null) {
            int len;
            FileOutputStream out = new FileOutputStream(tempDexFile);
            byte[] buf = new byte[1024];
            while ((len = inClsDex.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            inClsDex.close();
            String randomDirName = UUID.randomUUID().toString();
            outFolderPath = this.OsTempDir.getCanonicalPath() + "/" + randomDirName;
            String[] argsDecompile = new String[]{tempDexFile.getCanonicalPath(), "-o", outFolderPath + "/out"};
            org.jf.baksmali.main.main(argsDecompile);
            inputDirToDel = new File(outFolderPath);
            inputDirToDel.deleteOnExit();
            File inputDir = new File(outFolderPath + SMALI_OUT_DIR);
            File[] listOfFiles = inputDir.listFiles();
            for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
                File input = listOfFiles[i2];
                if (!input.isFile()) continue;
                File output = new File(input.getCanonicalPath() + ".temp");
                input.renameTo(output);
                ReplaceStringFile.replace(output.getCanonicalPath(), input.getCanonicalPath(), PACKAGE_TO_REPLACE, packageName);
                if (!input.getName().equals("GetVersionCode.smali")) continue;
                this.replaceVersionCode(input, this.m_applicationDescriptor.versionNumber());
            }
        } else {
            throw new IOException("Unable to add classes.dex to package");
        }
        File input = new File(outFolderPath + "/out");
        File target = new File(outFolderPath + "/out/classes.dex");
        String[] args = new String[]{input.getCanonicalPath(), "-o", target.getCanonicalPath()};
        main.main(args);
        FileInputStream in = new FileInputStream(target);
        this.addFileFromStream(CLASSES_DEX_OUT, in, DEFAULT_FILE_PERMISSONS, true, "");
        ((InputStream)in).close();
        APKOutputStream.recursiveFileOrFolderDelete(tempDexFile.getParentFile());
        APKOutputStream.recursiveFileOrFolderDelete(inputDirToDel);
        target.delete();
        input.delete();
    }

    public void addDebuggerInfo(String host) throws IOException {
        ByteArrayInputStream pInfo;
        try {
            pInfo = new ByteArrayInputStream(host.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new IOException("\n Unable to add localhost information");
        }
        this.addFileFromStream(DEBUGGER_INFO, pInfo, DEFAULT_FILE_PERMISSONS, true, RES_RAW_FOLDER);
    }

    public void addARMEABIv7AMarker() throws IOException {
        if (m_configType.equals("apk")) {
            this.addFileFromResource(ARMEABI_V7A_MARKER, true, "");
        }
    }

    private void addFileFromResource(String filename, boolean addToSignature, String folderInPackage) throws IOException {
        this.addFileFromStream(filename, this.getClass().getResourceAsStream(filename), DEFAULT_FILE_PERMISSONS, addToSignature, folderInPackage);
    }

    protected void addFileFromStream(String filename, InputStream in, long permissions, boolean addToSignature, String folderInPackage) throws IOException {
        this.addFileFromStream(filename, in, in.available(), permissions, new Date().getTime(), addToSignature, folderInPackage);
    }

    protected void addFileFromStream(String filename, InputStream in, long size, long permissions, long time, boolean addToSignature, String folderInPackage) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(time));
        record.path = folderInPackage + filename;
        if (folderInPackage.equals(ASSETS_FOLDER)) {
            this.validateAssetsFileName(filename);
        }
        record.size = in.available();
        record.permissions = permissions != 0L ? permissions : DEFAULT_FILE_PERMISSONS;
        super.addFile(record, in, addToSignature, true);
    }

    @Override
    public void addFile(File file, String path, boolean addToSignature, long permissions) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(file.lastModified()));
        record.path = ASSETS_FOLDER + path;
        this.validateAssetsFileName(path);
        record.size = file.length();
        record.permissions = permissions;
        super.addFile(record, new FileInputStream(file), addToSignature, true);
    }

    private void validateAssetsFileName(String path) throws InvalidInputException {
        String[] a = path.split("/");
        int len = 0;
        for (int i2 = 0; i2 < a.length; ++i2) {
            len = a[i2].length();
            if (len > 100) {
                throw new InvalidInputException(" Asset file or directory name cannot be more than 100 bytes long. Error occured for : " + a[i2]);
            }
            for (int j2 = 0; j2 < len; ++j2) {
                char ch = a[i2].charAt(j2);
                if ((ch & 0x80) == 0 && ch >= ' ' && ch < '\u007f') continue;
                throw new InvalidInputException(" Asset file or directory name contains invalid characters. Error occured for : " + a[i2]);
            }
        }
    }

    @Override
    protected void addFile(UCFOutputStream.FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException {
    }

    @Override
    public void addFileFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.checkPath(entry.getName());
        this.addFileFromStream(entry.getName(), data, entry.getSize(), permissions, entry.getTime(), true, ASSETS_FOLDER);
    }

    @Override
    public void addFileFromZipEntry(ZipEntry entry, ZipFile file, String path) throws IOException {
        this.checkPath(entry.getName());
        this.addFileFromStream(path, file.getInputStream(entry), entry.getSize(), DEFAULT_FILE_PERMISSONS, entry.getTime(), true, ASSETS_FOLDER);
    }

    @Override
    public void addDescriptorFromZipEntry(ZipEntry entry, InputStream data) throws IOException {
        this.addApplicationDescriptor(new ApplicationDescriptor(data), true);
        data.reset();
        this.addFileFromStream(entry.getName(), data, DEFAULT_FILE_PERMISSONS, true, ASSETS_FOLDER);
    }

    @Override
    public void addIconFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        String entryName = entry.getName();
        if (!this.getApplicationDescriptor().appIcons().contains(entryName)) {
            return;
        }
        this.getApplicationDescriptor().validateIcon(data, entryName, false);
        Dimension iconDim = this.getApplicationDescriptor().getIconDimension(entryName);
        if (iconDim.width == this.getClosestIconSize(36)) {
            data.reset();
            this.addFileFromStream(ICON_NAME, data, DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_L_FOLDER);
        }
        if (iconDim.width == this.getClosestIconSize(48)) {
            data.reset();
            this.addFileFromStream(ICON_NAME, data, DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_M_FOLDER);
        }
        if (iconDim.width == this.getClosestIconSize(72)) {
            data.reset();
            this.addFileFromStream(ICON_NAME, data, DEFAULT_FILE_PERMISSONS, true, RES_DRAWABLE_H_FOLDER);
        }
    }

    @Override
    public void addInitialContentFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateInitialContent(data, false);
        data.reset();
        this.addFileFromStream(entry.getName(), data, DEFAULT_FILE_PERMISSONS, true, ASSETS_FOLDER);
    }

    @Override
    public void addHashFile(String path) throws IOException {
    }

    @Override
    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
    }

    private short paddingSize(UCFOutputStream.FileRecord r2) {
        if (r2.size != r2.compressedSize) {
            return 0;
        }
        long lfhSize = 30 + r2.path.length();
        long dataOffset = r2.lfhOffset + lfhSize;
        return (short)((4 - (int)(dataOffset % 4L)) % 4);
    }

    @Override
    protected short getLFExtraFieldLength(UCFOutputStream.FileRecord r2) {
        return this.paddingSize(r2);
    }

    @Override
    protected void writeLFExtraField(UCFOutputStream.FileRecord r2) throws IOException {
        short padding = this.paddingSize(r2);
        for (short i2 = 0; i2 < padding; i2 = (short)(i2 + 1)) {
            this.os.writeByte(0);
        }
    }

    @Override
    public void finalizeSig() throws IOException, GeneralSecurityException {
        if (this.codeSigner != null) {
            byte[] manifest = ((APKSigner)this.codeSigner).getManifestFile();
            UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date());
            record.path = ((APKSigner)this.codeSigner).getManifestFilePath();
            record.size = manifest.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            super.addFile(record, new ByteArrayInputStream(manifest), false, true);
            byte[] certsf = ((APKSigner)this.codeSigner).getSignedManifestFile();
            record = new UCFOutputStream.FileRecord(new Date());
            record.path = ((APKSigner)this.codeSigner).getSignedManifestFilePath();
            record.size = certsf.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            super.addFile(record, new ByteArrayInputStream(certsf), false, true);
            byte[] certalgo = ((APKSigner)this.codeSigner).getSignatureBlockFile();
            record = new UCFOutputStream.FileRecord(new Date());
            record.path = ((APKSigner)this.codeSigner).getSignatureBlockFilePath();
            record.size = certalgo.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            super.addFile(record, new ByteArrayInputStream(certalgo), false, true);
        }
    }

    public File createTempFileInTempFolder() throws IOException {
        File tempFile2;
        String dirName = UUID.randomUUID().toString();
        File tempFolder = new File(this.OsTempDir, dirName);
        tempFolder.mkdir();
        try {
            tempFile2 = File.createTempFile("apk", "tmp", tempFolder);
        }
        catch (IOException e2) {
            Object tempFile2 = null;
            throw new IOException(" Unable to create Temporary file in Temporary Folder");
        }
        return tempFile2;
    }

    public static void recursiveFileOrFolderDelete(File fileOrDir) {
        for (File innerFile : fileOrDir.listFiles()) {
            if (innerFile.isDirectory()) {
                APKOutputStream.recursiveFileOrFolderDelete(innerFile);
            }
            innerFile.delete();
        }
        fileOrDir.delete();
    }

    private boolean isManifestFirstNode(Document manifestInfoDoc) {
        NodeList manifestList = manifestInfoDoc.getElementsByTagName("manifest");
        Boolean isManifestFirstNode = false;
        if (manifestList.getLength() > 0 && manifestList.item(0).getParentNode().getNodeName().equals("dict")) {
            isManifestFirstNode = true;
        }
        if (isManifestFirstNode.booleanValue()) {
            Node prevNode = manifestList.item(0).getPreviousSibling();
            if (prevNode == null) {
                isManifestFirstNode = true;
            } else {
                while (prevNode != null) {
                    if (!prevNode.getNodeName().equals("#text")) {
                        isManifestFirstNode = false;
                        break;
                    }
                    prevNode = prevNode.getPreviousSibling();
                }
            }
        }
        return isManifestFirstNode;
    }

    private void editAndroidManifest(ApplicationDescriptor descriptor, File tempAMF) throws IOException {
        try {
            NodeList usesPermissionList;
            String manifestInfo = descriptor.androidManifestInfo();
            String aspectRatio = descriptor.aspectRatio();
            Boolean autoOrients = descriptor.autoOrients();
            Boolean fullScreen = descriptor.fullscreen();
            String initialContent = descriptor.initialContent();
            String uniqueAppVersionID = UUID.randomUUID().toString();
            InputStream inAndMan = this.getClass().getResourceAsStream(ANDROID_MANIFEST_PATH);
            String dataPath = null;
            try {
                dataPath = this.getAndroidSDKPlatformDataPath();
            }
            catch (Exception ex) {
                dataPath = null;
            }
            StringPoolHandler.PopulateStringPool(dataPath);
            OrderManifestHandler.PopulateResourceMap(dataPath);
            if (manifestInfo == null && aspectRatio == null && autoOrients == null && fullScreen == null && uniqueAppVersionID == null && initialContent == null) {
                int len;
                System.out.println("Warning: Application has not specified its permission requirements in application.xml");
                FileOutputStream out = new FileOutputStream(tempAMF);
                byte[] buf = new byte[1024];
                while ((len = inAndMan.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                inAndMan.close();
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document androidManifestDoc = docBuilder.parse(inAndMan);
            if (manifestInfo != null) {
                String manifestInfoList = "<list><dict>" + manifestInfo + "</dict></list>";
                Document manifestInfoDoc = docBuilder.parse(new InputSource(new StringReader(manifestInfoList)));
                if (this.isManifestFirstNode(manifestInfoDoc)) {
                    this.addNodes(androidManifestDoc, manifestInfoDoc, "manifest");
                } else {
                    this.mLocalListener.message(new Message(405, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{"manifest"}));
                }
            }
            if (aspectRatio != null) {
                this.addMetaDataString(androidManifestDoc, "aspectRatio", aspectRatio);
            }
            if (autoOrients != null) {
                this.addMetaDataBoolean(androidManifestDoc, "autoOrients", autoOrients);
            }
            if (fullScreen != null) {
                this.addMetaDataBoolean(androidManifestDoc, "fullScreen", fullScreen);
            }
            if (uniqueAppVersionID != null) {
                this.addMetaDataString(androidManifestDoc, "uniqueappversionid", uniqueAppVersionID);
            }
            if (initialContent != null) {
                this.addMetaDataString(androidManifestDoc, "initialcontent", initialContent);
            }
            if ((usesPermissionList = androidManifestDoc.getElementsByTagName("uses-permission")).getLength() == 0) {
                System.out.println("Warning: Application has not specified its permission requirements in application.xml");
            }
            this.writeAndroidManifest(androidManifestDoc, tempAMF);
            inAndMan.close();
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (SAXException e3) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
        catch (ParserConfigurationException e4) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
    }

    private void addAttributes(Document androidManifestDoc, Document appDescriptorDoc, String tag) {
        NodeList androidManifestList = androidManifestDoc.getElementsByTagName(tag);
        Node androidmanifest = androidManifestList.item(0);
        Element e2 = (Element)androidmanifest;
        Node root = tag.equals("activity") ? appDescriptorDoc.getElementsByTagName(tag).item(this.index) : appDescriptorDoc.getElementsByTagName(tag).item(0);
        NamedNodeMap nodeAttrList = root.getAttributes();
        for (int i2 = 0; i2 < nodeAttrList.getLength(); ++i2) {
            Node node2 = nodeAttrList.item(i2);
            String attrName = node2.getNodeName();
            if (this.IsAttributeInExcludeList(attrName, tag)) continue;
            String attrValue = node2.getNodeValue();
            if (e2.hasAttribute(attrName)) {
                e2.removeAttribute(attrName);
            }
            e2.setAttribute(attrName, attrValue);
        }
    }

    private boolean IsAndroidSupportedTag(String tagName) {
        String[] toks = tagName.split("-");
        if (toks != null) {
            tagName = toks[0];
            for (int i2 = 1; i2 < toks.length; ++i2) {
                tagName = tagName + toks[i2];
            }
        }
        return StringPoolHandler.mStringTagNames.contains(tagName);
    }

    private boolean IsNodeInExcludeList(String nodeName, String tag) {
        if (tag.equals("manifest") && nodeName.equals("uses-sdk")) {
            this.mLocalListener.message(new Message(403, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{nodeName}));
            return true;
        }
        return false;
    }

    private boolean IsAttributeInExcludeList(String attribute2, String tag) {
        boolean isExcluded = false;
        if (tag.equals("manifest")) {
            if (attribute2.equals("package") || attribute2.equals("android:versionCode") || attribute2.equals("android:versionName")) {
                isExcluded = true;
            }
        } else if (tag.equals("application")) {
            if (attribute2.equals("android:label") || attribute2.equals("android:icon")) {
                isExcluded = true;
            }
        } else if (tag.equals("activity") && (attribute2.equals("android:theme") || attribute2.equals("android:label") || attribute2.equals("android:name") || attribute2.equals("android:launchMode") || attribute2.equals("android:screenOrientation") || attribute2.equals("android:configChanges") || attribute2.equals("android:windowSoftInputMode"))) {
            isExcluded = true;
        }
        if (isExcluded) {
            this.mLocalListener.message(new Message(404, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{attribute2}));
        }
        return isExcluded;
    }

    private boolean isLauncherActivity(Element activity) {
        boolean isActionMain = false;
        boolean isCategoryLauncher = false;
        NodeList intentFilterList = activity.getElementsByTagName("intent-filter");
        for (int i2 = 0; i2 < intentFilterList.getLength(); ++i2) {
            int j2;
            isActionMain = false;
            isCategoryLauncher = false;
            Element intentFilter = (Element)intentFilterList.item(i2);
            NodeList actionList = intentFilter.getElementsByTagName("action");
            NodeList categoryList = intentFilter.getElementsByTagName("category");
            for (j2 = 0; j2 < actionList.getLength(); ++j2) {
                Element action = (Element)actionList.item(j2);
                if (!action.getAttribute("android:name").equals("android.intent.action.MAIN")) continue;
                isActionMain = true;
                break;
            }
            for (j2 = 0; j2 < categoryList.getLength(); ++j2) {
                Element category = (Element)categoryList.item(j2);
                if (!category.getAttribute("android:name").equals("android.intent.category.LAUNCHER")) continue;
                isCategoryLauncher = true;
                break;
            }
            if (isActionMain && isCategoryLauncher) break;
        }
        return isActionMain && isCategoryLauncher;
    }

    private void addNodes(Document androidManifestDoc, Document appDescriptorDoc, String tag) {
        Node root;
        NodeList androidManifestList = androidManifestDoc.getElementsByTagName(tag);
        Node androidmanifest = androidManifestList.item(0);
        if (tag.equals("activity")) {
            root = appDescriptorDoc.getElementsByTagName(tag).item(this.index);
            Node intentFilter = ((Element)androidmanifest).getElementsByTagName("intent-filter").item(0);
            androidmanifest.removeChild(intentFilter);
        } else {
            root = appDescriptorDoc.getElementsByTagName(tag).item(0);
        }
        NodeList nodeList = root.getChildNodes();
        this.addAttributes(androidManifestDoc, appDescriptorDoc, tag);
        boolean firstLauncherActivity = false;
        boolean firstApplication = false;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (tag.equals("manifest") && node2.getNodeName().equals("application") && !firstApplication) {
                firstApplication = true;
                this.addNodes(androidManifestDoc, appDescriptorDoc, "application");
                continue;
            }
            if (tag.equals("application") && node2.getNodeName().equals("activity") && !firstLauncherActivity) {
                if (this.isLauncherActivity((Element)node2)) {
                    firstLauncherActivity = true;
                    this.addNodes(androidManifestDoc, appDescriptorDoc, "activity");
                    continue;
                }
                ++this.index;
            }
            if (node2.getNodeType() != 1) continue;
            if (!this.IsAndroidSupportedTag(node2.getNodeName())) {
                this.mLocalListener.message(new Message(402, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{node2.getNodeName()}));
                continue;
            }
            if (this.IsNodeInExcludeList(node2.getNodeName(), tag)) continue;
            androidmanifest.appendChild(androidManifestDoc.importNode(node2, true));
        }
    }

    private void writeAndroidManifest(Document androidManifestDoc, File tempAMF) throws IOException {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(androidManifestDoc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            byte[] buf = xmlString.getBytes();
            FileOutputStream out = new FileOutputStream(tempAMF);
            ((OutputStream)out).write(buf, 0, buf.length);
            ((OutputStream)out).close();
            buf = null;
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (TransformerConfigurationException e3) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
        catch (TransformerException e4) {
            this.mLocalListener.message(new Message(100, "ERROR", this.mDescriptorFileName, -1, -1, null));
        }
    }

    private void addMetaDataString(Document androidManifestDoc, String name, String value) {
        NodeList activityElem = androidManifestDoc.getElementsByTagName("activity");
        Element elem = androidManifestDoc.createElement("meta-data");
        elem.setAttribute("android:name", name);
        elem.setAttribute("android:value", value);
        activityElem.item(0).appendChild(elem);
    }

    private void addMetaDataBoolean(Document androidManifestDoc, String name, Boolean value) {
        NodeList activityElem = androidManifestDoc.getElementsByTagName("activity");
        Element elem = androidManifestDoc.createElement("meta-data");
        elem.setAttribute("android:name", name);
        if (value.booleanValue()) {
            elem.setAttribute("android:value", "true");
        } else {
            elem.setAttribute("android:value", "false");
        }
        activityElem.item(0).appendChild(elem);
    }

    public void setExtensionsJars(File[] extensions) {
        this.m_extensionsJars = extensions;
    }
}

