/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.android;

import com.adobe.air.ADTDeviceSDK;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AndroidDeviceSDK
extends ADTDeviceSDK {
    private HashMap<Integer, File> m_platforms;
    private int m_highestPlatform;
    private File m_adbLocation;

    public AndroidDeviceSDK(File sdk) throws InvalidInputException {
        super(sdk);
        this.m_adbLocation = new File(new File(this.m_sdkLocation, "tools"), "adb.exe");
        if (!this.m_adbLocation.exists()) {
            this.m_adbLocation = new File(new File(this.m_sdkLocation, "tools"), "adb");
        }
        if (null == this.m_adbLocation || !this.m_adbLocation.exists()) {
            throw new InvalidInputException("Could not locate adb: " + this.m_adbLocation);
        }
        this.m_highestPlatform = 0;
        File platforms = new File(this.m_sdkLocation, "platforms");
        if (platforms.exists() && platforms.isDirectory()) {
            File[] platformDirs = platforms.listFiles();
            for (int idx = 0; idx < platformDirs.length; ++idx) {
                File sourceProps;
                if (null == this.m_platforms) {
                    this.m_platforms = new HashMap();
                }
                if (null == (sourceProps = new File(platformDirs[idx], "source.properties")) || !sourceProps.exists()) continue;
                try {
                    FileInputStream sourcePropsStream = new FileInputStream(sourceProps);
                    String sourcePropsStreamText = new String(Utils.readIn(sourcePropsStream), "UTF-8");
                    Pattern packagePatt = Pattern.compile("^AndroidVersion.ApiLevel=(\\d+)$", 8);
                    Matcher match = packagePatt.matcher(sourcePropsStreamText);
                    if (!match.find()) continue;
                    int apiValue = new Integer(match.group(1));
                    this.m_highestPlatform = Math.max(apiValue, this.m_highestPlatform);
                    this.m_platforms.put(apiValue, platformDirs[idx]);
                    continue;
                }
                catch (FileNotFoundException e2) {
                    continue;
                }
                catch (UnsupportedEncodingException e3) {
                    continue;
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        if (this.m_highestPlatform == 0) {
            throw new InvalidInputException("Could not locate platform directories: " + platforms);
        }
    }

    public File getADBLocation() {
        return this.m_adbLocation;
    }

    public File getPlatformDirectoryForLatestAPI() {
        return this.m_platforms.get(this.m_highestPlatform);
    }

    protected File getDefaultSDKLocation() {
        File defLocation = null;
        String sdkPath = System.getenv("AIR_ANDROID_SDK_HOME");
        if (null != sdkPath) {
            defLocation = new File(sdkPath);
        }
        return defLocation;
    }
}

