/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.android;

import com.adobe.air.ADTDeviceOperations;
import com.adobe.air.ADTException;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidDeviceOperations
implements ADTDeviceOperations {
    private File m_adb;
    private String m_device;

    private static String getPackageName(String appID) {
        if (appID.equalsIgnoreCase("com.adobe.air")) {
            return appID;
        }
        return APKOutputStream.getPackageName(appID);
    }

    private static String getPattern(String pattern, String source) throws IOException {
        Pattern versionPatt = Pattern.compile(pattern, 8);
        Matcher fit = versionPatt.matcher(source);
        if (source.length() == 0 || !fit.find()) {
            throw new IOException("Pattern (" + versionPatt + ") not found in (" + source + ")");
        }
        return fit.group(1);
    }

    private String getADBDevice() throws IOException, InvalidInputException {
        List<String> devices = this.getADBDevices();
        if (devices.size() == 0) {
            throw new ADTException("No Devices Detected", 15);
        }
        if (devices.size() > 1) {
            throw new InvalidInputException("Must specify -device parameter when more than one device is available");
        }
        return devices.get(0);
    }

    private List<String> getADBDevices() throws IOException, InvalidInputException {
        String stdout;
        List<String> command = this.getADBCommandArgs("devices", null);
        try {
            stdout = this.execADB(command);
        }
        catch (Exception e2) {
            throw new ADTException("Unable to enumerate devices", 13);
        }
        Pattern packagePatt = Pattern.compile("^([^\t\n\r]+)\t[^\t]+$", 8);
        Matcher match = packagePatt.matcher(stdout);
        ArrayList<String> results = new ArrayList<String>();
        while (match.find()) {
            results.add(match.group(1));
        }
        return results;
    }

    private List<String> getADBCommandArgs(String ADBCommand, String param) throws IOException, InvalidInputException {
        if (null == this.m_adb || !this.m_adb.exists()) {
            throw new ADTException("Could not locate adb: " + this.m_adb, 13);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.m_adb.getAbsolutePath());
        if (param != null) {
            if (this.m_device == null || this.m_device.length() == 0) {
                this.m_device = this.getADBDevice();
            } else {
                List<String> devices = this.getADBDevices();
                if (!devices.contains(this.m_device)) {
                    throw new InvalidInputException("Invalid <device> specified");
                }
            }
        }
        if (this.m_device != null && this.m_device.length() > 0) {
            command.add("-s");
            command.add(this.m_device);
        }
        command.add(ADBCommand);
        if (param != null && param.length() > 0) {
            command.add(param);
        }
        return command;
    }

    private String execADB(List<String> command) throws InterruptedException, IOException, ADTException {
        return this._execADB(command, false);
    }

    private String execADB(List<String> command, boolean ignoreStdErr) throws InterruptedException, IOException, ADTException {
        return this._execADB(command, ignoreStdErr);
    }

    private String _execADB(List<String> command, boolean ignoreStdErr) throws InterruptedException, IOException, ADTException {
        Process adb = Utils.execSafely(null, command);
        ByteArrayOutputStream adbOutBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream adbErrBytes = new ByteArrayOutputStream();
        new Utils.OutputEater(adb.getInputStream(), adbOutBytes).run();
        new Utils.OutputEater(adb.getErrorStream(), adbErrBytes).run();
        adb.waitFor();
        if (!ignoreStdErr && adbErrBytes.size() > 0) {
            throw new ADTException("Error executing:" + command.get(0) + " error:" + adbErrBytes.toString(), 14);
        }
        return adbOutBytes.toString("UTF-8");
    }

    @Override
    public void installApplication(File application) throws IOException, InvalidInputException {
        if (application == null) {
            throw new InvalidInputException("Missing <apk-file> ");
        }
        if (!application.exists()) {
            throw new InvalidInputException("Cannot find <apk-file> " + application.getCanonicalPath());
        }
        List<String> command = this.getADBCommandArgs("install", application.getCanonicalPath());
        try {
            String stdout = this.execADB(command, true);
            Pattern packagePatt = Pattern.compile("^Success.*$", 8);
            Matcher match = packagePatt.matcher(stdout);
            if (!match.find()) {
                throw new Exception();
            }
        }
        catch (Exception e2) {
            throw new ADTException("Failed to install " + application.getCanonicalPath(), 14);
        }
    }

    @Override
    public void installRuntime(File runtime) throws IOException, InvalidInputException, SDKDamagedException {
        String adbDevice = this.m_device;
        if (adbDevice == null || adbDevice.length() == 0) {
            adbDevice = this.getADBDevice();
        }
        if (runtime == null) {
            String runtimePath = adbDevice.indexOf("emulator") > -1 ? "emulator" + File.separator + "Runtime.apk" : "device" + File.separator + "Runtime.apk";
            try {
                runtimePath = Utils.getJarFile().getParentFile().getParentFile() + File.separator + "runtimes" + File.separator + "air" + File.separator + "android" + File.separator + runtimePath;
                runtime = new File(runtimePath);
            }
            catch (IOException e2) {
                throw new SDKDamagedException(runtimePath);
            }
            if (!runtime.exists()) {
                throw new SDKDamagedException(runtimePath);
            }
        }
        this.installApplication(runtime);
    }

    @Override
    public void uninstallApplication(String application) throws IOException, InvalidInputException {
        if (application == null || application.equals("")) {
            throw new InvalidInputException("<app-id> must be non-zero length");
        }
        String packageName = AndroidDeviceOperations.getPackageName(application);
        List<String> command = this.getADBCommandArgs("uninstall", packageName);
        try {
            String stdout = this.execADB(command);
            if (stdout.indexOf("Failure") > -1) {
                throw new Exception();
            }
        }
        catch (Exception e2) {
            List<String> packages = this.getInstalledPackages();
            if (packages.contains(packageName)) {
                throw new ADTException("Failed to uninstall " + application, 14);
            }
            throw new ADTException("Failed to find package " + application, 14);
        }
    }

    @Override
    public void uninstallRuntime() throws IOException, InvalidInputException {
        this.uninstallApplication("com.adobe.air");
    }

    @Override
    public void launchApplication(String application) throws InvalidInputException, IOException {
        if (application == null || application.equals("")) {
            throw new InvalidInputException("<app-id> must be non-zero length");
        }
        String packageName = APKOutputStream.getPackageName(application);
        List<String> command = this.getADBCommandArgs("shell", "am");
        command.add("start");
        command.add("-a");
        command.add("android.intent.action.MAIN");
        command.add("-n");
        command.add(packageName + "/" + packageName + ".AppEntry");
        try {
            String stdout = this.execADB(command);
            if (stdout.indexOf("Error type 3") > -1) {
                throw new Exception();
            }
        }
        catch (Exception e2) {
            throw new ADTException("Failed to launch " + application, 14);
        }
    }

    private List<String> getInstalledPackages() throws InvalidInputException, FileNotFoundException, IOException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            List<String> command = this.getADBCommandArgs("shell", "pm");
            command.add("list");
            command.add("packages");
            String stdout = this.execADB(command);
            Pattern packagePatt = Pattern.compile("^package:(.*)$", 8);
            Matcher match = packagePatt.matcher(stdout);
            while (match.find()) {
                results.add(match.group(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    @Override
    public String getApplicationVersion(String application) throws FileNotFoundException, InvalidInputException, IOException {
        String versionCode;
        String packagePath;
        if (application == null || application.equals("")) {
            throw new InvalidInputException("<app-id> must be non-zero length");
        }
        String packageName = AndroidDeviceOperations.getPackageName(application);
        List<String> command = this.getADBCommandArgs("shell", "pm");
        command.add("path");
        command.add(packageName);
        try {
            String stdout = this.execADB(command);
            packagePath = AndroidDeviceOperations.getPattern("^package:(.*)$", stdout);
        }
        catch (Exception e2) {
            throw new ADTException("Failed to find package " + application, 14);
        }
        command = this.getADBCommandArgs("shell", "/system/bin/dalvikvm");
        command.add("-classpath");
        command.add(packagePath);
        command.add(packageName + ".GetVersionCode");
        try {
            String stdout = this.execADB(command);
            if (stdout.indexOf("java.lang.NoClassDefFoundError") > -1) {
                throw new Exception();
            }
            versionCode = AndroidDeviceOperations.getPattern("^(.*)$", stdout);
        }
        catch (Exception e3) {
            throw new ADTException("Failed to find package " + application, 14);
        }
        return versionCode;
    }

    @Override
    public String getRuntimeVersion() throws IOException {
        return this.getApplicationVersion("com.adobe.air");
    }

    public void setDeviceID(String deviceID) {
        this.m_device = deviceID;
    }

    public void setAndroidDeviceSDK(AndroidDeviceSDK sdk) throws InvalidInputException {
        if (sdk == null) {
            throw new InvalidInputException("sdk must be non-null");
        }
        this.m_adb = sdk.getADBLocation();
    }
}

