/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.Descriptor;
import com.adobe.air.Utils;
import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator10;
import com.adobe.air.validator.ApplicationDescriptorValidator20;
import com.adobe.air.validator.ApplicationDescriptorValidator25;
import com.adobe.air.validator.DescriptorValidationException;
import java.awt.Dimension;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
extends Descriptor {
    private static final String NAMESPACE_1_0 = "http://ns.adobe.com/air/application/1.0";
    private static final String NAMESPACE_1_1 = "http://ns.adobe.com/air/application/1.1";
    private static final String NAMESPACE_1_5 = "http://ns.adobe.com/air/application/1.5";
    private static final String NAMESPACE_1_5_1 = "http://ns.adobe.com/air/application/1.5.1";
    private static final String NAMESPACE_1_5_2 = "http://ns.adobe.com/air/application/1.5.2";
    private static final String NAMESPACE_1_5_3 = "http://ns.adobe.com/air/application/1.5.3";
    private static final String NAMESPACE_2_0 = "http://ns.adobe.com/air/application/2.0";
    private static final String NAMESPACE_2_5 = "http://ns.adobe.com/air/application/2.5";
    private static final Map<String, String> NAMESPACES;

    public ApplicationDescriptor(File descriptorFile) throws DescriptorValidationException {
        super(descriptorFile, true);
    }

    public ApplicationDescriptor(InputStream in) throws DescriptorValidationException {
        super(in, true);
    }

    public ApplicationDescriptor(File descriptorFile, boolean validate) throws DescriptorValidationException {
        super(descriptorFile, validate);
    }

    public ApplicationDescriptor(InputStream in, boolean validate) throws DescriptorValidationException {
        super(in, validate);
    }

    public void validateForAIRIPackaging(SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validateFiles(sources, true, true);
    }

    public void validateForAIRPackaging() throws DescriptorValidationException {
        String[] requiredProfiles = new String[]{"desktop", "mobileDevice", "extendedMobileDevice", "tv"};
        boolean foundProfile = false;
        for (String profile : requiredProfiles) {
            if (!this.hasProfile(profile)) continue;
            foundProfile = true;
            break;
        }
        if (!foundProfile) {
            this.dispatchError(306, -1, -1, new String[]{Utils.stringJoin(requiredProfiles, ", ")});
        }
        if (this._validator instanceof ApplicationDescriptorValidator25 && ((ApplicationDescriptorValidator25)this._validator).getRequiredExtensions().size() > 0) {
            this.dispatchError(112);
        }
    }

    public void validateForAIRPackaging(SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validateForAIRPackaging();
        boolean allowHTML = true;
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            int numProfiles = ((ApplicationDescriptorValidator20)this._validator).supportedProfiles().size();
            allowHTML = numProfiles != 1 || !this.hasProfile("tv");
        }
        this.validateFiles(sources, allowHTML, false);
    }

    public void validateForNativePackaging() throws DescriptorValidationException {
        if (!(this._validator instanceof ApplicationDescriptorValidator20)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(NAMESPACE_2_0)});
        }
        if (!this.hasProfile("extendedDesktop")) {
            this.dispatchError(306, -1, -1, new String[]{"extendedDesktop"});
        }
    }

    public void validateForNativePackaging(SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validateForNativePackaging();
        this.validateFiles(sources, true, false);
    }

    public void validateForIPAPackaging() throws DescriptorValidationException {
        if (!(this._validator instanceof ApplicationDescriptorValidator20)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(NAMESPACE_2_0)});
        }
        if (!this.hasProfile("mobileDevice")) {
            this.dispatchError(306, -1, -1, new String[]{"mobileDevice"});
        }
    }

    public void validateForIPAPackaging(SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validateForIPAPackaging();
        this.validateFiles(sources, false, true);
    }

    public void validateForAPKPackaging() throws DescriptorValidationException {
        if (!(this._validator instanceof ApplicationDescriptorValidator25)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(NAMESPACE_2_5)});
        }
        if (!this.hasProfile("mobileDevice")) {
            this.dispatchError(306, -1, -1, new String[]{"mobileDevice"});
        }
    }

    public void validateForAPKPackaging(SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validateForAPKPackaging();
        this.validateFiles(sources, false, true);
    }

    public void validateForAIRNPackaging() throws DescriptorValidationException {
        if (!(this._validator instanceof ApplicationDescriptorValidator25)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(NAMESPACE_2_5)});
        }
        if (!this.hasProfile("extendedTV")) {
            this.dispatchError(306, -1, -1, new String[]{"extendedTV"});
        }
    }

    public void validateForAIRNPackaging(SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validateForAIRNPackaging();
        this.validateFiles(sources, false, false);
    }

    private void validateFiles(SortedMap<String, File> sources, boolean allowHTML, boolean allowCrushedPNG) throws DescriptorValidationException {
        if (this._validator == null) {
            throw new IllegalStateException("Tried to validate a descriptor's files before its xml");
        }
        this.failIfError();
        TreeMap<String, File> validatorSources = new TreeMap<String, File>();
        validatorSources.putAll(sources);
        this.getValidator().validateRootContentFile(validatorSources, allowHTML);
        this.failIfError();
        this.getValidator().validateImageFiles(validatorSources, allowCrushedPNG);
        this.failIfError();
    }

    private boolean hasProfile(String profile) throws DescriptorValidationException {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).supportedProfiles().contains(profile);
        }
        return profile == "desktop";
    }

    public void validateIcon(InputStream is, String name, boolean allowCrushedPNG) throws DescriptorValidationException {
        this.getValidator().validateImage(is, name, allowCrushedPNG);
        this.failIfError();
    }

    public void validateInitialContent(InputStream is, boolean allowHTML) throws DescriptorValidationException {
        this.getValidator().validateRootContentFile(is, allowHTML);
        this.failIfError();
    }

    public String filename() {
        return ((ApplicationDescriptorValidator10)this._validator).filename();
    }

    public String initialWindowTitle() {
        String value = ((ApplicationDescriptorValidator10)this._validator).initialWindowTitle();
        return value == null || value.length() == 0 ? this.name() : value;
    }

    public String name() {
        String value = ((ApplicationDescriptorValidator10)this._validator).name();
        return value == null || value.trim().length() == 0 ? this.filename() : value;
    }

    public Map<String, String> localizedNames() {
        if (this._localizedNames == null) {
            this._localizedNames = new HashMap();
            NodeList textList = this._document.getElementsByTagName("text");
            for (int i2 = 0; i2 < textList.getLength(); ++i2) {
                if (!textList.item(i2).getParentNode().getLocalName().equals("name")) continue;
                String lang = textList.item(i2).getAttributes().item(0).getNodeValue();
                String name = textList.item(i2).getTextContent();
                this._localizedNames.put(lang, name);
            }
        }
        return this._localizedNames;
    }

    public String id() {
        return ((ApplicationDescriptorValidator10)this._validator).id();
    }

    public String versionNumber() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            return ((ApplicationDescriptorValidator25)this._validator).versionNumber();
        }
        Pattern pattern = Pattern.compile("(\\d+)(?:\\D+(\\d+))?(?:\\D+(\\d+))?");
        Matcher matcher = pattern.matcher(((ApplicationDescriptorValidator10)this._validator).version());
        String convertedVersion = "";
        if (matcher.find()) {
            for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                String match = matcher.group(i2);
                if (match == null || match.length() <= 0) continue;
                convertedVersion = Integer.parseInt(match) > 999 ? convertedVersion + "999." : convertedVersion + match + ".";
            }
        } else {
            return "1";
        }
        return convertedVersion.substring(0, convertedVersion.length() - 1);
    }

    public String versionLabel() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            if (((ApplicationDescriptorValidator25)this._validator).versionLabel().equals("")) {
                return ((ApplicationDescriptorValidator25)this._validator).versionNumber();
            }
            return ((ApplicationDescriptorValidator25)this._validator).versionLabel();
        }
        return ((ApplicationDescriptorValidator10)this._validator).version();
    }

    public String copyright() {
        return ((ApplicationDescriptorValidator10)this._validator).copyright();
    }

    public Boolean visible() {
        return ((ApplicationDescriptorValidator10)this._validator).visible();
    }

    public String aspectRatio() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).aspectRatio();
        }
        return null;
    }

    public String renderMode() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).renderMode();
        }
        return null;
    }

    public Boolean autoOrients() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).autoOrients();
        }
        return null;
    }

    public Boolean fullscreen() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).fullScreen();
        }
        return null;
    }

    public String getIcon(int size) {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons().get(size);
    }

    public Dimension getIconDimension(String path) {
        return this.getValidator().getIconDimension(path);
    }

    public Collection<String> appIcons() {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons().values();
    }

    public Collection<String> icons() {
        return this.getValidator().getIcons();
    }

    public String initialContent() {
        return ((ApplicationDescriptorValidator10)this._validator).initialContent();
    }

    public String iosInfoAdditions() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).infoAdditions();
        }
        return null;
    }

    public String androidManifestInfo() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            return ((ApplicationDescriptorValidator25)this._validator).manifestAdditions();
        }
        return null;
    }

    public boolean migrationGracePeriodInEffect() {
        return this._validator.migrationGracePeriodInEffect();
    }

    public boolean usePackageSignatureForTimestamps() {
        boolean result = true;
        if (this._validator != null) {
            result = this._validator.usePackageSignatureForTimestamps();
        }
        return result;
    }

    @Override
    public byte[] getBytes() {
        return this._descriptorBytes;
    }

    private String getVersionFromNamespace(String namespace) {
        return namespace.substring(namespace.lastIndexOf(47) + 1);
    }

    protected Set<String> getRequiredExtensions() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            return ((ApplicationDescriptorValidator25)this._validator).getRequiredExtensions();
        }
        return null;
    }

    public String getDescriptorFileName() {
        return this._descriptorFileName;
    }

    @Override
    protected String getValidatorClassNameFromNamespaceUri(String namespaceUri) {
        return NAMESPACES.get(namespaceUri);
    }

    @Override
    protected ApplicationDescriptorValidator getValidator() {
        return (ApplicationDescriptorValidator)this._validator;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(NAMESPACE_1_0, "com.adobe.air.validator.ApplicationDescriptorValidator10");
        tempMap.put(NAMESPACE_1_1, "com.adobe.air.validator.ApplicationDescriptorValidator11");
        tempMap.put(NAMESPACE_1_5, "com.adobe.air.validator.ApplicationDescriptorValidator15");
        tempMap.put(NAMESPACE_1_5_1, "com.adobe.air.validator.ApplicationDescriptorValidator151");
        tempMap.put(NAMESPACE_1_5_2, "com.adobe.air.validator.ApplicationDescriptorValidator152");
        tempMap.put(NAMESPACE_1_5_3, "com.adobe.air.validator.ApplicationDescriptorValidator153");
        tempMap.put(NAMESPACE_2_0, "com.adobe.air.validator.ApplicationDescriptorValidator20");
        tempMap.put(NAMESPACE_2_5, "com.adobe.air.validator.ApplicationDescriptorValidator25");
        NAMESPACES = Collections.unmodifiableMap(tempMap);
    }
}

