/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTException;
import com.adobe.air.ADTPackager;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.CertificateCreationException;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.pki.TimestampException;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.MessageFormat;

public abstract class ADTEntrypoint
extends UCF {
    public static final String MIMETYPE_AIR = "application/vnd.adobe.air-application-installer-package+zip";
    public static final String MIMETYPE_AIRI = "application/vnd.adobe.air-application-intermediate-package+zip";
    public static final String MIMETYPE_ANE = "application/vnd.adobe.air-native-extension-package+zip";
    public static final String MIMETYPE_AIRN = "application/vnd.adobe.air-native-application-installer-package+zip";
    public static final String PATH_APP_DESCRIPTOR = "META-INF/AIR/application.xml";
    public static final String PATH_HASH = "META-INF/AIR/hash";
    public static final String PATH_DEBUG = "META-INF/AIR/debug";
    public static final String PATH_AIR = "META-INF/AIR";
    public static final String PATH_ANE = "META-INF/ANE";
    public static final String PATH_EXTENSION_DESCRIPTOR = "META-INF/ANE/extension.xml";
    public static final String ARG_PLATFORM_SDK = "-platformsdk";
    protected static final String ARG_PACKAGE = "-package";
    protected static final String ARG_TARGET = "-target";
    protected static final String ARG_VERSION = "-version";
    private static final String ARG_DEBUG = "-Xdebug";
    protected static final String ARG_CONNECT = "-connect";
    protected static final String ARG_EXTDIR = "-extdir";
    protected static final String ARG_PLATFORM = "-platform";
    protected static final String ARG_SWC = "-swc";
    protected static final String VERSION_STRING = "{0} version \"{1}\"";
    protected boolean m_debug;
    private int m_exitCode = 0;
    private ADTPackager m_packager;

    public abstract String getExecutableName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int run(String[] argv) {
        this.args = new Arguments(argv);
        try {
            this.parseArgsAndGo();
        }
        catch (UsageError e2) {
            System.err.println(e2.getMessage());
            this.printUsage();
            this.m_exitCode = e2.getExitCode();
        }
        catch (CertificateNotYetValidException e3) {
            System.err.println(e3.getMessage());
            this.m_exitCode = 8;
        }
        catch (CertificateExpiredException e4) {
            System.err.println(e4.getMessage());
            this.m_exitCode = 8;
        }
        catch (GeneralSecurityException e5) {
            System.err.println(e5.getMessage());
            this.m_exitCode = 9;
        }
        catch (TimestampException e6) {
            System.err.println(e6.getMessage());
            this.m_exitCode = 10;
        }
        catch (CertificateCreationException e7) {
            System.err.println(e7.getMessage());
            this.m_exitCode = 11;
        }
        catch (SDKDamagedException e8) {
            System.err.println("SDK is missing file " + e8.getMissingFilePath());
            this.m_exitCode = 5;
        }
        catch (DescriptorValidationException e9) {
            System.out.println(e9.getMessage());
            this.m_exitCode = 12;
        }
        catch (InvalidInputException e10) {
            System.err.println(e10.getMessage());
            this.m_exitCode = 12;
        }
        catch (ADTException e11) {
            System.err.println(e11.getMessage());
            this.m_exitCode = e11.getExitCode();
        }
        catch (Exception e12) {
            System.err.println("unexpected failure: " + e12.getMessage());
            e12.printStackTrace();
            this.m_exitCode = 5;
        }
        finally {
            if (this.m_packager != null) {
                this.m_packager.close();
            }
        }
        return this.m_exitCode;
    }

    protected void parseArgsAndGo() throws UsageError, GeneralSecurityException, IOException {
        if (!this.args.peek()) {
            throw new UsageError("No arguments were found");
        }
        if (this.args.peek("-help")) {
            this.parseUsage();
        } else if (this.args.peek(ARG_PACKAGE)) {
            this.parsePackage();
            this.getPackager().createPackage();
        } else if (this.args.peek(ARG_VERSION)) {
            this.parseVersion();
        } else {
            throw new UsageError("unexpected argument " + this.args.accept());
        }
    }

    protected void parsePackage() throws UsageError {
        this.args.accept(ARG_PACKAGE);
        this.parseUndocumentedParams();
        this.parseAppSigningOptions();
        this.parseTarget();
        this.parseConnectOptions();
        this.parseNativeSigningOptions();
        this.parseOutput(this.getPackager(), this.getFileExtension());
        this.parseInput();
    }

    protected void parseUndocumentedParams() throws UsageError {
        while (this.parseUndocumentedParam()) {
        }
    }

    protected boolean parseUndocumentedParam() throws UsageError {
        if (this.args.peek(ARG_DEBUG)) {
            this.args.accept(ARG_DEBUG);
            this.getAppPackager().setDebug(true);
            this.m_debug = true;
            return true;
        }
        return false;
    }

    protected abstract void parseConnectOptions() throws UsageError;

    protected void parseAppSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.parseSigningOptions(this.getPackager());
        }
    }

    protected abstract void parseTarget() throws UsageError;

    protected void parseNativeSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.parseSigningOptions(this.getPackager());
        }
    }

    protected void parseOutput(ISigner p2, String fileExtension) throws UsageError {
        try {
            p2.setOutput(Utils.getFileWithExtension(this.args.accept(), fileExtension));
        }
        catch (FileNotFoundException ex) {
            throw new UsageError("output directory is not writable", 6);
        }
        catch (IOException ex) {
            throw new UsageError("output file is not writable", 6);
        }
    }

    protected abstract String getFileExtension();

    protected void parseInput() throws UsageError {
        File firstFile = new File(this.args.accept()).getAbsoluteFile();
        if (this.args.peek(ARG_PLATFORM_SDK)) {
            this.args.accept();
            try {
                this.getAppPackager().setDeviceSDKDirectory(new File(this.args.accept()));
            }
            catch (InvalidInputException e2) {
                throw new UsageError(e2.getLocalizedMessage(), 12);
            }
        }
        if (this.args.peek()) {
            this.parseDescriptorAndFileset(firstFile);
        } else {
            if (!firstFile.exists()) {
                throw new UsageError("File " + firstFile.getPath() + " does not exist");
            }
            String mimetype = Utils.getMimetype(firstFile);
            if (MIMETYPE_AIR.equals(mimetype)) {
                this.parseAIRFile(firstFile);
            } else if (MIMETYPE_AIRI.equals(mimetype)) {
                this.parseAIRIFile(firstFile);
            } else {
                throw new UsageError("File " + firstFile.getPath() + " is not a valid AIRI or AIR file", 12);
            }
        }
    }

    protected void parseFileAndPathArguments() throws UsageError {
        try {
            if (!this.args.peek()) {
                throw new UsageError("at least one file is required");
            }
            while (this.args.peek()) {
                if (this.args.peek("-C")) {
                    this.args.accept();
                    this.cwd = new File(this.args.accept());
                    continue;
                }
                if (this.args.peek(ARG_PLATFORM_SDK)) {
                    this.args.accept();
                    this.getAppPackager().setDeviceSDKDirectory(new File(this.args.accept()));
                    continue;
                }
                if (this.args.peek("-e")) {
                    this.args.accept();
                    this.getPackager().addSourceWithPath(new File(this.args.accept()), this.args.accept());
                    continue;
                }
                if (this.args.peek(ARG_EXTDIR)) {
                    this.args.accept();
                    this.getAppPackager().addExtensionDir(new File(this.args.accept()).getAbsoluteFile());
                    continue;
                }
                this.getPackager().addSourceFileOrDir(new File(this.args.accept()), this.cwd);
            }
        }
        catch (InvalidInputException e2) {
            throw new UsageError(e2.getLocalizedMessage());
        }
        catch (IllegalArgumentException e3) {
            throw new UsageError(e3.getLocalizedMessage());
        }
    }

    protected void parseDescriptorAndFileset(File descriptor) throws UsageError {
        this.getAppPackager().setApplicationDescriptor(descriptor);
        this.parseFileAndPathArguments();
    }

    protected void parseAIRFile(File airFile) throws UsageError {
        this.getAppPackager().setAIRFile(airFile);
    }

    protected void parseAIRIFile(File airiFile) throws UsageError {
        this.getAppPackager().setAIRIFile(airiFile);
    }

    private void parseVersion() throws UsageError {
        this.args.accept(ARG_VERSION);
        MessageFormat mf = new MessageFormat(VERSION_STRING);
        String version = mf.format(new Object[]{this.getExecutableName(), "2.5.0.16610"});
        System.out.println(version);
    }

    protected ADTPackager getPackager() {
        if (this.m_packager == null) {
            this.m_packager = this.newPackager();
        }
        return this.m_packager;
    }

    protected ApplicationPackager getAppPackager() {
        return (ApplicationPackager)this.getPackager();
    }

    protected abstract ADTPackager newPackager();
}

