/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTEntrypoint;
import com.adobe.air.ADTException;
import com.adobe.air.ADTPackager;
import com.adobe.air.AIRMigrationSigner;
import com.adobe.air.AIRNPackager;
import com.adobe.air.AIRPackager;
import com.adobe.air.ANEPackager;
import com.adobe.air.CertificateCreator;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceOperations;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKPackager;
import com.adobe.air.nai.DEBPackager;
import com.adobe.air.nai.DMGPackager;
import com.adobe.air.nai.EXEPackager;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.nai.RPMPackager;
import com.adobe.argv.UsageError;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.HashSet;

public final class ADT
extends ADTEntrypoint {
    public static final String DEFAULT_TSA_URL = "https://timestamp.geotrust.com/tsa";
    private static final String FILE_EXT_AIR = "air";
    private static final String FILE_EXT_AIRI = "airi";
    private static final String FILE_EXT_AIRN = "airn";
    private static final String FILE_EXT_EXE = "exe";
    private static final String FILE_EXT_DMG = "dmg";
    private static final String FILE_EXT_RPM = "rpm";
    private static final String FILE_EXT_DEB = "deb";
    private static final String FILE_EXT_APK = "apk";
    private static final String FILE_EXT_ANE = "ane";
    public static final int ERROR_UNKNOWN = 5;
    public static final int ERROR_TIMESTAMP_GEN = 10;
    public static final int ERROR_CERTIFICATE_GEN = 11;
    public static final int ERROR_INVALID_INPUT = 12;
    public static final int ERROR_MISSING_DEVICE_SDK = 13;
    public static final int ERROR_DEVICE_ERROR = 14;
    public static final int ERROR_NO_DEVICES = 15;
    private static final String ARG_PREPARE = "-prepare";
    private static final String ARG_SIGN = "-sign";
    private static final String ARG_MIGRATE = "-migrate";
    private static final String ARG_CERT = "-certificate";
    private static final String ARG_CHECK_PASS = "-checkstore";
    private static final String ARG_NO_VALIDATE = "-Xnovalidate";
    private static final String ARG_RUNTIME = "-Xruntime";
    private static final String ARG_CONNECT = "-connect";
    private static final String ARG_NATIVE = "native";
    public static final String ARG_INSTALLAPP = "-installApp";
    public static final String ARG_INSTALLRUNTIME = "-installRuntime";
    public static final String ARG_UNINSTALLAPP = "-uninstallApp";
    public static final String ARG_UNINSTALLRUNTIME = "-uninstallRuntime";
    public static final String ARG_LAUNCHAPP = "-launchApp";
    public static final String ARG_APPVERSION = "-appVersion";
    public static final String ARG_RUNTIMEVERSION = "-runtimeVersion";
    public static final String ARG_PLATFORM = "-platform";
    public static final String ARG_DEVICE = "-device";
    public static final String ARG_PACKAGE = "-package";
    public static final String ARG_APPID = "-appid";
    private static String Adobe_patent_P817 = "AdobePatentId=\"P817\"";
    private static String Adobe_patent_P851 = "AdobePatentId=\"P851\"";
    private Target m_target;
    private String m_targetValue;
    private CertificateCreator m_creator;
    private boolean m_signingApp = false;

    public static void main(String[] args) {
        ADT adt = new ADT();
        int result = adt.run(args);
        System.exit(result);
    }

    public String getExecutableName() {
        return "adt";
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  adt -checkstore SIGNING_OPTIONS");
        System.err.println("  adt -certificate -cn <name> ( -ou <org-unit> )? ( -o <org-name> )? ( -c <country> )? ( -validityPeriod <years> )? ( 1024-RSA | 2048-RSA ) <pfx-file> <password>");
        System.err.println("  adt -help");
        System.err.println("  adt -migrate SIGNING_OPTIONS ( <air-file-in> | <airn-file-in> ) <output-file>");
        System.err.println("  adt -package SIGNING_OPTIONS ( -target air )? <output-package> ( <app-desc> FILE_OPTIONS | <input-package> )");
        System.err.println("  adt -package SIGNING_OPTIONS -target airn <output-package> ( <app-desc> FILE-AND-PATH-OPTIONS | <input-package> )");
        System.err.println("  adt -package -target ( apk | apk-debug | apk-emulator ) ( CONNECT_OPTIONS ) SIGNING_OPTIONS <output-package> ( <app-desc> PLATFORM-SDK-OPTION? FILE-OPTIONS | <input-package> PLATFORM-SDK-OPTION? )");
        System.err.println("  adt -package SIGNING_OPTIONS? -target native SIGNING_OPTIONS? <output-package> ( <app-desc> FILE-OPTIONS | <input-package> )");
        System.err.println("  adt -package SIGNING-OPTIONS -target ane <output-package> <ext-desc> ANE-OPTIONS");
        System.err.println("  adt -prepare <airi-file> <app-desc> FILE_AND_PATH_OPTIONS");
        System.err.println("  adt -sign SIGNING_OPTIONS ( -target ( air | airn | ane ) )? ( <airi-file> | <unsigned-ane-file> ) <output-file>");
        System.err.println("  adt -installRuntime   PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )? ( -package <apk-file> )?");
        System.err.println("  adt -installApp       PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )? -package <apk-file>");
        System.err.println("  adt -uninstallRuntime PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )?");
        System.err.println("  adt -uninstallApp     PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )? -appid <app-id>");
        System.err.println("  adt -launchApp        PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )? -appid <app-id>");
        System.err.println("  adt -runtimeVersion   PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )?");
        System.err.println("  adt -appVersion       PLATFORM-OPTION PLATFORM-SDK-OPTION? ( -device <deviceID> )? -appid <app-id>");
        System.err.println("  adt -version");
        System.err.println();
        System.err.println("SIGNING_OPTIONS      : -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -alias <aliasName> )? ( -keypass <pass> )? ( -providerName <name> )? ( -tsa <url> )?");
        System.err.println("FILE_OPTIONS         : <fileOrDir>* ( ( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ) )*");
        System.err.println("CONNECT_OPTIONS      : -connect <host>?");
        System.err.println("ANE_OPTIONS          : -swc <swc> ( -platform <name> <fileOrDir>* ( -C <dir> <fileOrDir>+ )* )*");
        System.err.println("FILE-AND-PATH-OPTIONS: ( PATH-OPTION | FILE-OPTIONS ) FILE-AND-PATH-OPTIONS?");
        System.err.println("PATH-OPTION          : -extdir <dir>");
        System.err.println("PLATFORM-OPTION      : -platform android");
        System.err.println("PLATFORM-SDK-OPTION  : -platformsdk <platform-sdk-home-dir>");
    }

    protected void parseArgsAndGo() throws InvalidInputException, UsageError, GeneralSecurityException, IOException, SDKDamagedException {
        if (this.args.peek(ARG_PREPARE)) {
            this.parsePrepare();
            this.getPackager().createIntermediate();
        } else if (this.args.peek(ARG_SIGN)) {
            this.parseSign();
            this.getPackager().createPackage();
        } else if (this.args.peek(ARG_MIGRATE)) {
            this.parseMigrate();
        } else if (this.args.peek(ARG_CHECK_PASS)) {
            this.parseCheckPass();
        } else if (this.args.peek(ARG_CERT)) {
            this.m_creator = new CertificateCreator();
            this.parseCertificate();
            this.m_creator.create();
        } else if (!this.parsePlatformOperationArgs()) {
            super.parseArgsAndGo();
        }
    }

    protected void parsePackage() throws UsageError {
        this.m_target = Target.AIR;
        this.detectTarget();
        super.parsePackage();
    }

    private void detectTarget() throws UsageError {
        if (this.args.seek("-target")) {
            this.args.accept("-target");
            this.m_targetValue = this.args.accept();
            this.m_target = Target.getTargetFromArg(this.m_targetValue);
            if (this.m_target == null || this.m_target == Target.AIRI) {
                throw new UsageError("Unknown package target " + this.m_targetValue);
            }
            if (this.m_target == Target.APK) {
                this.getAppPackager().setPackageConfiguration(this.m_targetValue);
            }
        }
        this.args.reset();
    }

    private boolean parsePlatformOperationArgs() throws InvalidInputException, UsageError, ADTException, FileNotFoundException, IOException, SDKDamagedException {
        File fpkg;
        if (!this.args.peek()) {
            return false;
        }
        String operation = this.args.next();
        if (!(operation.equals(ARG_INSTALLAPP) || operation.equals(ARG_INSTALLRUNTIME) || operation.equals(ARG_UNINSTALLAPP) || operation.equals(ARG_UNINSTALLRUNTIME) || operation.equals(ARG_LAUNCHAPP) || operation.equals(ARG_APPVERSION) || operation.equals(ARG_RUNTIMEVERSION))) {
            return false;
        }
        operation = this.args.accept();
        String deviceID = null;
        String appid = null;
        String pkg = null;
        String platform = null;
        File sdk = null;
        while (this.args.peek()) {
            if (platform == null && this.args.peek(ARG_PLATFORM)) {
                this.args.accept(ARG_PLATFORM);
                platform = this.args.accept();
                continue;
            }
            if (deviceID == null && this.args.peek(ARG_DEVICE)) {
                this.args.accept(ARG_DEVICE);
                deviceID = this.args.accept();
                continue;
            }
            if (appid == null && this.args.peek(ARG_APPID)) {
                if (!(operation.equals(ARG_UNINSTALLAPP) || operation.equals(ARG_LAUNCHAPP) || operation.equals(ARG_APPVERSION))) {
                    throw new UsageError("Invalid Parameter: -appid");
                }
                this.args.accept(ARG_APPID);
                appid = this.args.accept();
                continue;
            }
            if (pkg == null && this.args.peek(ARG_PACKAGE)) {
                if (!operation.equals(ARG_INSTALLRUNTIME) && !operation.equals(ARG_INSTALLAPP)) {
                    throw new UsageError("Invalid Parameter: -package");
                }
                this.args.accept(ARG_PACKAGE);
                pkg = this.args.accept();
                continue;
            }
            if (sdk == null && this.args.peek("-platformsdk")) {
                this.args.accept("-platformsdk");
                sdk = new File(this.args.accept());
                continue;
            }
            throw new UsageError("Invalid argument: " + this.args.accept());
        }
        if (platform == null || !platform.equalsIgnoreCase("android")) {
            throw new UsageError("Unsupported / Missing <platform>");
        }
        if (appid == null && (operation.equals(ARG_UNINSTALLAPP) || operation.equals(ARG_LAUNCHAPP) || operation.equals(ARG_APPVERSION))) {
            throw new UsageError("<app-id> required");
        }
        AndroidDeviceOperations platOp = new AndroidDeviceOperations();
        platOp.setDeviceID(deviceID);
        platOp.setAndroidDeviceSDK(new AndroidDeviceSDK(sdk));
        File file = fpkg = pkg != null ? new File(pkg) : null;
        if (operation.equals(ARG_INSTALLAPP)) {
            platOp.installApplication(fpkg);
        } else if (operation.equals(ARG_UNINSTALLAPP)) {
            platOp.uninstallApplication(appid);
        } else if (operation.equals(ARG_LAUNCHAPP)) {
            platOp.launchApplication(appid);
        } else if (operation.equals(ARG_APPVERSION)) {
            System.out.println(platOp.getApplicationVersion(appid));
        } else if (operation.equals(ARG_INSTALLRUNTIME)) {
            platOp.installRuntime(fpkg);
        } else if (operation.equals(ARG_UNINSTALLRUNTIME)) {
            platOp.uninstallRuntime();
        } else if (operation.equals(ARG_RUNTIMEVERSION)) {
            System.out.println(platOp.getRuntimeVersion());
        }
        return true;
    }

    protected void parseInput() throws UsageError {
        if (this.m_target == Target.ANE) {
            this.parseANEInput();
        } else {
            super.parseInput();
        }
    }

    protected void parseANEInput() throws UsageError {
        try {
            boolean seenSWC = false;
            HashSet<String> platforms = new HashSet<String>();
            ANEPackager packager = this.getANEPackager();
            String extDescString = this.args.accept();
            File extDesc = new File(extDescString).getAbsoluteFile();
            if (!extDesc.exists()) {
                throw new UsageError("Invalid extension descriptor: " + extDescString);
            }
            packager.setExtensionDescriptor(extDesc);
            while (this.args.peek("-swc")) {
                if (seenSWC) {
                    throw new UsageError("-swc parameter can only appear once.");
                }
                seenSWC = true;
                this.args.accept("-swc");
                packager.setSWC(new File(this.args.accept()).getAbsoluteFile());
            }
            while (this.args.peek(ARG_PLATFORM)) {
                this.args.accept();
                String platform = this.args.accept();
                if (platforms.contains(platform)) {
                    throw new UsageError("Duplicate option '-platform " + platform + "'. Each platform should only appear once.");
                }
                platforms.add(platform);
                File rootDir = this.cwd;
                while (this.args.peek() && !this.args.peek(ARG_PLATFORM) && !this.args.peek("-swc")) {
                    if (this.args.peek("-C")) {
                        this.args.accept();
                        rootDir = new File(this.args.accept()).getAbsoluteFile();
                        if (rootDir.exists() && rootDir.isDirectory()) continue;
                        throw new UsageError("No such directory: " + rootDir.getAbsolutePath());
                    }
                    if (this.args.peek("-e")) {
                        this.args.accept();
                        packager.addExtensionFileWithPath(new File(this.args.accept()), platform, this.args.accept());
                        continue;
                    }
                    packager.addExtensionFileOrDir(new File(this.args.accept()), rootDir, platform);
                }
                if (!this.args.peek("-swc")) continue;
                if (seenSWC) {
                    throw new UsageError("-swc parameter can only appear once.");
                }
                seenSWC = true;
                this.args.accept("-swc");
                packager.setSWC(new File(this.args.accept()).getAbsoluteFile());
            }
        }
        catch (IllegalArgumentException e2) {
            throw new UsageError(e2.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseUndocumentedParam() throws UsageError {
        if (this.args.peek(ARG_NO_VALIDATE)) {
            this.args.accept(ARG_NO_VALIDATE);
            if (!this.m_target.isAIR() && this.m_target != Target.ANE) throw new UsageError("-Xnovalidate not supported for this target");
            this.getPackager().setValidate(false);
            return true;
        } else {
            if (!this.args.peek(ARG_RUNTIME)) return super.parseUndocumentedParam();
            this.args.accept(ARG_RUNTIME);
            this.getAppPackager().setRuntimeDir(new File(this.args.accept()));
        }
        return true;
    }

    protected void parseConnectOptions() throws UsageError {
        if (this.args.peek(ARG_CONNECT)) {
            if (!this.m_targetValue.equals("apk-debug")) {
                throw new UsageError(" Option -connect can be only used with -target apk-debug");
            }
            this.args.accept(ARG_CONNECT);
            String host = this.args.next();
            if (host.length() == 0 || host.charAt(0) == '-') {
                InetAddress localHost;
                try {
                    localHost = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e2) {
                    throw new UsageError("\n Unable to determine local host");
                }
                host = localHost.getCanonicalHostName();
            } else {
                this.args.accept();
            }
            this.getAppPackager().setDebugHost(host);
        }
    }

    protected void parseAppSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.m_signingApp = true;
        }
        if (this.m_target != Target.APK) {
            super.parseAppSigningOptions();
        } else if (this.m_signingApp) {
            throw new UsageError("Found misplaced signing options");
        }
    }

    protected void parseTarget() throws UsageError {
        if (this.args.peek("-target")) {
            this.args.accept("-target");
            this.args.accept();
        }
    }

    protected boolean cacheSigningOption(UCF.SigningOptions options) throws UsageError {
        if (this.m_target == Target.APK && this.args.peek("-tsa")) {
            throw new UsageError("-tsa option not supported");
        }
        return super.cacheSigningOption(options);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseNativeSigningOptions() throws UsageError {
        if (!this.signingOptionNext(this.args)) {
            if (this.m_target != Target.APK) return;
            throw new UsageError("Signing options required to package APK");
        }
        if (this.m_target == Target.EXE) {
            UCF.SigningOptions nativeSigningOptions = this.cacheSigningOptions();
            if (!new File(nativeSigningOptions.keyStoreFile).exists()) {
                throw new UsageError("Keystore file does not exist: " + nativeSigningOptions.keyStoreFile);
            }
            this.getNativePackager().setNativeSigningOptions(nativeSigningOptions);
            return;
        }
        if (this.m_target == Target.APK) {
            super.parseSigningOptions(this.getPackager());
            return;
        }
        if (this.m_target != Target.DMG) throw new UsageError("Found misplaced signing arguments");
        throw new UsageError("Native signing not supported on mac");
    }

    protected String getFileExtension() {
        return this.m_target.getFileExtension();
    }

    protected void parseDescriptorAndFileset(File appXml) throws UsageError {
        if (this.m_target != Target.APK && this.m_target != Target.AIRI && !this.m_signingApp) {
            throw new UsageError("Signing options required to package from descriptor and fileset");
        }
        super.parseDescriptorAndFileset(appXml);
    }

    protected void parseAIRFile(File airFile) throws UsageError {
        if (this.m_target == Target.AIR) {
            throw new UsageError("Found an AIR file as input. Expected an AIRI file or descriptor and some content");
        }
        if (this.m_target == Target.AIRI) {
            throw new UsageError("Found an AIR file as input. Cannot package an AIR file as AIRI");
        }
        if (this.m_signingApp) {
            throw new UsageError("Found signing arguments and an AIR file as input. AIR files are already signed");
        }
        if (this.m_debug) {
            throw new UsageError("-Xdebug not supported with an AIR file as input. Repackage your AIR file with -Xdebug and use that instead");
        }
        super.parseAIRFile(airFile);
    }

    protected void parseAIRIFile(File airiFile) throws UsageError {
        if (!this.m_signingApp && this.m_target != Target.APK) {
            throw new UsageError("An AIRI file was specified without signing arguments. AIRI files must be signed to be processed further");
        }
        super.parseAIRIFile(airiFile);
    }

    private void parsePrepare() throws UsageError {
        this.args.accept(ARG_PREPARE);
        this.m_target = this.args.next().endsWith(".ane") ? Target.ANE : Target.AIRI;
        this.parseUndocumentedParams();
        this.parseOutput(this.getPackager(), this.m_target.getFileExtension());
        this.parseInput();
    }

    private void parseSign() throws UsageError {
        File intermediateFile;
        this.m_target = Target.AIR;
        this.detectTarget();
        if (this.m_target != Target.AIR && this.m_target != Target.AIRN && this.m_target != Target.ANE) {
            throw new UsageError("Invalid target for -sign " + this.m_target.getFileExtension());
        }
        this.args.accept(ARG_SIGN);
        this.parseSigningOptions(this.getPackager());
        if (this.args.peek("-target")) {
            this.args.accept("-target");
            this.args.accept();
        }
        if (!(intermediateFile = new File(this.args.accept())).exists()) {
            throw new UsageError("no such file " + intermediateFile.getPath());
        }
        this.getPackager().setIntermediateFile(intermediateFile);
        this.parseOutput(this.getPackager(), this.m_target.getFileExtension());
    }

    private void parseMigrate() throws UsageError {
        this.args.accept(ARG_MIGRATE);
        AIRMigrationSigner signer = new AIRMigrationSigner();
        this.parseSigningOptions(signer);
        File input = new File(this.args.accept());
        if (!input.exists()) {
            throw new UsageError("no such file " + input.getPath());
        }
        signer.setInput(input);
        this.parseOutput(signer, FILE_EXT_AIR);
        try {
            signer.sign();
        }
        catch (CertificateExpiredException ex) {
            throw new UsageError("certificate has expired", 8);
        }
        catch (CertificateNotYetValidException ex) {
            throw new UsageError("certificate is not yet valid", 8);
        }
        catch (CertificateException ex) {
            throw new UsageError("not an X509 code-signing certificate", 8);
        }
        catch (GeneralSecurityException ex) {
            throw new UsageError(ex.getMessage(), 9);
        }
        catch (InvalidInputException ex) {
            throw new UsageError(ex.getMessage(), 12);
        }
        catch (IOException ex) {
            throw new UsageError(ex.getMessage(), 6);
        }
    }

    private void parseCheckPass() throws UsageError {
        this.args.accept(ARG_CHECK_PASS);
        this.parseSigningOptions(null);
        System.err.println("valid password");
    }

    private void parseCertificate() throws UsageError {
        String cn = null;
        String ou = null;
        String o2 = null;
        String c2 = null;
        String validityPeriod = null;
        this.args.accept(ARG_CERT);
        while (true) {
            if (this.args.peek("-cn")) {
                if (cn != null) {
                    throw new UsageError("-cn already specified");
                }
                this.args.accept("-cn");
                cn = this.args.accept();
                continue;
            }
            if (this.args.peek("-ou")) {
                if (ou != null) {
                    throw new UsageError("-ou already specified");
                }
                this.args.accept("-ou");
                ou = this.args.accept();
                continue;
            }
            if (this.args.peek("-o")) {
                if (o2 != null) {
                    throw new UsageError("-o already specified");
                }
                this.args.accept("-o");
                o2 = this.args.accept();
                continue;
            }
            if (this.args.peek("-c")) {
                if (c2 != null) {
                    throw new UsageError("-c already specified");
                }
                this.args.accept("-c");
                c2 = this.args.accept();
                continue;
            }
            if (!this.args.peek("-validityPeriod")) break;
            if (validityPeriod != null) {
                throw new UsageError("-validityPeriod already specified");
            }
            this.args.accept("-validityPeriod");
            validityPeriod = this.args.accept();
        }
        if (cn == null) {
            throw new UsageError("-cn is required");
        }
        String keyType = this.args.accept();
        try {
            this.m_creator.setKeyType(keyType);
        }
        catch (IllegalArgumentException e2) {
            throw new UsageError("key type not recognized: " + keyType + " -- valid types are 1024-RSA and 2048-RSA");
        }
        this.m_creator.setOutput(new File(this.args.accept()));
        this.m_creator.setPassword(this.args.accept());
        this.m_creator.setName(cn);
        if (ou != null) {
            this.m_creator.setOrganizationalUnit(ou);
        }
        if (o2 != null) {
            this.m_creator.setOrganizationName(o2);
        }
        try {
            if (validityPeriod != null) {
                this.m_creator.setValidity(validityPeriod);
            }
            if (c2 != null) {
                this.m_creator.setCountry(c2);
            }
        }
        catch (IllegalArgumentException e3) {
            throw new UsageError(e3.getMessage());
        }
    }

    private AIRPackager getAIRPackager() {
        return (AIRPackager)this.getPackager();
    }

    private ANEPackager getANEPackager() {
        return (ANEPackager)this.getPackager();
    }

    private NativePackager getNativePackager() {
        return (NativePackager)this.getPackager();
    }

    protected ADTPackager newPackager() {
        assert (this.m_target != null);
        return this.m_target.newPackager();
    }

    static class Target {
        public static final Target AIR = new Target("air", true);
        public static final Target AIRI = new Target("airi", true);
        public static final Target AIRN = new Target("airn", true);
        public static final Target EXE = new Target("exe", false);
        public static final Target DMG = new Target("dmg", false);
        public static final Target RPM = new Target("rpm", false);
        public static final Target DEB = new Target("deb", false);
        public static final Target APK = new Target("apk", false);
        public static final Target ANE = new Target("ane", false);
        private String m_fileExtension;
        private boolean m_isAIR;

        private static Target getLinuxTarget() {
            int dpkgStatus;
            int rpmStatus;
            try {
                Process rpmChecker = new ProcessBuilder(ADT.FILE_EXT_RPM, "-q", ADT.FILE_EXT_RPM).start();
                Utils.consumeOutput(rpmChecker);
                rpmStatus = rpmChecker.waitFor();
            }
            catch (IOException e2) {
                rpmStatus = 1;
            }
            catch (InterruptedException e3) {
                rpmStatus = 1;
            }
            try {
                Process dpkgChecker = new ProcessBuilder("dpkg", "-l", "dpkg").start();
                Utils.consumeOutput(dpkgChecker);
                dpkgStatus = dpkgChecker.waitFor();
            }
            catch (IOException e4) {
                dpkgStatus = 1;
            }
            catch (InterruptedException e5) {
                dpkgStatus = 1;
            }
            if (rpmStatus == 0) {
                return RPM;
            }
            if (dpkgStatus == 0) {
                return DEB;
            }
            return null;
        }

        public static Target getTargetFromArg(String arg) {
            if (ADT.FILE_EXT_AIR.equals(arg)) {
                return AIR;
            }
            if (ADT.FILE_EXT_AIRI.equals(arg)) {
                return AIRI;
            }
            if (ADT.FILE_EXT_AIRN.equals(arg)) {
                return AIRN;
            }
            if ("apk-debug".equals(arg) || ADT.FILE_EXT_APK.equals(arg) || "apk-emulator".equals(arg)) {
                return APK;
            }
            if (ADT.FILE_EXT_ANE.equals(arg)) {
                return ANE;
            }
            if (ADT.ARG_NATIVE.equals(arg)) {
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    return EXE;
                }
                if (System.getProperty("os.name").indexOf("Mac") != -1) {
                    return DMG;
                }
                if (System.getProperty("os.name").indexOf("Linux") != -1) {
                    return Target.getLinuxTarget();
                }
            }
            return null;
        }

        public String getFileExtension() {
            return "." + this.m_fileExtension;
        }

        public boolean isAIR() {
            return this.m_isAIR;
        }

        public ADTPackager newPackager() {
            if (this == AIR || this == AIRI) {
                return new AIRPackager();
            }
            if (this == AIRN) {
                return new AIRNPackager();
            }
            if (this == DMG) {
                return new DMGPackager();
            }
            if (this == EXE) {
                return new EXEPackager();
            }
            if (this == RPM) {
                return new RPMPackager();
            }
            if (this == DEB) {
                return new DEBPackager();
            }
            if (this == APK) {
                return new APKPackager();
            }
            if (this == ANE) {
                return new ANEPackager();
            }
            assert (false);
            return null;
        }

        private Target(String extension, boolean isAIR) {
            this.m_fileExtension = extension;
            this.m_isAIR = isAIR;
        }
    }
}

