/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRLexer;
import antlr.ANTLRParser;
import antlr.CodeGenerator;
import antlr.DefaultToolErrorHandler;
import antlr.FileCopyException;
import antlr.FileLineFormatter;
import antlr.LLkAnalyzer;
import antlr.MakeGrammar;
import antlr.NameSpace;
import antlr.PreservingFileWriter;
import antlr.RecognitionException;
import antlr.StringUtils;
import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.ToolErrorHandler;
import antlr.Utils;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;

public class Tool {
    public static String version = "";
    ToolErrorHandler errorHandler;
    protected boolean hasError = false;
    boolean genDiagnostics = false;
    boolean genDocBook = false;
    boolean genHTML = false;
    protected String outputDir = ".";
    protected String grammarFile;
    transient Reader f = new InputStreamReader(System.in);
    protected String literalsPrefix = "LITERAL_";
    protected boolean upperCaseMangledLiterals = false;
    protected NameSpace nameSpace = null;
    protected String namespaceAntlr = null;
    protected String namespaceStd = null;
    protected boolean genHashLines = true;
    protected boolean noConstructors = false;
    private BitSet cmdLineArgValid = new BitSet();

    public Tool() {
        this.errorHandler = new DefaultToolErrorHandler(this);
    }

    public String getGrammarFile() {
        return this.grammarFile;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public String getNamespaceStd() {
        return this.namespaceStd;
    }

    public String getNamespaceAntlr() {
        return this.namespaceAntlr;
    }

    public boolean getGenHashLines() {
        return this.genHashLines;
    }

    public String getLiteralsPrefix() {
        return this.literalsPrefix;
    }

    public boolean getUpperCaseMangledLiterals() {
        return this.upperCaseMangledLiterals;
    }

    public void setFileLineFormatter(FileLineFormatter fileLineFormatter) {
        FileLineFormatter.setFormatter(fileLineFormatter);
    }

    protected void checkForInvalidArguments(String[] stringArray, BitSet bitSet) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (bitSet.member(i2)) continue;
            this.warning("invalid command-line argument: " + stringArray[i2] + "; ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFile(String string, String string2) throws IOException {
        IOException iOException3;
        Writer writer;
        block17: {
            File file = new File(string);
            File file2 = new File(string2);
            Reader reader = null;
            writer = null;
            try {
                int n2;
                Object object;
                if (!file.exists() || !file.isFile()) {
                    throw new FileCopyException("FileCopy: no such source file: " + string);
                }
                if (!file.canRead()) {
                    throw new FileCopyException("FileCopy: source file is unreadable: " + string);
                }
                if (file2.exists()) {
                    if (!file2.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + string2);
                    object = new DataInputStream(System.in);
                    if (!file2.canWrite()) {
                        throw new FileCopyException("FileCopy: destination file is unwriteable: " + string2);
                    }
                } else {
                    object = this.parent(file2);
                    if (!((File)object).exists()) {
                        throw new FileCopyException("FileCopy: destination directory doesn't exist: " + string2);
                    }
                    if (!((File)object).canWrite()) {
                        throw new FileCopyException("FileCopy: destination directory is unwriteable: " + string2);
                    }
                }
                reader = new BufferedReader(new FileReader(file));
                writer = new BufferedWriter(new FileWriter(file2));
                char[] cArray = new char[1024];
                while ((n2 = reader.read(cArray, 0, 1024)) != -1) {
                    writer.write(cArray, 0, n2);
                }
                Object var12_10 = null;
                if (reader == null) break block17;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var12_11 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException iOException22) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException3) {}
    }

    public void doEverythingWrapper(String[] stringArray) {
        int n2 = this.doEverything(stringArray);
        System.exit(n2);
    }

    public int doEverything(String[] stringArray) {
        antlr.preprocessor.Tool tool = new antlr.preprocessor.Tool(this, stringArray);
        boolean bl2 = tool.preprocess();
        String[] stringArray2 = tool.preprocessedArgList();
        this.processArguments(stringArray2);
        if (!bl2) {
            return 1;
        }
        this.f = this.getGrammarReader();
        ANTLRLexer aNTLRLexer = new ANTLRLexer(this.f);
        TokenBuffer tokenBuffer = new TokenBuffer(aNTLRLexer);
        LLkAnalyzer lLkAnalyzer = new LLkAnalyzer(this);
        MakeGrammar makeGrammar = new MakeGrammar(this, stringArray, lLkAnalyzer);
        try {
            ANTLRParser aNTLRParser = new ANTLRParser(tokenBuffer, makeGrammar, this);
            aNTLRParser.setFilename(this.grammarFile);
            aNTLRParser.grammar();
            if (this.hasError()) {
                this.fatalError("Exiting due to errors.");
            }
            this.checkForInvalidArguments(stringArray2, this.cmdLineArgValid);
            String string = "antlr." + this.getLanguage(makeGrammar) + "CodeGenerator";
            try {
                CodeGenerator codeGenerator = (CodeGenerator)Utils.createInstanceOf(string);
                codeGenerator.setBehavior(makeGrammar);
                codeGenerator.setAnalyzer(lLkAnalyzer);
                codeGenerator.setTool(this);
                codeGenerator.gen();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.panic("Cannot instantiate code-generator: " + string);
            }
            catch (InstantiationException instantiationException) {
                this.panic("Cannot instantiate code-generator: " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.panic("Cannot instantiate code-generator: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.panic("code-generator class '" + string + "' is not accessible");
            }
        }
        catch (RecognitionException recognitionException) {
            this.fatalError("Unhandled parser error: " + recognitionException.getMessage());
        }
        catch (TokenStreamException tokenStreamException) {
            this.fatalError("TokenStreamException: " + tokenStreamException.getMessage());
        }
        return 0;
    }

    public void error(String string) {
        this.hasError = true;
        System.err.println("error: " + string);
    }

    public void error(String string, String string2, int n2, int n3) {
        this.hasError = true;
        System.err.println(FileLineFormatter.getFormatter().getFormatString(string2, n2, n3) + string);
    }

    public String fileMinusPath(String string) {
        String string2 = System.getProperty("file.separator");
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public String getLanguage(MakeGrammar makeGrammar) {
        if (this.genDiagnostics) {
            return "Diagnostic";
        }
        if (this.genHTML) {
            return "HTML";
        }
        if (this.genDocBook) {
            return "DocBook";
        }
        return makeGrammar.language;
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    private static void help() {
        System.err.println("usage: java antlr.Tool [args] file.g");
        System.err.println("  -o outputDir       specify output directory where all output generated.");
        System.err.println("  -glib superGrammar specify location of supergrammar file.");
        System.err.println("  -debug             launch the ParseView debugger upon parser invocation.");
        System.err.println("  -html              generate a html file from your grammar.");
        System.err.println("  -docbook           generate a docbook sgml file from your grammar.");
        System.err.println("  -diagnostic        generate a textfile with diagnostics.");
        System.err.println("  -trace             have all rules call traceIn/traceOut.");
        System.err.println("  -traceLexer        have lexer rules call traceIn/traceOut.");
        System.err.println("  -traceParser       have parser rules call traceIn/traceOut.");
        System.err.println("  -traceTreeParser   have tree parser rules call traceIn/traceOut.");
        System.err.println("  -h|-help|--help    this message");
    }

    public static void main(String[] stringArray) {
        System.err.println("ANTLR Parser Generator   Version 2.7.7 (20060906)   1989-2005");
        version = "2.7.7 (20060906)";
        try {
            boolean bl2 = false;
            if (stringArray.length == 0) {
                bl2 = true;
            } else {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!stringArray[i2].equals("-h") && !stringArray[i2].equals("-help") && !stringArray[i2].equals("--help")) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                Tool.help();
            } else {
                Tool tool = new Tool();
                tool.doEverything(stringArray);
                tool = null;
            }
        }
        catch (Exception exception) {
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator"));
            System.err.println("#$%%*&@# internal error: " + exception.toString());
            System.err.println("[complain to nearest government official");
            System.err.println(" or send hate-mail to parrt@antlr.org;");
            System.err.println(" please send stack trace with report.]" + System.getProperty("line.separator"));
            exception.printStackTrace();
        }
    }

    public PrintWriter openOutputFile(String string) throws IOException {
        File file;
        if (this.outputDir != "." && !(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        return new PrintWriter(new PreservingFileWriter(this.outputDir + System.getProperty("file.separator") + string));
    }

    public Reader getGrammarReader() {
        BufferedReader bufferedReader = null;
        try {
            if (this.grammarFile != null) {
                bufferedReader = new BufferedReader(new FileReader(this.grammarFile));
            }
        }
        catch (IOException iOException) {
            this.fatalError("cannot open grammar file " + this.grammarFile);
        }
        return bufferedReader;
    }

    public void reportException(Exception exception, String string) {
        System.err.println(string == null ? exception.getMessage() : string + ": " + exception.getMessage());
    }

    public void reportProgress(String string) {
        System.out.println(string);
    }

    public void fatalError(String string) {
        System.err.println(string);
        Utils.error(string);
    }

    public void panic() {
        this.fatalError("panic");
    }

    public void panic(String string) {
        this.fatalError("panic: " + string);
    }

    public File parent(File file) {
        String string = file.getParent();
        if (string == null) {
            if (file.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(string);
    }

    public static Vector parseSeparatedList(String string, char c2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c2));
        Vector vector = new Vector(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.appendElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String pathToFile(String string) {
        String string2 = System.getProperty("file.separator");
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1) {
            return "." + System.getProperty("file.separator");
        }
        return string.substring(0, n2 + 1);
    }

    protected void processArguments(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-diagnostic")) {
                this.genDiagnostics = true;
                this.genHTML = false;
                this.setArgOK(i2);
                continue;
            }
            if (stringArray[i2].equals("-o")) {
                this.setArgOK(i2);
                if (i2 + 1 >= stringArray.length) {
                    this.error("missing output directory with -o option; ignoring");
                    continue;
                }
                this.setOutputDirectory(stringArray[++i2]);
                this.setArgOK(i2);
                continue;
            }
            if (stringArray[i2].equals("-html")) {
                this.genHTML = true;
                this.genDiagnostics = false;
                this.setArgOK(i2);
                continue;
            }
            if (stringArray[i2].equals("-docbook")) {
                this.genDocBook = true;
                this.genDiagnostics = false;
                this.setArgOK(i2);
                continue;
            }
            if (stringArray[i2].charAt(0) == '-') continue;
            this.grammarFile = stringArray[i2];
            this.setArgOK(i2);
        }
    }

    public void setArgOK(int n2) {
        this.cmdLineArgValid.add(n2);
    }

    public void setOutputDirectory(String string) {
        this.outputDir = string;
    }

    public void toolError(String string) {
        System.err.println("error: " + string);
    }

    public void warning(String string) {
        System.err.println("warning: " + string);
    }

    public void warning(String string, String string2, int n2, int n3) {
        System.err.println(FileLineFormatter.getFormatter().getFormatString(string2, n2, n3) + "warning:" + string);
    }

    public void warning(String[] stringArray, String string, int n2, int n3) {
        if (stringArray == null || stringArray.length == 0) {
            this.panic("bad multi-line message to Tool.warning");
        }
        System.err.println(FileLineFormatter.getFormatter().getFormatString(string, n2, n3) + "warning:" + stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(string, n2, n3) + "    " + stringArray[i2]);
        }
    }

    public void setNameSpace(String string) {
        if (null == this.nameSpace) {
            this.nameSpace = new NameSpace(StringUtils.stripFrontBack(string, "\"", "\""));
        }
    }
}

