/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.BlockWithImpliedExitPath;
import antlr.CharFormatter;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.JavaCharFormatter;
import antlr.LLkGrammarAnalyzer;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.OneOrMoreBlock;
import antlr.RuleBlock;
import antlr.RuleEndElement;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.SynPredBlock;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;

public class LLkAnalyzer
implements LLkGrammarAnalyzer {
    public boolean DEBUG_ANALYZER = false;
    private AlternativeBlock currentBlock;
    protected Tool tool = null;
    protected Grammar grammar = null;
    protected boolean lexicalAnalysis = false;
    CharFormatter charFormatter = new JavaCharFormatter();

    public LLkAnalyzer(Tool tool) {
        this.tool = tool;
    }

    protected boolean altUsesWildcardDefault(Alternative alternative) {
        AlternativeElement alternativeElement = alternative.head;
        if (alternativeElement instanceof TreeElement && ((TreeElement)alternativeElement).root instanceof WildcardElement) {
            return true;
        }
        return alternativeElement instanceof WildcardElement && alternativeElement.next instanceof BlockEndElement;
    }

    public boolean deterministic(AlternativeBlock alternativeBlock) {
        int n2 = 1;
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministic(" + alternativeBlock + ")");
        }
        boolean bl2 = true;
        int n3 = alternativeBlock.alternatives.size();
        AlternativeBlock alternativeBlock2 = this.currentBlock;
        Object object = null;
        this.currentBlock = alternativeBlock;
        if (!(alternativeBlock.greedy || alternativeBlock instanceof OneOrMoreBlock || alternativeBlock instanceof ZeroOrMoreBlock)) {
            this.tool.warning("Being nongreedy only makes sense for (...)+ and (...)*", this.grammar.getFilename(), alternativeBlock.getLine(), alternativeBlock.getColumn());
        }
        if (n3 == 1) {
            AlternativeElement alternativeElement = alternativeBlock.getAlternativeAt((int)0).head;
            this.currentBlock.alti = 0;
            alternativeBlock.getAlternativeAt((int)0).cache[1] = alternativeElement.look(1);
            alternativeBlock.getAlternativeAt((int)0).lookaheadDepth = 1;
            this.currentBlock = alternativeBlock2;
            return true;
        }
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            this.currentBlock.alti = i2;
            this.currentBlock.analysisAlt = i2;
            this.currentBlock.altj = i2 + 1;
            for (int i3 = i2 + 1; i3 < n3; ++i3) {
                Object object2;
                Object object3;
                boolean bl3;
                this.currentBlock.altj = i3;
                if (this.DEBUG_ANALYZER) {
                    System.out.println("comparing " + i2 + " against alt " + i3);
                }
                this.currentBlock.analysisAlt = i3;
                n2 = 1;
                Lookahead[] lookaheadArray = new Lookahead[this.grammar.maxk + 1];
                do {
                    bl3 = false;
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("checking depth " + n2 + "<=" + this.grammar.maxk);
                    }
                    object3 = this.getAltLookahead(alternativeBlock, i2, n2);
                    object2 = this.getAltLookahead(alternativeBlock, i3, n2);
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("p is " + ((Lookahead)object3).toString(",", this.charFormatter, this.grammar));
                    }
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("q is " + ((Lookahead)object2).toString(",", this.charFormatter, this.grammar));
                    }
                    lookaheadArray[n2] = ((Lookahead)object3).intersection((Lookahead)object2);
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("intersection at depth " + n2 + " is " + lookaheadArray[n2].toString());
                    }
                    if (lookaheadArray[n2].nil()) continue;
                    bl3 = true;
                    ++n2;
                } while (bl3 && n2 <= this.grammar.maxk);
                object3 = alternativeBlock.getAlternativeAt(i2);
                object2 = alternativeBlock.getAlternativeAt(i3);
                if (bl3) {
                    bl2 = false;
                    ((Alternative)object3).lookaheadDepth = Integer.MAX_VALUE;
                    ((Alternative)object2).lookaheadDepth = Integer.MAX_VALUE;
                    if (((Alternative)object3).synPred != null) {
                        if (!this.DEBUG_ANALYZER) continue;
                        System.out.println("alt " + i2 + " has a syn pred");
                        continue;
                    }
                    if (((Alternative)object3).semPred != null) {
                        if (!this.DEBUG_ANALYZER) continue;
                        System.out.println("alt " + i2 + " has a sem pred");
                        continue;
                    }
                    if (this.altUsesWildcardDefault((Alternative)object2)) {
                        object = object2;
                        continue;
                    }
                    if (!alternativeBlock.warnWhenFollowAmbig && (((Alternative)object3).head instanceof BlockEndElement || ((Alternative)object2).head instanceof BlockEndElement) || !alternativeBlock.generateAmbigWarnings || alternativeBlock.greedySet && alternativeBlock.greedy && (((Alternative)object3).head instanceof BlockEndElement && !(((Alternative)object2).head instanceof BlockEndElement) || ((Alternative)object2).head instanceof BlockEndElement && !(((Alternative)object3).head instanceof BlockEndElement))) continue;
                    this.tool.errorHandler.warnAltAmbiguity(this.grammar, alternativeBlock, this.lexicalAnalysis, this.grammar.maxk, lookaheadArray, i2, i3);
                    continue;
                }
                ((Alternative)object3).lookaheadDepth = Math.max(((Alternative)object3).lookaheadDepth, n2);
                ((Alternative)object2).lookaheadDepth = Math.max(((Alternative)object2).lookaheadDepth, n2);
            }
        }
        this.currentBlock = alternativeBlock2;
        return bl2;
    }

    public boolean deterministic(OneOrMoreBlock oneOrMoreBlock) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministic(...)+(" + oneOrMoreBlock + ")");
        }
        AlternativeBlock alternativeBlock = this.currentBlock;
        this.currentBlock = oneOrMoreBlock;
        boolean bl2 = this.deterministic((AlternativeBlock)oneOrMoreBlock);
        boolean bl3 = this.deterministicImpliedPath(oneOrMoreBlock);
        this.currentBlock = alternativeBlock;
        return bl3 && bl2;
    }

    public boolean deterministic(ZeroOrMoreBlock zeroOrMoreBlock) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministic(...)*(" + zeroOrMoreBlock + ")");
        }
        AlternativeBlock alternativeBlock = this.currentBlock;
        this.currentBlock = zeroOrMoreBlock;
        boolean bl2 = this.deterministic((AlternativeBlock)zeroOrMoreBlock);
        boolean bl3 = this.deterministicImpliedPath(zeroOrMoreBlock);
        this.currentBlock = alternativeBlock;
        return bl3 && bl2;
    }

    public boolean deterministicImpliedPath(BlockWithImpliedExitPath blockWithImpliedExitPath) {
        boolean bl2 = true;
        Vector vector = blockWithImpliedExitPath.getAlternatives();
        int n2 = vector.size();
        this.currentBlock.altj = -1;
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministicImpliedPath");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            boolean bl3;
            Alternative alternative = blockWithImpliedExitPath.getAlternativeAt(i2);
            if (alternative.head instanceof BlockEndElement) {
                this.tool.warning("empty alternative makes no sense in (...)* or (...)+", this.grammar.getFilename(), blockWithImpliedExitPath.getLine(), blockWithImpliedExitPath.getColumn());
            }
            int n3 = 1;
            Lookahead[] lookaheadArray = new Lookahead[this.grammar.maxk + 1];
            do {
                Lookahead lookahead;
                bl3 = false;
                if (this.DEBUG_ANALYZER) {
                    System.out.println("checking depth " + n3 + "<=" + this.grammar.maxk);
                }
                blockWithImpliedExitPath.exitCache[n3] = lookahead = blockWithImpliedExitPath.next.look(n3);
                this.currentBlock.alti = i2;
                object = this.getAltLookahead(blockWithImpliedExitPath, i2, n3);
                if (this.DEBUG_ANALYZER) {
                    System.out.println("follow is " + lookahead.toString(",", this.charFormatter, this.grammar));
                }
                if (this.DEBUG_ANALYZER) {
                    System.out.println("p is " + ((Lookahead)object).toString(",", this.charFormatter, this.grammar));
                }
                lookaheadArray[n3] = lookahead.intersection((Lookahead)object);
                if (this.DEBUG_ANALYZER) {
                    System.out.println("intersection at depth " + n3 + " is " + lookaheadArray[n3]);
                }
                if (lookaheadArray[n3].nil()) continue;
                bl3 = true;
                ++n3;
            } while (bl3 && n3 <= this.grammar.maxk);
            if (bl3) {
                bl2 = false;
                alternative.lookaheadDepth = Integer.MAX_VALUE;
                blockWithImpliedExitPath.exitLookaheadDepth = Integer.MAX_VALUE;
                object = blockWithImpliedExitPath.getAlternativeAt(this.currentBlock.alti);
                if (!blockWithImpliedExitPath.warnWhenFollowAmbig || !blockWithImpliedExitPath.generateAmbigWarnings) continue;
                if (blockWithImpliedExitPath.greedy && blockWithImpliedExitPath.greedySet && !(((Alternative)object).head instanceof BlockEndElement)) {
                    if (!this.DEBUG_ANALYZER) continue;
                    System.out.println("greedy loop");
                    continue;
                }
                if (!blockWithImpliedExitPath.greedy && !(((Alternative)object).head instanceof BlockEndElement)) {
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("nongreedy loop");
                    }
                    if (LLkAnalyzer.lookaheadEquivForApproxAndFullAnalysis(blockWithImpliedExitPath.exitCache, this.grammar.maxk)) continue;
                    this.tool.warning(new String[]{"nongreedy block may exit incorrectly due", "\tto limitations of linear approximate lookahead (first k-1 sets", "\tin lookahead not singleton)."}, this.grammar.getFilename(), blockWithImpliedExitPath.getLine(), blockWithImpliedExitPath.getColumn());
                    continue;
                }
                this.tool.errorHandler.warnAltExitAmbiguity(this.grammar, blockWithImpliedExitPath, this.lexicalAnalysis, this.grammar.maxk, lookaheadArray, i2);
                continue;
            }
            alternative.lookaheadDepth = Math.max(alternative.lookaheadDepth, n3);
            blockWithImpliedExitPath.exitLookaheadDepth = Math.max(blockWithImpliedExitPath.exitLookaheadDepth, n3);
        }
        return bl2;
    }

    public Lookahead FOLLOW(int n2, RuleEndElement ruleEndElement) {
        RuleBlock ruleBlock = (RuleBlock)ruleEndElement.block;
        String string = this.lexicalAnalysis ? CodeGenerator.encodeLexerRuleName(ruleBlock.getRuleName()) : ruleBlock.getRuleName();
        if (this.DEBUG_ANALYZER) {
            System.out.println("FOLLOW(" + n2 + "," + string + ")");
        }
        if (ruleEndElement.lock[n2]) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("FOLLOW cycle to " + string);
            }
            return new Lookahead(string);
        }
        if (ruleEndElement.cache[n2] != null) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("cache entry FOLLOW(" + n2 + ") for " + string + ": " + ruleEndElement.cache[n2].toString(",", this.charFormatter, this.grammar));
            }
            if (ruleEndElement.cache[n2].cycle == null) {
                return (Lookahead)ruleEndElement.cache[n2].clone();
            }
            RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleEndElement.cache[n2].cycle);
            RuleEndElement ruleEndElement2 = ruleSymbol.getBlock().endNode;
            if (ruleEndElement2.cache[n2] == null) {
                return (Lookahead)ruleEndElement.cache[n2].clone();
            }
            if (this.DEBUG_ANALYZER) {
                System.out.println("combining FOLLOW(" + n2 + ") for " + string + ": from " + ruleEndElement.cache[n2].toString(",", this.charFormatter, this.grammar) + " with FOLLOW for " + ((RuleBlock)ruleEndElement2.block).getRuleName() + ": " + ruleEndElement2.cache[n2].toString(",", this.charFormatter, this.grammar));
            }
            if (ruleEndElement2.cache[n2].cycle == null) {
                ruleEndElement.cache[n2].combineWith(ruleEndElement2.cache[n2]);
                ruleEndElement.cache[n2].cycle = null;
            } else {
                Lookahead lookahead = this.FOLLOW(n2, ruleEndElement2);
                ruleEndElement.cache[n2].combineWith(lookahead);
                ruleEndElement.cache[n2].cycle = lookahead.cycle;
            }
            if (this.DEBUG_ANALYZER) {
                System.out.println("saving FOLLOW(" + n2 + ") for " + string + ": from " + ruleEndElement.cache[n2].toString(",", this.charFormatter, this.grammar));
            }
            return (Lookahead)ruleEndElement.cache[n2].clone();
        }
        ruleEndElement.lock[n2] = true;
        Lookahead lookahead = new Lookahead();
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string);
        for (int i2 = 0; i2 < ruleSymbol.numReferences(); ++i2) {
            RuleRefElement ruleRefElement = ruleSymbol.getReference(i2);
            if (this.DEBUG_ANALYZER) {
                System.out.println("next[" + string + "] is " + ruleRefElement.next.toString());
            }
            Lookahead lookahead2 = ruleRefElement.next.look(n2);
            if (this.DEBUG_ANALYZER) {
                System.out.println("FIRST of next[" + string + "] ptr is " + lookahead2.toString());
            }
            if (lookahead2.cycle != null && lookahead2.cycle.equals(string)) {
                lookahead2.cycle = null;
            }
            lookahead.combineWith(lookahead2);
            if (!this.DEBUG_ANALYZER) continue;
            System.out.println("combined FOLLOW[" + string + "] is " + lookahead.toString());
        }
        ruleEndElement.lock[n2] = false;
        if (lookahead.fset.nil() && lookahead.cycle == null) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                lookahead.fset.add(3);
            } else if (this.grammar instanceof LexerGrammar) {
                lookahead.setEpsilon();
            } else {
                lookahead.fset.add(1);
            }
        }
        if (this.DEBUG_ANALYZER) {
            System.out.println("saving FOLLOW(" + n2 + ") for " + string + ": " + lookahead.toString(",", this.charFormatter, this.grammar));
        }
        ruleEndElement.cache[n2] = (Lookahead)lookahead.clone();
        return lookahead;
    }

    private Lookahead getAltLookahead(AlternativeBlock alternativeBlock, int n2, int n3) {
        Lookahead lookahead;
        Alternative alternative = alternativeBlock.getAlternativeAt(n2);
        AlternativeElement alternativeElement = alternative.head;
        if (alternative.cache[n3] == null) {
            alternative.cache[n3] = lookahead = alternativeElement.look(n3);
        } else {
            lookahead = alternative.cache[n3];
        }
        return lookahead;
    }

    public Lookahead look(int n2, ActionElement actionElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookAction(" + n2 + "," + actionElement + ")");
        }
        return actionElement.next.look(n2);
    }

    public Lookahead look(int n2, AlternativeBlock alternativeBlock) {
        Object object;
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookAltBlk(" + n2 + "," + alternativeBlock + ")");
        }
        AlternativeBlock alternativeBlock2 = this.currentBlock;
        this.currentBlock = alternativeBlock;
        Lookahead lookahead = new Lookahead();
        for (int i2 = 0; i2 < alternativeBlock.alternatives.size(); ++i2) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("alt " + i2 + " of " + alternativeBlock);
            }
            this.currentBlock.analysisAlt = i2;
            object = alternativeBlock.getAlternativeAt(i2);
            AlternativeElement alternativeElement = ((Alternative)object).head;
            if (this.DEBUG_ANALYZER && ((Alternative)object).head == ((Alternative)object).tail) {
                System.out.println("alt " + i2 + " is empty");
            }
            Lookahead lookahead2 = alternativeElement.look(n2);
            lookahead.combineWith(lookahead2);
        }
        if (n2 == 1 && alternativeBlock.not && this.subruleCanBeInverted(alternativeBlock, this.lexicalAnalysis)) {
            if (this.lexicalAnalysis) {
                BitSet bitSet = (BitSet)((LexerGrammar)this.grammar).charVocabulary.clone();
                object = lookahead.fset.toArray();
                for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                    bitSet.remove((int)object[i3]);
                }
                lookahead.fset = bitSet;
            } else {
                lookahead.fset.notInPlace(4, this.grammar.tokenManager.maxTokenType());
            }
        }
        this.currentBlock = alternativeBlock2;
        return lookahead;
    }

    public Lookahead look(int n2, BlockEndElement blockEndElement) {
        Lookahead lookahead;
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookBlockEnd(" + n2 + ", " + blockEndElement.block + "); lock is " + blockEndElement.lock[n2]);
        }
        if (blockEndElement.lock[n2]) {
            return new Lookahead();
        }
        if (blockEndElement.block instanceof ZeroOrMoreBlock || blockEndElement.block instanceof OneOrMoreBlock) {
            blockEndElement.lock[n2] = true;
            lookahead = this.look(n2, blockEndElement.block);
            blockEndElement.lock[n2] = false;
        } else {
            lookahead = new Lookahead();
        }
        if (blockEndElement.block instanceof TreeElement) {
            lookahead.combineWith(Lookahead.of(3));
        } else if (blockEndElement.block instanceof SynPredBlock) {
            lookahead.setEpsilon();
        } else {
            Lookahead lookahead2 = blockEndElement.block.next.look(n2);
            lookahead.combineWith(lookahead2);
        }
        return lookahead;
    }

    public Lookahead look(int n2, CharLiteralElement charLiteralElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookCharLiteral(" + n2 + "," + charLiteralElement + ")");
        }
        if (n2 > 1) {
            return charLiteralElement.next.look(n2 - 1);
        }
        if (this.lexicalAnalysis) {
            if (charLiteralElement.not) {
                BitSet bitSet = (BitSet)((LexerGrammar)this.grammar).charVocabulary.clone();
                if (this.DEBUG_ANALYZER) {
                    System.out.println("charVocab is " + bitSet.toString());
                }
                this.removeCompetingPredictionSets(bitSet, charLiteralElement);
                if (this.DEBUG_ANALYZER) {
                    System.out.println("charVocab after removal of prior alt lookahead " + bitSet.toString());
                }
                bitSet.clear(charLiteralElement.getType());
                return new Lookahead(bitSet);
            }
            return Lookahead.of(charLiteralElement.getType());
        }
        this.tool.panic("Character literal reference found in parser");
        return Lookahead.of(charLiteralElement.getType());
    }

    public Lookahead look(int n2, CharRangeElement charRangeElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookCharRange(" + n2 + "," + charRangeElement + ")");
        }
        if (n2 > 1) {
            return charRangeElement.next.look(n2 - 1);
        }
        BitSet bitSet = BitSet.of(charRangeElement.begin);
        for (int i2 = charRangeElement.begin + '\u0001'; i2 <= charRangeElement.end; ++i2) {
            bitSet.add(i2);
        }
        return new Lookahead(bitSet);
    }

    public Lookahead look(int n2, GrammarAtom grammarAtom) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look(" + n2 + "," + grammarAtom + "[" + grammarAtom.getType() + "])");
        }
        if (this.lexicalAnalysis) {
            this.tool.panic("token reference found in lexer");
        }
        if (n2 > 1) {
            return grammarAtom.next.look(n2 - 1);
        }
        Lookahead lookahead = Lookahead.of(grammarAtom.getType());
        if (grammarAtom.not) {
            int n3 = this.grammar.tokenManager.maxTokenType();
            lookahead.fset.notInPlace(4, n3);
            this.removeCompetingPredictionSets(lookahead.fset, grammarAtom);
        }
        return lookahead;
    }

    public Lookahead look(int n2, OneOrMoreBlock oneOrMoreBlock) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look+" + n2 + "," + oneOrMoreBlock + ")");
        }
        Lookahead lookahead = this.look(n2, (AlternativeBlock)oneOrMoreBlock);
        return lookahead;
    }

    public Lookahead look(int n2, RuleBlock ruleBlock) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleBlk(" + n2 + "," + ruleBlock + ")");
        }
        Lookahead lookahead = this.look(n2, (AlternativeBlock)ruleBlock);
        return lookahead;
    }

    public Lookahead look(int n2, RuleEndElement ruleEndElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleBlockEnd(" + n2 + "); noFOLLOW=" + ruleEndElement.noFOLLOW + "; lock is " + ruleEndElement.lock[n2]);
        }
        if (ruleEndElement.noFOLLOW) {
            Lookahead lookahead = new Lookahead();
            lookahead.setEpsilon();
            lookahead.epsilonDepth = BitSet.of(n2);
            return lookahead;
        }
        Lookahead lookahead = this.FOLLOW(n2, ruleEndElement);
        return lookahead;
    }

    public Lookahead look(int n2, RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol;
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleRef(" + n2 + "," + ruleRefElement + ")");
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule)) == null || !ruleSymbol.defined) {
            this.tool.error("no definition of rule " + ruleRefElement.targetRule, this.grammar.getFilename(), ruleRefElement.getLine(), ruleRefElement.getColumn());
            return new Lookahead();
        }
        RuleBlock ruleBlock = ruleSymbol.getBlock();
        RuleEndElement ruleEndElement = ruleBlock.endNode;
        boolean bl2 = ruleEndElement.noFOLLOW;
        ruleEndElement.noFOLLOW = true;
        Lookahead lookahead = this.look(n2, ruleRefElement.targetRule);
        if (this.DEBUG_ANALYZER) {
            System.out.println("back from rule ref to " + ruleRefElement.targetRule);
        }
        ruleEndElement.noFOLLOW = bl2;
        if (lookahead.cycle != null) {
            this.tool.error("infinite recursion to rule " + lookahead.cycle + " from rule " + ruleRefElement.enclosingRuleName, this.grammar.getFilename(), ruleRefElement.getLine(), ruleRefElement.getColumn());
        }
        if (lookahead.containsEpsilon()) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("rule ref to " + ruleRefElement.targetRule + " has eps, depth: " + lookahead.epsilonDepth);
            }
            lookahead.resetEpsilon();
            int[] nArray = lookahead.epsilonDepth.toArray();
            lookahead.epsilonDepth = null;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n3 = n2 - (n2 - nArray[i2]);
                Lookahead lookahead2 = ruleRefElement.next.look(n3);
                lookahead.combineWith(lookahead2);
            }
        }
        return lookahead;
    }

    public Lookahead look(int n2, StringLiteralElement stringLiteralElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookStringLiteral(" + n2 + "," + stringLiteralElement + ")");
        }
        if (this.lexicalAnalysis) {
            if (n2 > stringLiteralElement.processedAtomText.length()) {
                return stringLiteralElement.next.look(n2 - stringLiteralElement.processedAtomText.length());
            }
            return Lookahead.of(stringLiteralElement.processedAtomText.charAt(n2 - 1));
        }
        if (n2 > 1) {
            return stringLiteralElement.next.look(n2 - 1);
        }
        Lookahead lookahead = Lookahead.of(stringLiteralElement.getType());
        if (stringLiteralElement.not) {
            int n3 = this.grammar.tokenManager.maxTokenType();
            lookahead.fset.notInPlace(4, n3);
        }
        return lookahead;
    }

    public Lookahead look(int n2, SynPredBlock synPredBlock) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look=>(" + n2 + "," + synPredBlock + ")");
        }
        return synPredBlock.next.look(n2);
    }

    public Lookahead look(int n2, TokenRangeElement tokenRangeElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookTokenRange(" + n2 + "," + tokenRangeElement + ")");
        }
        if (n2 > 1) {
            return tokenRangeElement.next.look(n2 - 1);
        }
        BitSet bitSet = BitSet.of(tokenRangeElement.begin);
        for (int i2 = tokenRangeElement.begin + 1; i2 <= tokenRangeElement.end; ++i2) {
            bitSet.add(i2);
        }
        return new Lookahead(bitSet);
    }

    public Lookahead look(int n2, TreeElement treeElement) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look(" + n2 + "," + treeElement.root + "[" + treeElement.root.getType() + "])");
        }
        if (n2 > 1) {
            return treeElement.next.look(n2 - 1);
        }
        Lookahead lookahead = null;
        if (treeElement.root instanceof WildcardElement) {
            lookahead = treeElement.root.look(1);
        } else {
            lookahead = Lookahead.of(treeElement.root.getType());
            if (treeElement.root.not) {
                int n3 = this.grammar.tokenManager.maxTokenType();
                lookahead.fset.notInPlace(4, n3);
            }
        }
        return lookahead;
    }

    public Lookahead look(int n2, WildcardElement wildcardElement) {
        BitSet bitSet;
        if (this.DEBUG_ANALYZER) {
            System.out.println("look(" + n2 + "," + wildcardElement + ")");
        }
        if (n2 > 1) {
            return wildcardElement.next.look(n2 - 1);
        }
        if (this.lexicalAnalysis) {
            bitSet = (BitSet)((LexerGrammar)this.grammar).charVocabulary.clone();
        } else {
            bitSet = new BitSet(1);
            int n3 = this.grammar.tokenManager.maxTokenType();
            bitSet.notInPlace(4, n3);
            if (this.DEBUG_ANALYZER) {
                System.out.println("look(" + n2 + "," + wildcardElement + ") after not: " + bitSet);
            }
        }
        return new Lookahead(bitSet);
    }

    public Lookahead look(int n2, ZeroOrMoreBlock zeroOrMoreBlock) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look*(" + n2 + "," + zeroOrMoreBlock + ")");
        }
        Lookahead lookahead = this.look(n2, (AlternativeBlock)zeroOrMoreBlock);
        Lookahead lookahead2 = zeroOrMoreBlock.next.look(n2);
        lookahead.combineWith(lookahead2);
        return lookahead;
    }

    public Lookahead look(int n2, String string) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleName(" + n2 + "," + string + ")");
        }
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string);
        RuleBlock ruleBlock = ruleSymbol.getBlock();
        if (ruleBlock.lock[n2]) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("infinite recursion to rule " + ruleBlock.getRuleName());
            }
            return new Lookahead(string);
        }
        if (ruleBlock.cache[n2] != null) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("found depth " + n2 + " result in FIRST " + string + " cache: " + ruleBlock.cache[n2].toString(",", this.charFormatter, this.grammar));
            }
            return (Lookahead)ruleBlock.cache[n2].clone();
        }
        ruleBlock.lock[n2] = true;
        Lookahead lookahead = this.look(n2, ruleBlock);
        ruleBlock.lock[n2] = false;
        ruleBlock.cache[n2] = (Lookahead)lookahead.clone();
        if (this.DEBUG_ANALYZER) {
            System.out.println("saving depth " + n2 + " result in FIRST " + string + " cache: " + ruleBlock.cache[n2].toString(",", this.charFormatter, this.grammar));
        }
        return lookahead;
    }

    public static boolean lookaheadEquivForApproxAndFullAnalysis(Lookahead[] lookaheadArray, int n2) {
        for (int i2 = 1; i2 <= n2 - 1; ++i2) {
            BitSet bitSet = lookaheadArray[i2].fset;
            if (bitSet.degree() <= 1) continue;
            return false;
        }
        return true;
    }

    private void removeCompetingPredictionSets(BitSet bitSet, AlternativeElement alternativeElement) {
        AlternativeElement alternativeElement2 = this.currentBlock.getAlternativeAt((int)this.currentBlock.analysisAlt).head;
        if (alternativeElement2 instanceof TreeElement ? ((TreeElement)alternativeElement2).root != alternativeElement : alternativeElement != alternativeElement2) {
            return;
        }
        for (int i2 = 0; i2 < this.currentBlock.analysisAlt; ++i2) {
            AlternativeElement alternativeElement3 = this.currentBlock.getAlternativeAt((int)i2).head;
            bitSet.subtractInPlace(alternativeElement3.look((int)1).fset);
        }
    }

    private void removeCompetingPredictionSetsFromWildcard(Lookahead[] lookaheadArray, AlternativeElement alternativeElement, int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            for (int i3 = 0; i3 < this.currentBlock.analysisAlt; ++i3) {
                AlternativeElement alternativeElement2 = this.currentBlock.getAlternativeAt((int)i3).head;
                lookaheadArray[i2].fset.subtractInPlace(alternativeElement2.look((int)i2).fset);
            }
        }
    }

    private void reset() {
        this.grammar = null;
        this.DEBUG_ANALYZER = false;
        this.currentBlock = null;
        this.lexicalAnalysis = false;
    }

    public void setGrammar(Grammar grammar) {
        if (this.grammar != null) {
            this.reset();
        }
        this.grammar = grammar;
        this.lexicalAnalysis = this.grammar instanceof LexerGrammar;
        this.DEBUG_ANALYZER = this.grammar.analyzerDebug;
    }

    public boolean subruleCanBeInverted(AlternativeBlock alternativeBlock, boolean bl2) {
        if (alternativeBlock instanceof ZeroOrMoreBlock || alternativeBlock instanceof OneOrMoreBlock || alternativeBlock instanceof SynPredBlock) {
            return false;
        }
        if (alternativeBlock.alternatives.size() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < alternativeBlock.alternatives.size(); ++i2) {
            Alternative alternative = alternativeBlock.getAlternativeAt(i2);
            if (alternative.synPred != null || alternative.semPred != null || alternative.exceptionSpec != null) {
                return false;
            }
            AlternativeElement alternativeElement = alternative.head;
            if ((alternativeElement instanceof CharLiteralElement || alternativeElement instanceof TokenRefElement || alternativeElement instanceof CharRangeElement || alternativeElement instanceof TokenRangeElement || alternativeElement instanceof StringLiteralElement && !bl2) && alternativeElement.next instanceof BlockEndElement && alternativeElement.getAutoGenType() == 1) continue;
            return false;
        }
        return true;
    }
}

