/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharQueue;
import antlr.CharStreamException;

public abstract class InputBuffer {
    protected int nMarkers = 0;
    protected int markerOffset = 0;
    protected int numToConsume = 0;
    protected CharQueue queue = new CharQueue(1);

    public void commit() {
        --this.nMarkers;
    }

    public void consume() {
        ++this.numToConsume;
    }

    public abstract void fill(int var1) throws CharStreamException;

    public String getLAChars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = this.markerOffset; i2 < this.queue.nbrEntries; ++i2) {
            stringBuffer.append(this.queue.elementAt(i2));
        }
        return stringBuffer.toString();
    }

    public String getMarkedChars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.markerOffset; ++i2) {
            stringBuffer.append(this.queue.elementAt(i2));
        }
        return stringBuffer.toString();
    }

    public boolean isMarked() {
        return this.nMarkers != 0;
    }

    public char LA(int n2) throws CharStreamException {
        this.fill(n2);
        return this.queue.elementAt(this.markerOffset + n2 - 1);
    }

    public int mark() {
        this.syncConsume();
        ++this.nMarkers;
        return this.markerOffset;
    }

    public void rewind(int n2) {
        this.syncConsume();
        this.markerOffset = n2;
        --this.nMarkers;
    }

    public void reset() {
        this.nMarkers = 0;
        this.markerOffset = 0;
        this.numToConsume = 0;
        this.queue.reset();
    }

    protected void syncConsume() {
        while (this.numToConsume > 0) {
            if (this.nMarkers > 0) {
                ++this.markerOffset;
            } else {
                this.queue.removeFirst();
            }
            --this.numToConsume;
        }
    }
}

