/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.services;

import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.AspectEngine;
import fiftyone.pipeline.engines.flowelements.CloudAspectEngine;
import fiftyone.pipeline.engines.services.MissingPropertyReason;
import fiftyone.pipeline.engines.services.MissingPropertyResult;
import fiftyone.pipeline.engines.services.MissingPropertyService;
import fiftyone.pipeline.util.StringManipulation;
import java.util.List;
import java.util.stream.Collectors;

public class MissingPropertyServiceDefault
implements MissingPropertyService {
    private static MissingPropertyServiceDefault missingPropertyService = null;
    private static final Object lock = new Object();

    private MissingPropertyServiceDefault() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MissingPropertyService getInstance() {
        if (missingPropertyService == null) {
            Object object = lock;
            synchronized (object) {
                if (missingPropertyService == null) {
                    missingPropertyService = new MissingPropertyServiceDefault();
                }
            }
        }
        return missingPropertyService;
    }

    public MissingPropertyResult getMissingPropertyReason(String propertyName, AspectEngine engine) {
        MissingPropertyReason reason = MissingPropertyReason.Unknown;
        AspectPropertyMetaData property = null;
        for (Object currentPropertyObject : engine.getProperties()) {
            AspectPropertyMetaData currentProperty = (AspectPropertyMetaData)currentPropertyObject;
            if (!currentProperty.getName().equalsIgnoreCase(propertyName)) continue;
            property = currentProperty;
            break;
        }
        if (property != null) {
            boolean containsDataTier = false;
            for (String tier : property.getDataTiersWherePresent()) {
                if (!tier.equals(engine.getDataSourceTier())) continue;
                containsDataTier = true;
                break;
            }
            if (!containsDataTier) {
                reason = MissingPropertyReason.DataFileUpgradeRequired;
            } else if (!property.isAvailable()) {
                reason = MissingPropertyReason.PropertyExcludedFromEngineConfiguration;
            }
        } else if (CloudAspectEngine.class.isAssignableFrom(engine.getClass())) {
            reason = engine.getProperties().size() == 0 ? MissingPropertyReason.ProductNotAccessibleWithResourceKey : MissingPropertyReason.PropertyNotAccessibleWithResourceKey;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("Property '%s' not found in data for element '%s'. ", propertyName, engine.getElementDataKey()));
        switch (reason) {
            case DataFileUpgradeRequired: {
                message.append(String.format("This is because your license and/or data file does not include this property. The property is available with the %s license/data for the %s", StringManipulation.stringJoin(property.getDataTiersWherePresent(), (String)","), engine.getClass().getSimpleName()));
                break;
            }
            case PropertyExcludedFromEngineConfiguration: {
                message.append("This is because the property has been excluded when configuring the engine.");
                break;
            }
            case ProductNotAccessibleWithResourceKey: {
                message.append(String.format("This is because your resource key does not include access to any properties under '%s'. For more details on resource keys, see our explainer: https://51degrees.com/documentation/_info__resource_keys.html", engine.getElementDataKey()));
                break;
            }
            case PropertyNotAccessibleWithResourceKey: {
                List available = engine.getProperties().stream().map(ElementPropertyMetaData::getName).collect(Collectors.toList());
                message.append(String.format("This is because your resource key does not include access to this property. Properties that are included for this key under '%s' are %s. For more details on resource keys, see our explainer: https://51degrees.com/documentation/_info__resource_keys.html", engine.getElementDataKey(), StringManipulation.stringJoin(available, (String)", ")));
                break;
            }
            case Unknown: {
                message.append("The reason for this is unknown. Please check that the aspect and property name are correct.");
                break;
            }
        }
        return new MissingPropertyResult(reason, message.toString());
    }

    @Override
    public MissingPropertyResult getMissingPropertyReason(String propertyName, List<AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>> engines) {
        MissingPropertyResult result = null;
        for (AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine : engines) {
            result = this.getMissingPropertyReason(propertyName, (AspectEngine)engine);
            if (result.getReason() == MissingPropertyReason.Unknown) continue;
            return result;
        }
        return result;
    }
}

