/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.services;

import fiftyone.pipeline.engines.services.HttpClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpClientDefault
implements HttpClient {
    @Override
    public HttpURLConnection connect(URL url) throws IOException {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        return (HttpURLConnection)url.openConnection();
    }

    @Override
    public String postData(HttpURLConnection connection, Map<String, String> headers, byte[] data) throws IOException {
        String current;
        connection.setRequestMethod("POST");
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                connection.setRequestProperty(e.getKey(), e.getValue());
            }
        }
        if (data == null) {
            connection.setDoOutput(false);
        } else {
            connection.setDoOutput(true);
            connection.getOutputStream().write(data);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getResponseCode() / 100 == 2 ? connection.getInputStream() : connection.getErrorStream()));
        StringBuilder builder = new StringBuilder();
        while ((current = reader.readLine()) != null) {
            builder.append(current);
        }
        String reply = builder.toString();
        return reply;
    }

    @Override
    public String getResponseString(HttpURLConnection connection) throws IOException {
        return this.getResponseString(connection, null);
    }

    @Override
    public String getResponseString(HttpURLConnection connection, Map<String, String> headers) throws IOException {
        String inputLine;
        connection.setRequestMethod("GET");
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                connection.setRequestProperty(e.getKey(), e.getValue());
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getResponseCode() / 100 == 2 ? connection.getInputStream() : connection.getErrorStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }
}

