/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.services;

import fiftyone.pipeline.engines.services.DataUploader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class DataUploaderHttp
implements DataUploader {
    private final String url;
    private final Map<String, String> headers;
    private final int timeout;
    HttpURLConnection connection;

    public DataUploaderHttp(String url, Map<String, String> headers, int timeout) {
        this.url = url;
        this.headers = headers;
        this.timeout = timeout;
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        this.connection = (HttpURLConnection)new URL(this.url.trim()).openConnection();
        this.connection.setConnectTimeout(this.timeout);
        this.connection.setRequestMethod("POST");
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            this.connection.setRequestProperty(header.getKey(), header.getValue());
        }
        this.connection.setDoOutput(true);
        return new GZIPOutputStream(this.connection.getOutputStream());
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }
}

