/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.services;

import fiftyone.common.wrappers.data.BinaryReader;
import fiftyone.common.wrappers.io.FileWrapper;
import fiftyone.common.wrappers.io.FileWrapperFactory;
import fiftyone.common.wrappers.io.FileWrapperFactoryDefault;
import fiftyone.common.wrappers.io.FileWrapperMemory;
import fiftyone.pipeline.engines.configuration.DataFileConfiguration;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectEngineDataFile;
import fiftyone.pipeline.engines.data.AspectEngineDataFileDefault;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import fiftyone.pipeline.engines.services.OnUpdateComplete;
import fiftyone.pipeline.engines.services.update.FutureFactory;
import fiftyone.pipeline.engines.services.update.FutureFactoryDefault;
import fiftyone.pipeline.util.Check;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataUpdateServiceDefault
implements DataUpdateService {
    final List<AspectEngineDataFile> configurations = new ArrayList<AspectEngineDataFile>();
    private final Logger logger;
    private final boolean closeFutureFactory;
    private final List<OnUpdateComplete> onUpdateCompleteList = new ArrayList<OnUpdateComplete>();
    private final Object configLock = new Object();
    private final HttpClient httpClient;
    private final Random random = new Random(new Date().getTime());
    private final FileWrapperFactory fileWrapperFactory;
    private final FutureFactory futureFactory;

    public DataUpdateServiceDefault() {
        this(null, null, null, null);
    }

    public DataUpdateServiceDefault(Logger logger, HttpClient httpClient) {
        this(logger, httpClient, null, null);
    }

    public DataUpdateServiceDefault(Logger logger, HttpClient httpClient, FileWrapperFactory fileWrapperFactory, FutureFactory futureFactory) {
        this.logger = Objects.nonNull(logger) ? logger : LoggerFactory.getLogger(this.getClass());
        this.fileWrapperFactory = fileWrapperFactory != null ? fileWrapperFactory : new FileWrapperFactoryDefault();
        this.httpClient = httpClient != null ? httpClient : new HttpClientDefault();
        if (futureFactory != null) {
            this.closeFutureFactory = false;
            this.futureFactory = futureFactory;
        } else {
            this.closeFutureFactory = true;
            this.futureFactory = new FutureFactoryDefault();
        }
    }

    @Override
    public void onUpdateComplete(OnUpdateComplete onUpdateComplete) {
        this.onUpdateCompleteList.add(onUpdateComplete);
    }

    @Override
    public DataUpdateService.AutoUpdateStatus checkForUpdate(OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine) {
        return this.checkForUpdate(engine.getDataFileMetaData(), true);
    }

    @Override
    public DataUpdateService.AutoUpdateStatus checkForUpdate(OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine, String identifier) {
        return this.checkForUpdate(engine.getDataFileMetaData(identifier), true);
    }

    private DataUpdateService.AutoUpdateStatus checkForUpdate(Object state, boolean manualUpdate) {
        DataUpdateService.AutoUpdateStatus result = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        final AspectEngineDataFileDefault dataFile = state instanceof AspectEngineDataFileDefault ? (AspectEngineDataFileDefault)state : null;
        boolean newDataAvailable = false;
        if (dataFile != null) {
            long tempFileModified;
            long fileModified;
            this.logger.debug("CheckForUpdate {}", (Object)dataFile.getDataFilePath());
            if (!(dataFile.getConfiguration().getFileSystemWatcherEnabled() || dataFile.getDataFilePath() == null || dataFile.getDataFilePath().isEmpty() || dataFile.getTempDataFilePath() == null || dataFile.getTempDataFilePath().isEmpty() || (fileModified = this.fileWrapperFactory.getLastModified(dataFile.getDataFilePath())) <= (tempFileModified = this.fileWrapperFactory.getLastModified(dataFile.getTempDataFilePath())))) {
                this.logger.debug("Specified file is newer than existing temp file");
                newDataAvailable = true;
            }
            if (!newDataAvailable && dataFile.getConfiguration().getDataUpdateUrl() != null && !dataFile.getConfiguration().getDataUpdateUrl().isEmpty()) {
                result = this.checkForUpdateFromUrl(dataFile);
                boolean bl = newDataAvailable = result == DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS || result == DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_SUCCESS;
            }
            if (newDataAvailable && result == DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                this.logger.debug("Calling updatedFileAvailable");
                result = this.updatedFileAvailable(dataFile);
            } else if (!manualUpdate) {
                this.logger.debug("Cancelling and resetting update timer");
                if (dataFile.getFuture() != null) {
                    dataFile.getFuture().cancel(true);
                    dataFile.setFuture(this.futureFactory.schedule(new Runnable(){

                        @Override
                        public void run() {
                            DataUpdateServiceDefault.this.checkForUpdate(dataFile, false);
                        }
                    }, this.getInterval(dataFile.getConfiguration())));
                }
            }
            if (!manualUpdate) {
                this.registerDataFile(dataFile);
            }
        }
        for (OnUpdateComplete onUpdateComplete : this.onUpdateCompleteList) {
            onUpdateComplete.call(state, new DataUpdateService.DataUpdateCompleteArgs(result, dataFile));
        }
        return result;
    }

    private DataUpdateService.AutoUpdateStatus updatedFileAvailable(AspectEngineDataFile dataFile) {
        AspectEngineDataFileDefault aspectDataFile = (AspectEngineDataFileDefault)dataFile;
        if (aspectDataFile.getFuture() != null) {
            aspectDataFile.getFuture().cancel(true);
            aspectDataFile.setFuture(null);
        }
        if (dataFile.getEngine() == null) {
            this.logger.debug("No engine to update so we are done");
            return DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_SUCCESS;
        }
        for (int tries = 0; tries < 10; ++tries) {
            try {
                dataFile.getEngine().refreshData(dataFile.getIdentifier());
                return DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_SUCCESS;
            }
            catch (Exception ex) {
                this.logger.warn("File Update: Error applying a data update to engine '{}'", (Object)dataFile.getEngine().getClass().getSimpleName(), (Object)ex);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_REFRESH_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataFileUpdated(Object sender) {
        DataUpdateService.AutoUpdateStatus status = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        AspectEngineDataFile dataFile = null;
        for (AspectEngineDataFile current : this.configurations) {
            if (!current.equals(sender)) continue;
            dataFile = current;
            break;
        }
        if (dataFile != null) {
            AspectEngineDataFileDefault aspectDataFile = (AspectEngineDataFileDefault)dataFile;
            long modifiedTime = this.fileWrapperFactory.getLastModified(dataFile.getDataFilePath());
            if (aspectDataFile.getLastUpdateFileCreateTime() < modifiedTime) {
                Object object = aspectDataFile.getUpdateSyncLock();
                synchronized (object) {
                    if (aspectDataFile.getLastUpdateFileCreateTime() < modifiedTime) {
                        aspectDataFile.setLastUpdateFileCreateTime(modifiedTime);
                        boolean fileLockable = false;
                        while (!fileLockable) {
                            try {
                                BinaryReader reader = this.fileWrapperFactory.build(aspectDataFile.getDataFilePath()).getReader();
                                Throwable throwable = null;
                                try {
                                    fileLockable = true;
                                    status = this.updatedFileAvailable(dataFile);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (reader == null) continue;
                                    if (throwable != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    reader.close();
                                }
                            }
                            catch (IOException e) {
                                this.logger.warn("Exception while reading the data file at '{}'", (Object)aspectDataFile.getDataFilePath(), (Object)e);
                            }
                        }
                    }
                }
            }
        }
        for (OnUpdateComplete onUpdateComplete : this.onUpdateCompleteList) {
            onUpdateComplete.call(sender, new DataUpdateService.DataUpdateCompleteArgs(status, dataFile));
        }
    }

    @Override
    public DataUpdateService.AutoUpdateStatus updateFromMemory(AspectEngineDataFile dataFile, byte[] data) {
        DataUpdateService.AutoUpdateStatus result;
        if (dataFile.getDataFilePath() != null && !dataFile.getDataFilePath().isEmpty()) {
            try {
                this.fileWrapperFactory.build(dataFile.getDataFilePath()).getWriter().writeBytes(data);
            }
            catch (Exception ex) {
                this.logger.error("An error occurred when writing to '" + dataFile.getDataFilePath() + "'. The engine will be updated to use the new data but the file on disk will still contain old data.", (Throwable)ex);
            }
        }
        try {
            dataFile.getEngine().refreshData(dataFile.getIdentifier(), data);
            result = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_SUCCESS;
        }
        catch (Exception ex) {
            this.logger.error("An error occurred when applying a data update to engine '" + dataFile.getEngine().getClass().getSimpleName() + "'.", (Throwable)ex);
            result = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_REFRESH_FAILED;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDataFile(AspectEngineDataFile dataFile) {
        this.logger.debug("Entering registerDataFile");
        if (dataFile == null) {
            throw new IllegalArgumentException("updateConfig");
        }
        boolean alreadyRegistered = dataFile.getIsRegistered();
        dataFile.setDataUpdateService(this);
        if (dataFile.getConfiguration().getUpdateOnStartup() && BooleanUtils.isFalse((Boolean)alreadyRegistered)) {
            this.logger.debug("Checking for Update on Startup {}", (Object)dataFile.getDataFilePath());
            DataUpdateService.AutoUpdateStatus status = this.checkForUpdate(dataFile, false);
            if (ObjectUtils.notEqual((Object)((Object)status), (Object)((Object)DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_SUCCESS)) && Check.notFileExists((String)dataFile.getDataFilePath())) {
                throw new IllegalStateException("Update on start up failed and there is no existing data file. Status was " + (Object)((Object)status));
            }
        } else {
            final AspectEngineDataFileDefault aspectDataFile = (AspectEngineDataFileDefault)dataFile;
            if (aspectDataFile.getAutomaticUpdatesEnabled() && aspectDataFile.getFuture() == null) {
                long delay = this.getInterval(aspectDataFile.getConfiguration());
                if (aspectDataFile.getUpdateAvailableTime() != null && aspectDataFile.getUpdateAvailableTime().getTime() > System.currentTimeMillis()) {
                    delay = this.applyIntervalRandomisation(aspectDataFile.getUpdateAvailableTime().getTime() - System.currentTimeMillis(), aspectDataFile.getConfiguration());
                }
                this.logger.debug("Scheduling update check with delay {}", (Object)delay);
                try {
                    ScheduledFuture<?> future = this.futureFactory.schedule(new Runnable(){

                        @Override
                        public void run() {
                            DataUpdateServiceDefault.this.logger.debug("running checkForUpdate {}", (Object)aspectDataFile.getDataFilePath());
                            DataUpdateServiceDefault.this.checkForUpdate(aspectDataFile, false);
                            DataUpdateServiceDefault.this.logger.debug("Returning from checkForUpdate");
                        }
                    }, delay);
                    this.logger.debug("Update check scheduled for {} millis", (Object)future.getDelay(TimeUnit.MILLISECONDS));
                    aspectDataFile.setFuture(future);
                }
                catch (Throwable t) {
                    this.logger.error("Exception when scheduling update check", t);
                }
            }
            if (aspectDataFile.getConfiguration().getFileSystemWatcherEnabled() && aspectDataFile.getConfiguration().getWatchKey() == null && aspectDataFile.getDataFilePath() != null && !aspectDataFile.getDataFilePath().isEmpty()) {
                this.logger.debug("Initialising watch service");
                final Path aspectDataFilePath = Paths.get(aspectDataFile.getDataFilePath(), new String[0]).toAbsolutePath();
                try {
                    if (Check.notFileExists((String)aspectDataFilePath.getParent().toString())) {
                        this.logger.error("Parent directory {} for {} does not exist", (Object)aspectDataFilePath.getParent(), (Object)aspectDataFile.getDataFilePath());
                        throw new IllegalStateException("Cannot find directory to watch");
                    }
                    this.logger.debug("Getting a watcher using {}", (Object)aspectDataFilePath);
                    WatchService watcher = aspectDataFilePath.getFileSystem().newWatchService();
                    this.logger.debug("Setting a watcher for {}", (Object)aspectDataFilePath.getParent());
                    aspectDataFile.getConfiguration().setWatchKey(aspectDataFilePath.getParent().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY));
                }
                catch (Exception e) {
                    this.logger.error("File watcher for '{}' could not be initialised.", (Object)aspectDataFile.getDataFilePath(), (Object)e);
                }
                try {
                    long pollingInterval = (long)aspectDataFile.getConfiguration().getPollingIntervalSeconds() * 1000L;
                    this.logger.debug("Setting poll future {} millis", (Object)pollingInterval);
                    aspectDataFile.setPollFuture(this.futureFactory.scheduleRepeating(new Runnable(){

                        @Override
                        public void run() {
                            DataUpdateServiceDefault.this.logger.debug("Watcher is running");
                            for (WatchEvent<?> event : aspectDataFile.getConfiguration().getWatchKey().pollEvents()) {
                                if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !((Path)event.context()).endsWith(aspectDataFilePath.getFileName())) continue;
                                DataUpdateServiceDefault.this.dataFileUpdated(aspectDataFile);
                            }
                            aspectDataFile.getConfiguration().getWatchKey().reset();
                        }
                    }, pollingInterval));
                    this.logger.debug("Poll check scheduled for {} mins", (Object)aspectDataFile.getPollFuture().getDelay(TimeUnit.MINUTES));
                }
                catch (Exception e) {
                    this.logger.error("Could not schedule watcher for {}.", (Object)aspectDataFile.getDataFilePath(), (Object)e);
                }
            }
            Object object = this.configLock;
            synchronized (object) {
                if (!this.configurations.contains(aspectDataFile)) {
                    this.configurations.add(aspectDataFile);
                }
            }
        }
        this.logger.debug("Returning from registerDataFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDataFile(AspectEngineDataFile dataFile) {
        Object object = this.configLock;
        synchronized (object) {
            Iterator<AspectEngineDataFile> iterator = this.configurations.iterator();
            while (iterator.hasNext()) {
                AspectEngineDataFileDefault aspectDataFile;
                AspectEngineDataFile config = iterator.next();
                if (config == dataFile) {
                    iterator.remove();
                }
                if ((aspectDataFile = (AspectEngineDataFileDefault)dataFile).getConfiguration().getWatchKey() != null) {
                    if (aspectDataFile.getPollFuture() != null) {
                        aspectDataFile.getPollFuture().cancel(true);
                        aspectDataFile.setPollFuture(null);
                    }
                    aspectDataFile.getConfiguration().getWatchKey().cancel();
                    aspectDataFile.getConfiguration().setWatchKey(null);
                }
                if (aspectDataFile.getFuture() == null) continue;
                aspectDataFile.getFuture().cancel(true);
                aspectDataFile.setFuture(null);
            }
        }
    }

    private long getInterval(DataFileConfiguration config) {
        int seconds = 0;
        if (config.getPollingIntervalSeconds() > 0) {
            seconds = config.getPollingIntervalSeconds();
        }
        return this.applyIntervalRandomisation(seconds, config) * 1000L;
    }

    private long applyIntervalRandomisation(long interval, DataFileConfiguration config) {
        long seconds = 0L;
        if (config.getMaxRandomisationSeconds() > 0) {
            seconds = this.random.nextInt(config.getMaxRandomisationSeconds());
        }
        return interval + seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataUpdateService.AutoUpdateStatus downloadFile(AspectEngineDataFile dataFile, FileWrapper tempFile) {
        String url = dataFile.getFormattedUrl();
        this.logger.debug("downloadFile from {}", (Object)url);
        try {
            HttpURLConnection connection = this.httpClient.connect(new URL(url.trim()));
            if (connection == null) {
                this.logger.error("No response from data update service at '{}' for engine '{}'", (Object)dataFile.getFormattedUrl(), (Object)(Objects.nonNull(dataFile.getEngine()) ? dataFile.getEngine().getClass().getSimpleName() : "No Engine"));
                return DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_HTTPS_ERR;
            }
            try {
                if (dataFile.getConfiguration().getVerifyModifiedSince()) {
                    long ifModifiedSince = dataFile.getDataPublishedDateTime().getTime();
                    connection.setIfModifiedSince(ifModifiedSince);
                }
                connection.setInstanceFollowRedirects(true);
                switch (connection.getResponseCode()) {
                    case 200: {
                        this.logger.debug("HTTP Status is OK");
                        FilterInputStream is = new BufferedInputStream(connection.getInputStream());
                        MessageDigest md = null;
                        if (dataFile.getConfiguration().getVerifyMd5()) {
                            try {
                                md = MessageDigest.getInstance("MD5");
                                if (Objects.isNull(md)) {
                                    DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_ERR_MD5_VALIDATION_FAILED;
                                    return autoUpdateStatus;
                                }
                            }
                            catch (NoSuchAlgorithmException e) {
                                this.logger.error("MD5 Algorithm not found");
                                DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_ERR_MD5_VALIDATION_FAILED;
                                return autoUpdateStatus;
                            }
                            is = new DigestInputStream(is, md);
                        }
                        if (dataFile.getConfiguration().getDecompressContent()) {
                            is = new GZIPInputStream(is);
                        }
                        if (Objects.nonNull(tempFile.getPath())) {
                            this.logger.debug("Copying download stream");
                            Files.copy(is, Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            this.logger.debug("Copied downloaded stream");
                        } else {
                            byte[] buffer = new byte[1024];
                            int len = ((InputStream)is).read(buffer);
                            while (len != -1) {
                                tempFile.getWriter().writeBytes(buffer, len);
                                len = ((InputStream)is).read(buffer);
                            }
                        }
                        if (dataFile.getConfiguration().getVerifyMd5()) {
                            String md5Header = connection.getHeaderField("Content-MD5");
                            assert (md != null);
                            String md5Hex = DatatypeConverter.printHexBinary((byte[])md.digest());
                            if (!md5Header.equalsIgnoreCase(md5Hex)) {
                                DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_ERR_MD5_VALIDATION_FAILED;
                                return autoUpdateStatus;
                            }
                        }
                        DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
                        return autoUpdateStatus;
                    }
                    case 429: {
                        this.logger.error("Too many requests to '{}' for {}", (Object)dataFile.getFormattedUrl(), (Object)this.getIdForLogging(dataFile));
                        DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_ERR_429_TOO_MANY_ATTEMPTS;
                        return autoUpdateStatus;
                    }
                    case 304: {
                        this.logger.debug("No data update available from '{}' for {}", (Object)dataFile.getFormattedUrl(), (Object)this.getIdForLogging(dataFile));
                        DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_NOT_NEEDED;
                        return autoUpdateStatus;
                    }
                    case 403: {
                        this.logger.error("Access denied to data update service at '{}' for {}", (Object)dataFile.getFormattedUrl(), (Object)this.getIdForLogging(dataFile));
                        DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_ERR_403_FORBIDDEN;
                        return autoUpdateStatus;
                    }
                }
                this.logger.error("HTTP status code '{}' from data update service at '{}' for {}", new Object[]{connection.getResponseCode(), dataFile.getFormattedUrl(), this.getIdForLogging(dataFile)});
                DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_HTTPS_ERR;
                return autoUpdateStatus;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error("Error while processing data file download", (Throwable)e);
            return DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_HTTPS_ERR;
        }
    }

    @Override
    public void close() {
        if (this.closeFutureFactory) {
            try {
                this.futureFactory.close();
            }
            catch (IOException e) {
                this.logger.error("Error closing future factory.", (Throwable)e);
            }
        }
    }

    private String getIdForLogging(AspectEngineDataFile dataFile) {
        return dataFile.getEngine() == null ? "data file '" + dataFile.getIdentifier() + "'" : "engine '" + dataFile.getEngine().getClass().getSimpleName() + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataUpdateService.AutoUpdateStatus checkForUpdateFromUrl(AspectEngineDataFile dataFile) {
        if (dataFile.getDataFilePath() == null || dataFile.getDataFilePath().isEmpty()) {
            try {
                FileWrapperMemory uncompressedData = new FileWrapperMemory();
                DataUpdateService.AutoUpdateStatus memoryDownloadResult = this.downloadFile(dataFile, (FileWrapper)uncompressedData);
                if (memoryDownloadResult != DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                    return memoryDownloadResult;
                }
                try (BinaryReader reader = uncompressedData.getReader();){
                    if (dataFile.getEngine() != null) {
                        dataFile.getEngine().refreshData(dataFile.getIdentifier(), reader.toByteArray());
                    } else {
                        dataFile.getConfiguration().setData(reader.toByteArray());
                    }
                }
                return memoryDownloadResult;
            }
            catch (Exception ex) {
                this.logger.error("An error occurred when applying a data update to engine '{}'", (Object)(Objects.nonNull(dataFile.getEngine()) ? dataFile.getEngine().getClass().getName() : "no engine"), (Object)ex);
                return DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_REFRESH_FAILED;
            }
        }
        Path uncompressedTempFile = Paths.get(dataFile.getTempDataDirPath(), dataFile.getIdentifier() + "-" + UUID.randomUUID() + ".tmp");
        FileWrapper uncompressedData = this.fileWrapperFactory.build(uncompressedTempFile.toString());
        try {
            DataUpdateService.AutoUpdateStatus result = this.downloadFile(dataFile, uncompressedData);
            if (result == DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                WatchKey watchKey = dataFile.getConfiguration().getWatchKey();
                if (dataFile.getConfiguration().getWatchKey() != null) {
                    watchKey.cancel();
                    dataFile.getConfiguration().setWatchKey(null);
                }
                try {
                    this.logger.debug("Moving {} to {}", (Object)uncompressedTempFile.toFile().getAbsolutePath(), (Object)dataFile.getDataFilePath());
                    Files.copy(Paths.get(uncompressedTempFile.toFile().getAbsolutePath(), new String[0]), Paths.get(dataFile.getDataFilePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    File f = Paths.get(dataFile.getDataFilePath(), new String[0]).toFile();
                    try (DataInputStream d = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));){
                        this.logger.debug("Reading file {}", (Object)d.read());
                    }
                }
                catch (Exception ex) {
                    this.logger.error("An error occurred when moving a data file to replace the existing one at {} for engine '{}'.", new Object[]{dataFile.getDataFilePath(), Objects.nonNull(dataFile.getEngine()) ? dataFile.getEngine().getClass().getSimpleName() : "No engine defined", ex});
                    result = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_NEW_FILE_CANT_RENAME;
                }
                if (watchKey != null) {
                    Path filePath = Paths.get(dataFile.getDataFilePath(), new String[0]).toAbsolutePath();
                    WatchService watcher = filePath.getFileSystem().newWatchService();
                    watchKey = filePath.getParent().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                    dataFile.getConfiguration().setWatchKey(watchKey);
                }
            }
            DataUpdateService.AutoUpdateStatus autoUpdateStatus = result;
            return autoUpdateStatus;
        }
        catch (Throwable e) {
            this.logger.error("Exception thrown", e);
            DataUpdateService.AutoUpdateStatus autoUpdateStatus = DataUpdateService.AutoUpdateStatus.AUTO_UPDATE_REFRESH_FAILED;
            return autoUpdateStatus;
        }
        finally {
            try {
                this.logger.debug("Deleting temp file {}", (Object)uncompressedTempFile);
                if (Files.exists(uncompressedTempFile, new LinkOption[0])) {
                    Files.delete(uncompressedTempFile);
                }
            }
            catch (IOException e) {
                this.logger.warn("Could not delete temporary download file file");
            }
        }
    }
}

