/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.services;

import fiftyone.pipeline.core.services.PipelineService;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectEngineDataFile;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import fiftyone.pipeline.engines.services.OnUpdateComplete;
import java.io.Closeable;

public interface DataUpdateService
extends Closeable,
PipelineService {
    public AutoUpdateStatus checkForUpdate(OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> var1, String var2);

    public AutoUpdateStatus checkForUpdate(OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> var1);

    public AutoUpdateStatus updateFromMemory(AspectEngineDataFile var1, byte[] var2);

    public void onUpdateComplete(OnUpdateComplete var1);

    public void registerDataFile(AspectEngineDataFile var1);

    public void unregisterDataFile(AspectEngineDataFile var1);

    public static class DataUpdateCompleteArgs {
        private AspectEngineDataFile dataFile;
        private AutoUpdateStatus status;

        public DataUpdateCompleteArgs(AutoUpdateStatus status, AspectEngineDataFile dataFile) {
            this.status = status;
            this.dataFile = dataFile;
        }

        public AutoUpdateStatus getStatus() {
            return this.status;
        }

        public AspectEngineDataFile getDataFile() {
            return this.dataFile;
        }
    }

    public static enum AutoUpdateStatus {
        AUTO_UPDATE_SUCCESS,
        AUTO_UPDATE_HTTPS_ERR,
        AUTO_UPDATE_NOT_NEEDED,
        AUTO_UPDATE_IN_PROGRESS,
        AUTO_UPDATE_MASTER_FILE_CANT_RENAME,
        AUTO_UPDATE_ERR_429_TOO_MANY_ATTEMPTS,
        AUTO_UPDATE_ERR_403_FORBIDDEN,
        AUTO_UPDATE_ERR_READING_STREAM,
        AUTO_UPDATE_ERR_MD5_VALIDATION_FAILED,
        AUTO_UPDATE_NEW_FILE_CANT_RENAME,
        AUTO_UPDATE_REFRESH_FAILED;

    }
}

