/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.flowelements;

import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.configuration.DataFileConfiguration;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectEngineDataFile;
import fiftyone.pipeline.engines.data.AspectEngineDataFileDefault;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.AspectEngineBuilderBase;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import fiftyone.pipeline.engines.services.DataUpdateService;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnPremiseAspectEngineBuilderBase<TBuilder extends OnPremiseAspectEngineBuilderBase<TBuilder, TEngine>, TEngine extends OnPremiseAspectEngine>
extends AspectEngineBuilderBase<TBuilder, TEngine> {
    private final DataUpdateService dataUpdateService;
    protected final List<DataFileConfiguration> dataFileConfigs = new ArrayList<DataFileConfiguration>();
    protected final List<AspectEngineDataFile> dataFiles = new ArrayList<AspectEngineDataFile>();
    protected String tempDir;
    protected Logger logger = LoggerFactory.getLogger(OnPremiseAspectEngineBuilderBase.class);

    public OnPremiseAspectEngineBuilderBase() {
        this(null);
    }

    public OnPremiseAspectEngineBuilderBase(ILoggerFactory loggerFactory) {
        this(loggerFactory, null);
    }

    public OnPremiseAspectEngineBuilderBase(ILoggerFactory loggerFactory, DataUpdateService dataUpdateService) {
        super(loggerFactory);
        this.dataUpdateService = dataUpdateService;
        this.createAndVerifyTempDir(Paths.get(System.getProperty("java.io.tmpdir"), "fiftyone.tempfiles"));
    }

    public void createAndVerifyTempDir(Path pathToCreate) {
        try {
            File directory = pathToCreate.toFile();
            if (BooleanUtils.isFalse((Boolean)directory.exists())) {
                directory = Files.createDirectories(pathToCreate, new FileAttribute[0]).toFile();
                boolean success = directory.setReadable(true, false);
                success = success && directory.setWritable(true, false);
                this.logger.debug("Temp dir is {} can write {}", (Object)this.tempDir, (Object)directory.canWrite());
                this.logger.debug("File permission setting reported {}.", (Object)success);
            } else if (BooleanUtils.isFalse((Boolean)directory.isDirectory())) {
                throw new IllegalStateException("Temporary directory path exists and is not a directory: " + pathToCreate);
            }
            this.tempDir = directory.getAbsolutePath();
            FileSystem fs = Paths.get(directory.getPath(), new String[0]).getFileSystem();
            fs.provider().checkAccess(pathToCreate, AccessMode.WRITE, AccessMode.READ);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot access Temp Directory '" + pathToCreate + "' with correct permissions", e);
        }
    }

    public TBuilder addDataFile(DataFileConfiguration configuration) {
        this.dataFileConfigs.add(configuration);
        return (TBuilder)this;
    }

    public TBuilder setTempDirPath(String dirPath) {
        this.tempDir = dirPath;
        return (TBuilder)this;
    }

    public abstract TBuilder setPerformanceProfile(Constants.PerformanceProfiles var1);

    @Override
    protected void preCreateEngine() {
        for (DataFileConfiguration dataFileConfig : this.dataFileConfigs) {
            AspectEngineDataFile dataFile = this.newAspectEngineDataFile();
            dataFile.setIdentifier(dataFileConfig.getIdentifier());
            dataFile.setConfiguration(dataFileConfig);
            dataFile.setTempDataDirPath(this.tempDir);
            if (dataFileConfig.getAutomaticUpdatesEnabled()) {
                if (this.dataUpdateService == null) {
                    throw new RuntimeException("Auto update enabled by data update service does not exist. This can be corrected by passing an DataUpdateService instance to the engine builder constructor. If building from configuration, this can be corrected by adding an DataUpdateService instance to the the pipeline builder via addService() method.");
                }
                this.dataUpdateService.registerDataFile(dataFile);
            }
            this.dataFiles.add(dataFile);
        }
    }

    @Override
    protected void configureEngine(TEngine engine) throws Exception {
        super.configureEngine(engine);
        for (AspectEngineDataFile dataFile : this.dataFiles) {
            dataFile.setEngine((OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>)engine);
            if (engine == null) continue;
            engine.addDataFile(dataFile);
        }
    }

    protected AspectEngineDataFile newAspectEngineDataFile() {
        return new AspectEngineDataFileDefault();
    }
}

