/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.flowelements;

import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectEngineDataFile;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.AspectEngineBase;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import fiftyone.pipeline.util.Types;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public abstract class OnPremiseAspectEngineBase<TData extends AspectData, TProperty extends AspectPropertyMetaData>
extends AspectEngineBase<TData, TProperty>
implements OnPremiseAspectEngine<TData, TProperty> {
    private final List<AspectEngineDataFile> dataFiles = new ArrayList<AspectEngineDataFile>();
    private String tempDataDirPath;

    public OnPremiseAspectEngineBase(Logger logger, ElementDataFactory<TData> aspectDataFactory, String tempDataDirPath) {
        super(logger, aspectDataFactory);
        this.setTempDataDirPath(tempDataDirPath);
    }

    @Override
    public List<AspectEngineDataFile> getDataFiles() {
        return Collections.unmodifiableList(this.dataFiles);
    }

    @Override
    public String getTempDataDirPath() {
        return this.tempDataDirPath;
    }

    protected void setTempDataDirPath(String tempDataDirPath) {
        this.tempDataDirPath = tempDataDirPath;
    }

    @Override
    public AspectEngineDataFile getDataFileMetaData(String dataFileIdentifier) {
        if (this.dataFiles.size() == 0) {
            return null;
        }
        if (this.dataFiles.size() == 1) {
            return this.dataFiles.get(0);
        }
        for (AspectEngineDataFile dataFile : this.dataFiles) {
            if (!dataFile.getIdentifier().equals(dataFileIdentifier)) continue;
            return dataFile;
        }
        return null;
    }

    @Override
    public AspectEngineDataFile getDataFileMetaData() {
        return this.getDataFileMetaData(null);
    }

    public abstract Date getDataFilePublishedDate(String var1);

    public Date getDataFilePublishedDate() {
        return this.getDataFilePublishedDate(null);
    }

    public abstract Date getDataFileUpdateAvailableTime(String var1);

    public Date getDataFileUpdateAvailableTime() {
        return this.getDataFileUpdateAvailableTime(null);
    }

    @Override
    public abstract void refreshData(String var1);

    @Override
    public abstract void refreshData(String var1, byte[] var2);

    @Override
    protected void managedResourcesCleanup() {
        for (AspectEngineDataFile dataFile : this.dataFiles) {
            try {
                dataFile.close();
            }
            catch (IOException iOException) {}
        }
        super.managedResourcesCleanup();
    }

    @Override
    public void addDataFile(AspectEngineDataFile dataFile) {
        this.dataFiles.add(dataFile);
        if (dataFile.getDataFilePath() != null && !dataFile.getDataFilePath().isEmpty()) {
            this.refreshData(dataFile.getIdentifier());
        } else if (dataFile.getConfiguration().getData() != null) {
            this.refreshData(dataFile.getIdentifier(), dataFile.getConfiguration().getData());
        } else {
            throw new PipelineConfigurationException("This engine requires the configured data file to have either the 'Data' property or 'DataFilePath' property populated but it has neither.");
        }
        dataFile.setEngine(this);
    }

    @Override
    public TypedKey<TData> getTypedDataKey() {
        if (this.typedKey == null) {
            this.typedKey = new TypedKeyDefault(this.getElementDataKey(), Types.findSubClassParameterType((Object)this, OnPremiseAspectEngineBase.class, (int)0));
        }
        return this.typedKey;
    }
}

