/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.flowelements;

import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.engines.caching.FlowCache;
import fiftyone.pipeline.engines.configuration.LazyLoadingConfiguration;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectDataBase;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.data.ProcessCallable;
import fiftyone.pipeline.engines.flowelements.AspectEngine;
import fiftyone.pipeline.engines.services.MissingPropertyService;
import fiftyone.pipeline.util.Types;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AspectEngineBase<TData extends AspectData, TProperty extends AspectPropertyMetaData>
extends FlowElementBase<TData, TProperty>
implements AspectEngine<TData, TProperty> {
    private LazyLoadingConfiguration lazyLoadingConfiguration = null;
    private ExecutorService executor = null;
    protected MissingPropertyService missingPropertyService;
    protected FlowCache cache = null;

    public AspectEngineBase(Logger logger, ElementDataFactory<TData> aspectDataFactory) {
        super(logger, aspectDataFactory);
    }

    public TypedKey<TData> getTypedDataKey() {
        if (this.typedKey == null) {
            this.typedKey = new TypedKeyDefault(this.getElementDataKey(), Types.findSubClassParameterType((Object)this, AspectEngineBase.class, (int)0));
        }
        return this.typedKey;
    }

    public abstract List<TProperty> getProperties();

    @Override
    public abstract String getDataSourceTier();

    @Override
    public void setCache(FlowCache cache) {
        this.cache = cache;
        cache.setFlowElement(this);
    }

    @Override
    public void setLazyLoading(LazyLoadingConfiguration configuration) {
        this.lazyLoadingConfiguration = configuration;
        this.executor = this.lazyLoadingConfiguration.getExecutorService();
    }

    @Override
    public LazyLoadingConfiguration getLazyLoadingConfiguration() {
        return this.lazyLoadingConfiguration;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    protected abstract void processEngine(FlowData var1, TData var2) throws Exception;

    protected final void processInternal(FlowData flowData) throws Exception {
        this.processWithCache(flowData);
    }

    private void processWithCache(final FlowData flowData) throws Exception {
        Object cacheResultsObject;
        AspectData cacheResult = null;
        if (this.cache != null && (cacheResultsObject = this.cache.get(flowData)) != null && this.getTypedDataKey().getType().isAssignableFrom(cacheResultsObject.getClass())) {
            cacheResult = (AspectData)cacheResultsObject;
        }
        if (cacheResult == null) {
            final AspectData aspectData = (AspectData)flowData.getOrAdd(this.getTypedDataKey(), this.getDataFactory());
            if (!aspectData.getEngines().contains(this)) {
                ((AspectDataBase)aspectData).addEngine(this);
            }
            if (this.lazyLoadingConfiguration != null) {
                ((AspectDataBase)aspectData).addProcessCallable(new ProcessCallable(this){

                    @Override
                    public Void call() throws Exception {
                        AspectEngineBase.this.processEngine(flowData, aspectData);
                        return null;
                    }
                });
            } else {
                this.processEngine(flowData, aspectData);
            }
            if (this.cache != null) {
                this.cache.put(flowData, flowData.getFromElement((FlowElement)this));
            }
        } else {
            flowData.getOrAdd(this.getTypedDataKey(), (FlowElement.DataFactory)new FlowElementBase.DataFactorySimple(cacheResult));
        }
    }

    protected void managedResourcesCleanup() {
        if (this.cache != null) {
            try {
                this.cache.close();
            }
            catch (IOException e) {
                this.logger.warn("Exception closing the cache", (Throwable)e);
            }
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(this.lazyLoadingConfiguration.getPropertyTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
            }
        }
    }
}

