/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.data;

import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.exceptions.NoValueException;

public class AspectPropertyValueDefault<T>
implements AspectPropertyValue<T> {
    boolean hasValue = false;
    private T value;
    private String noValueMessage = "The instance does not have a set value.";

    public AspectPropertyValueDefault() {
    }

    public AspectPropertyValueDefault(T value) {
        this.setValue(value);
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public T getValue() throws NoValueException {
        if (!this.hasValue) {
            throw new NoValueException(this.getNoValueMessage());
        }
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.hasValue = true;
        this.value = value;
    }

    @Override
    public String getNoValueMessage() {
        return this.noValueMessage;
    }

    @Override
    public void setNoValueMessage(String message) {
        this.noValueMessage = message;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof AspectPropertyValue && this.value != null) {
            try {
                result = this.getValue().equals(((AspectPropertyValue)obj).getValue());
            }
            catch (NoValueException e) {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        return this.value == null ? "NULL" : this.value.toString();
    }
}

