/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.configuration;

import fiftyone.pipeline.engines.configuration.DataFileConfiguration;
import fiftyone.pipeline.engines.data.DataUpdateUrlFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DataFileConfigurationBuilderBase<TBuilder extends DataFileConfigurationBuilderBase<TBuilder, TConfig>, TConfig extends DataFileConfiguration> {
    private String identifier;
    private String dataUpdateUrlOverride = null;
    private Boolean autoUpdateEnabled = null;
    private Boolean dataFileSystemWatcherEnabled = null;
    private Integer updatePollingIntervalSeconds = null;
    private Integer updateMaxRandomisationSeconds = null;
    private DataUpdateUrlFormatter dataUpdateUrlFormatter = null;
    private Boolean dataUpdateVerifyMd5 = null;
    private Boolean dataUpdateDecompress = null;
    private Boolean dataUpdateVerifyModifiedSince = null;
    private Boolean updateOnStartup = null;
    private final List<String> licenseKeys = new ArrayList<String>();

    protected List<String> getDataUpdateLicenseKeys() {
        return this.licenseKeys;
    }

    public TBuilder setDataFileIdentifier(String identifier) {
        this.identifier = identifier;
        return (TBuilder)this;
    }

    public TBuilder setDataUpdateUrl(String url) {
        this.dataUpdateUrlOverride = url;
        return (TBuilder)this;
    }

    public TBuilder setDataUpdateUrlFormatter(DataUpdateUrlFormatter formatter) {
        this.dataUpdateUrlFormatter = formatter;
        return (TBuilder)this;
    }

    public TBuilder setDataUpdateVerifyMd5(boolean verify) {
        this.dataUpdateVerifyMd5 = verify;
        return (TBuilder)this;
    }

    public TBuilder setDataUpdateDecompress(boolean decompress) {
        this.dataUpdateDecompress = decompress;
        return (TBuilder)this;
    }

    public TBuilder setAutoUpdate(boolean enabled) {
        this.autoUpdateEnabled = enabled;
        return (TBuilder)this;
    }

    public TBuilder setDataFileSystemWatcher(boolean enabled) {
        this.dataFileSystemWatcherEnabled = enabled;
        return (TBuilder)this;
    }

    public TBuilder setUpdatePollingInterval(int pollingIntervalSeconds) {
        this.updatePollingIntervalSeconds = pollingIntervalSeconds;
        return (TBuilder)this;
    }

    public TBuilder setUpdatePollingInterval(long pollingIntervalMillis) {
        if (pollingIntervalMillis / 1000L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Polling interval timespan too large.");
        }
        this.updatePollingIntervalSeconds = (int)pollingIntervalMillis / 1000;
        return (TBuilder)this;
    }

    public TBuilder setUpdateRandomisationMax(long maximumDeviationMillis) {
        if (maximumDeviationMillis / 1000L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Update randomisation timespan too large.");
        }
        this.updateMaxRandomisationSeconds = (int)maximumDeviationMillis / 1000;
        return (TBuilder)this;
    }

    public TBuilder setVerifyIfModifiedSince(boolean enabled) {
        this.dataUpdateVerifyModifiedSince = enabled;
        return (TBuilder)this;
    }

    public TBuilder setDataUpdateLicenseKey(String key) {
        if (key == null) {
            this.licenseKeys.clear();
            this.autoUpdateEnabled = false;
            this.updateOnStartup = false;
        } else {
            this.licenseKeys.add(key);
        }
        return (TBuilder)this;
    }

    public TBuilder setUpdateOnStartup(boolean enabled) {
        this.updateOnStartup = enabled;
        return (TBuilder)this;
    }

    public TBuilder setDataUpdateLicenseKeys(String[] keys) {
        Collections.addAll(this.licenseKeys, keys);
        return (TBuilder)this;
    }

    protected abstract TConfig createConfig();

    public TConfig build(String filename, boolean createTempCopy) {
        TConfig config = this.createConfig();
        this.configureCommonOptions(config);
        config.setDataFilePath(filename);
        config.setCreateTempCopy(createTempCopy);
        return config;
    }

    public TConfig build(byte[] data) {
        TConfig config = this.createConfig();
        this.configureCommonOptions(config);
        config.setData(data);
        return config;
    }

    private void configureCommonOptions(TConfig config) {
        config.setIdentifier(this.identifier);
        config.setDataUpdateLicenseKeys(this.licenseKeys);
        if (this.autoUpdateEnabled != null) {
            config.setAutomaticUpdatesEnabled(this.autoUpdateEnabled);
        }
        if (this.dataFileSystemWatcherEnabled != null) {
            config.setFileSystemWatcherEnabled(this.dataFileSystemWatcherEnabled);
        }
        if (this.updatePollingIntervalSeconds != null) {
            config.setPollingIntervalSeconds(this.updatePollingIntervalSeconds);
        }
        if (this.updateMaxRandomisationSeconds != null) {
            config.setMaxRandomisationSeconds(this.updateMaxRandomisationSeconds);
        }
        if (this.dataUpdateUrlOverride != null) {
            config.setDataUpdateUrl(this.dataUpdateUrlOverride);
        }
        if (this.dataUpdateUrlFormatter != null) {
            config.setUrlFormatter(this.dataUpdateUrlFormatter);
        }
        if (this.dataUpdateDecompress != null) {
            config.setDecompressContent(this.dataUpdateDecompress);
        }
        if (this.dataUpdateVerifyMd5 != null) {
            config.setVerifyMd5(this.dataUpdateVerifyMd5);
        }
        if (this.dataUpdateVerifyModifiedSince != null) {
            config.setVerifyModifiedSince(this.dataUpdateVerifyModifiedSince);
        }
        if (this.updateOnStartup != null) {
            config.setUpdateOnStartup(this.updateOnStartup);
        }
    }
}

