/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.caching;

import fiftyone.caching.PutCache;
import fiftyone.pipeline.core.data.DataKey;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.engines.caching.DataKeyedCache;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import java.io.IOException;

public abstract class DataKeyedCacheBase<V>
implements DataKeyedCache<V> {
    private PutCache<DataKey, V> internalCache;

    public DataKeyedCacheBase(CacheConfiguration configuration) {
        try {
            this.internalCache = (PutCache)configuration.getCacheBuilder().build(this.internalCache, configuration.getSize());
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Cache builder '" + configuration.getCacheBuilder().getClass().getSimpleName() + "' does not produce caches conforming to 'PutCache'");
        }
    }

    protected abstract EvidenceKeyFilter getFilter();

    public V get(FlowData flowData) {
        return (V)this.internalCache.get((Object)flowData.generateKey(this.getFilter()));
    }

    public void put(FlowData flowData, V value) {
        this.internalCache.put((Object)flowData.generateKey(this.getFilter()), value);
    }

    public void close() throws IOException {
        this.internalCache.close();
    }
}

