/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.infraestructure.store;

import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.infraestructure.DeserializeEventException;
import co.com.sofka.infraestructure.event.EventSerializer;
import co.com.sofka.infraestructure.store.StoredEventSerializer;
import java.util.Date;

public final class StoredEvent {
    private String eventBody;
    private Date occurredOn;
    private String typeName;

    public StoredEvent() {
    }

    public StoredEvent(String typeName, Date occurredOn, String eventBody) {
        this.setEventBody(eventBody);
        this.setOccurredOn(occurredOn);
        this.setTypeName(typeName);
    }

    public static StoredEvent wrapEvent(DomainEvent domainEvent) {
        return new StoredEvent(domainEvent.getClass().getCanonicalName(), new Date(), EventSerializer.instance().serialize(domainEvent));
    }

    public String getEventBody() {
        return this.eventBody;
    }

    public void setEventBody(String eventBody) {
        this.eventBody = eventBody;
    }

    public Date getOccurredOn() {
        return this.occurredOn;
    }

    public void setOccurredOn(Date occurredOn) {
        this.occurredOn = occurredOn;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public DomainEvent deserializeEvent() {
        try {
            return EventSerializer.instance().deserialize(this.getEventBody(), Class.forName(this.getTypeName()));
        }
        catch (ClassNotFoundException e) {
            throw new DeserializeEventException(e.getCause());
        }
    }

    public String toString() {
        return StoredEventSerializer.instance().serialize(this);
    }
}

