/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.infraestructure.handle;

import co.com.sofka.domain.generic.ViewModel;
import co.com.sofka.infraestructure.handle.ExecutionNoFound;
import co.com.sofka.infraestructure.handle.QueryHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Logger;

public class QueryExecutor
implements QueryHandler<Map<String, String>> {
    private static final Logger logger = Logger.getLogger(QueryExecutor.class.getName());
    protected Map<String, Function<Map<String, String>, ?>> handles = new ConcurrentHashMap();

    protected void put(String queryPath, Function<Map<String, String>, ?> function) {
        this.handles.put(queryPath, function);
    }

    @Override
    public ViewModel get(String path, Map<String, String> params) {
        if (!this.handles.containsKey(path)) {
            throw new ExecutionNoFound(path);
        }
        Object result = this.handles.get(path).apply(params);
        logger.info("View model applied OK --> " + params);
        return (ViewModel)result;
    }

    @Override
    public List<ViewModel> find(String path, Map<String, String> params) {
        if (!this.handles.containsKey(path)) {
            throw new ExecutionNoFound(path);
        }
        Object result = this.handles.get(path).apply(params);
        logger.info("View model list applied OK --> " + params);
        return (List)result;
    }
}

