/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.infraestructure.handle;

import co.com.sofka.business.asyn.UseCaseCommandExecutor;
import co.com.sofka.business.generic.UseCase;
import co.com.sofka.domain.generic.Command;
import co.com.sofka.infraestructure.controller.CommandWrapperSerializer;
import co.com.sofka.infraestructure.handle.CommandHandler;
import co.com.sofka.infraestructure.handle.CommandWrapper;
import co.com.sofka.infraestructure.handle.ExecutionNoFound;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;

public abstract class CommandExecutor
implements CommandHandler<String> {
    private static final Logger logger = Logger.getLogger(CommandExecutor.class.getName());
    protected Map<String, Consumer<Command>> handles = new ConcurrentHashMap<String, Consumer<Command>>();
    private UseCase.RequestValues request;

    protected void put(String type, Consumer<Command> consumer) {
        this.handles.put(type, consumer);
    }

    @Override
    public final void execute(String json) {
        CommandWrapper commandRequired = CommandWrapperSerializer.instance().deserialize(json);
        if (Objects.isNull(commandRequired.getCommandType()) || commandRequired.getCommandType().isBlank()) {
            throw new IllegalArgumentException("The commandType of the aggregate must be specified");
        }
        if (Objects.isNull(commandRequired.getAggregateId()) || commandRequired.getAggregateId().isBlank()) {
            throw new IllegalArgumentException("The aggregateId of the aggregate must be specified");
        }
        String type = commandRequired.getCommandType();
        if (!this.handles.containsKey(type)) {
            throw new ExecutionNoFound(type);
        }
        this.executeCommand(commandRequired);
    }

    private void executeCommand(CommandWrapper commandWrapper) {
        logger.info("####### Executor Command #######");
        Consumer<Command> consumer = this.handles.get(commandWrapper.getCommandType());
        UseCaseCommandExecutor useCaseExecutor = (UseCaseCommandExecutor)consumer;
        if (!Objects.isNull(commandWrapper.getAggregateId()) || !commandWrapper.getAggregateId().isBlank()) {
            useCaseExecutor.withAggregateId(commandWrapper.getAggregateId());
        }
        useCaseExecutor.executor(commandWrapper.valueOf(((ParameterizedType)useCaseExecutor.getClass().getGenericSuperclass()).getActualTypeArguments()[0]));
        this.request = useCaseExecutor.request();
    }

    public UseCase.RequestValues request() {
        return this.request;
    }
}

