/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.infraestructure.handle;

import co.com.sofka.business.asyn.UseCaseArgumentExecutor;
import co.com.sofka.business.generic.UseCase;
import co.com.sofka.infraestructure.handle.CommandHandler;
import co.com.sofka.infraestructure.handle.CommandWrapper;
import co.com.sofka.infraestructure.handle.ExecutionNoFound;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;

public abstract class ArgumentExecutor
implements CommandHandler<Map<String, String>> {
    private static final Logger logger = Logger.getLogger(ArgumentExecutor.class.getName());
    protected Map<String, Consumer<Map<String, String>>> handles = new ConcurrentHashMap<String, Consumer<Map<String, String>>>();
    private UseCase.RequestValues request;

    protected void put(String type, Consumer<Map<String, String>> consumer) {
        this.handles.put(type, consumer);
    }

    @Override
    public final void execute(Map<String, String> args) {
        CommandWrapper commandRequired = new CommandWrapper(args.get("commandType"), args.get("aggregateId"), args);
        if (Objects.isNull(commandRequired.getCommandType()) || commandRequired.getCommandType().isBlank()) {
            throw new IllegalArgumentException("The commandType of the aggregate must be specified");
        }
        if (Objects.isNull(commandRequired.getAggregateId()) || commandRequired.getAggregateId().isBlank()) {
            throw new IllegalArgumentException("The aggregateId of the aggregate must be specified");
        }
        String type = commandRequired.getCommandType();
        if (!this.handles.containsKey(type)) {
            throw new ExecutionNoFound(type);
        }
        this.executeCommand(commandRequired);
    }

    private void executeCommand(CommandWrapper commandWrapper) {
        logger.info("####### Executor Command #######");
        Consumer<Map<String, String>> consumer = this.handles.get(commandWrapper.getCommandType());
        UseCaseArgumentExecutor useCaseExecutor = (UseCaseArgumentExecutor)consumer;
        if (!Objects.isNull(commandWrapper.getAggregateId()) && !commandWrapper.getAggregateId().isBlank()) {
            useCaseExecutor.withAggregateId(commandWrapper.getAggregateId());
        }
        useCaseExecutor.executor((Map)commandWrapper.getPayLoad());
        this.request = useCaseExecutor.request();
    }

    public UseCase.RequestValues request() {
        return this.request;
    }
}

