/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.util;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.core.Scope;

public class CommonUtil {
    public static int getElIndexInSameTags(Element e, Scope scope) {
        Elements chs = e.parent().children();
        int index = 1;
        for (Element cur : chs) {
            if (!e.tagName().equals(cur.tagName()) || !scope.context().contains((Object)cur)) continue;
            if (e.equals((Object)cur)) break;
            ++index;
        }
        return index;
    }

    public static int sameTagElNums(Element e, Scope scope) {
        Elements context = new Elements();
        Elements els = e.parent().getElementsByTag(e.tagName());
        for (Element el : els) {
            if (!scope.context().contains((Object)el)) continue;
            context.add((Object)el);
        }
        return context.size();
    }

    public static int getIndexInContext(Scope scope, Element el) {
        for (int i = 0; i < scope.context().size(); ++i) {
            Element tmp = (Element)scope.context().get(i);
            if (!Objects.equals(tmp, el)) continue;
            return i + 1;
        }
        return Integer.MIN_VALUE;
    }

    public static Elements followingSibling(Element el) {
        Elements rs = new Elements();
        for (Element tmp = el.nextElementSibling(); tmp != null; tmp = tmp.nextElementSibling()) {
            rs.add((Object)tmp);
        }
        if (rs.size() > 0) {
            return rs;
        }
        return null;
    }

    public static Elements precedingSibling(Element el) {
        Elements rs = new Elements();
        for (Element tmp = el.previousElementSibling(); tmp != null; tmp = tmp.previousElementSibling()) {
            rs.add((Object)tmp);
        }
        if (rs.size() > 0) {
            return rs;
        }
        return null;
    }

    public static void setSameTagIndexInSiblings(Element ori, int index) {
        if (ori == null) {
            return;
        }
        ori.attr("EL_SAME_TAG_INDEX", String.valueOf(index));
    }

    public static int getJxSameTagIndexInSiblings(Element ori) {
        String val = ori.attr("EL_SAME_TAG_INDEX");
        if (StringUtils.isBlank((CharSequence)val)) {
            return -1;
        }
        return Integer.parseInt(val);
    }

    public static void setSameTagNumsInSiblings(Element ori, int nums) {
        if (ori == null) {
            return;
        }
        ori.attr("EL_SAME_TAG_ALL_NUM", String.valueOf(nums));
    }

    public static int getJxSameTagNumsInSiblings(Element ori) {
        String val = ori.attr("EL_SAME_TAG_ALL_NUM");
        if (StringUtils.isBlank((CharSequence)val)) {
            return -1;
        }
        return Integer.parseInt(val);
    }
}

