/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core.function;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import org.jsoup.nodes.Element;
import org.seimicrawler.xpath.core.Constants;
import org.seimicrawler.xpath.core.Function;
import org.seimicrawler.xpath.core.Scope;
import org.seimicrawler.xpath.core.XValue;

public class Sum
implements Function {
    @Override
    public String name() {
        return "sum";
    }

    @Override
    public XValue call(Scope scope, List<XValue> params) {
        if (params == null || params.isEmpty()) {
            return XValue.create(0);
        }
        LinkedList<Double> pvs = new LinkedList<Double>();
        for (XValue p : params) {
            if (p.isNumber()) {
                pvs.add(p.asDouble());
            }
            if (p.isString()) {
                Double pv = this.getNumFromStr(p.asString());
                if (pv == null) {
                    return null;
                }
                pvs.add(pv);
            }
            if (!p.isElements()) continue;
            for (Element e : p.asElements()) {
                Double pv = this.getNumFromStr(e.ownText());
                if (pv == null) {
                    return null;
                }
                pvs.add(pv);
            }
        }
        Double finalVal = pvs.stream().reduce(0.0, Double::sum);
        if (finalVal.compareTo(new BigDecimal(finalVal.longValue()).doubleValue()) == 0) {
            return XValue.create(new Long(finalVal.longValue()));
        }
        return XValue.create(finalVal);
    }

    private Double getNumFromStr(String str) {
        Matcher matcher = Constants.NUM_PATTERN.matcher(str);
        if (matcher.matches()) {
            return Double.parseDouble(str);
        }
        return null;
    }
}

