/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath;

import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.JXNode;
import org.seimicrawler.xpath.antlr.XpathLexer;
import org.seimicrawler.xpath.antlr.XpathParser;
import org.seimicrawler.xpath.core.XValue;
import org.seimicrawler.xpath.core.XpathProcessor;
import org.seimicrawler.xpath.exception.DoFailOnErrorHandler;
import org.seimicrawler.xpath.exception.XpathParserException;
import org.seimicrawler.xpath.exception.XpathSyntaxErrorException;

public class JXDocument {
    private Elements elements;

    public JXDocument(Elements els) {
        this.elements = els;
    }

    public static JXDocument create(Document doc) {
        Elements els = doc.children();
        return new JXDocument(els);
    }

    public static JXDocument create(Elements els) {
        return new JXDocument(els);
    }

    public static JXDocument create(String html) {
        Elements els = Jsoup.parse((String)html).children();
        return new JXDocument(els);
    }

    public static JXDocument createByUrl(String url) {
        Elements els;
        try {
            els = Jsoup.connect((String)url).get().children();
        }
        catch (Exception e) {
            throw new XpathParserException("url\u8d44\u6e90\u83b7\u53d6\u5931\u8d25", e);
        }
        return new JXDocument(els);
    }

    public List<Object> sel(String xpath) {
        LinkedList<Object> res = new LinkedList<Object>();
        for (JXNode node : this.selN(xpath)) {
            if (node.isElement()) {
                res.add(node.asElement());
                continue;
            }
            res.add(node.toString());
        }
        return res;
    }

    public List<JXNode> selN(String xpath) {
        LinkedList<JXNode> finalRes = new LinkedList<JXNode>();
        try {
            CodePointCharStream input = CharStreams.fromString((String)xpath);
            XpathLexer lexer = new XpathLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            XpathParser parser = new XpathParser((TokenStream)tokens);
            parser.setErrorHandler((ANTLRErrorStrategy)new DoFailOnErrorHandler());
            XpathParser.MainContext tree = parser.main();
            XpathProcessor processor = new XpathProcessor(this.elements);
            XValue calRes = (XValue)processor.visit((ParseTree)tree);
            if (calRes == null) {
                finalRes.add(JXNode.create(""));
                return finalRes;
            }
            if (calRes.isElements()) {
                for (Element el : calRes.asElements()) {
                    finalRes.add(JXNode.create(el));
                }
                return finalRes;
            }
            if (calRes.isList()) {
                for (String str : calRes.asList()) {
                    finalRes.add(JXNode.create(str));
                }
                return finalRes;
            }
            if (calRes.isString()) {
                finalRes.add(JXNode.create(calRes.asString()));
                return finalRes;
            }
            if (calRes.isNumber()) {
                Class vType = calRes.valType();
                if (vType.isAssignableFrom(Long.class) || vType.isAssignableFrom(Integer.class)) {
                    finalRes.add(JXNode.create(calRes.asLong()));
                } else {
                    finalRes.add(JXNode.create(calRes.asDouble()));
                }
                return finalRes;
            }
            if (calRes.isBoolean()) {
                finalRes.add(JXNode.create(calRes.asBoolean()));
                return finalRes;
            }
            if (calRes.isDate()) {
                finalRes.add(JXNode.create(calRes.asDate()));
                return finalRes;
            }
            finalRes.add(JXNode.create(calRes.asString()));
        }
        catch (Exception e) {
            String msg = "Please check the syntax of your xpath expr or commit a ";
            throw new XpathSyntaxErrorException(msg + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
        return finalRes;
    }

    public Object selOne(String xpath) {
        JXNode jxNode = this.selNOne(xpath);
        if (jxNode != null) {
            if (jxNode.isElement()) {
                return jxNode.asElement();
            }
            return jxNode.toString();
        }
        return null;
    }

    public JXNode selNOne(String xpath) {
        List<JXNode> jxNodeList = this.selN(xpath);
        if (jxNodeList != null && jxNodeList.size() > 0) {
            return jxNodeList.get(0);
        }
        return null;
    }
}

