/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.starter.cache;

import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.redis.util.CreateRedisTemplateUtil;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.modular.home.cache.InterfaceStatisticsRedisCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleDataScopeRedisCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleRedisCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleResourceRedisCache;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.system.modular.theme.cache.ThemeRedisCache;
import cn.stylefeng.roses.kernel.system.modular.theme.pojo.DefaultTheme;
import cn.stylefeng.roses.kernel.system.modular.user.cache.SysUserRedisCache;
import cn.stylefeng.roses.kernel.system.modular.user.cache.UserOrgRedisCache;
import cn.stylefeng.roses.kernel.system.modular.user.cache.UserRoleRedisCache;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class GunsSystemRedisCacheAutoConfiguration {
    @Bean
    public CacheOperatorApi<SysUserDTO> sysUserCacheOperatorApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new SysUserRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<List<Long>> userRoleCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new UserRoleRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<SysRole> roleInfoCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new RoleRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<SysUserOrgDTO> userOrgCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new UserOrgRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<List<String>> roleResourceCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new RoleResourceRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<List<Long>> roleDataScopeCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new RoleDataScopeRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<DefaultTheme> themeCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new ThemeRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<Map<Long, Integer>> requestCountCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new InterfaceStatisticsRedisCache(redisTemplate);
    }
}

