/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.starter.cache;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.system.api.constants.StatisticsCacheConstants;
import cn.stylefeng.roses.kernel.system.api.constants.SystemCachesConstants;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.modular.home.cache.InterfaceStatisticsMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleDataScopeMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.cache.RoleResourceMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.system.modular.theme.cache.ThemeMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.theme.pojo.DefaultTheme;
import cn.stylefeng.roses.kernel.system.modular.user.cache.SysUserMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.user.cache.UserOrgMemoryCache;
import cn.stylefeng.roses.kernel.system.modular.user.cache.UserRoleMemoryCache;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class GunsSystemMemoryCacheAutoConfiguration {
    @Bean
    public CacheOperatorApi<SysUserDTO> sysUserCacheOperatorApi() {
        TimedCache sysUserTimedCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new SysUserMemoryCache(sysUserTimedCache);
    }

    @Bean
    public CacheOperatorApi<List<Long>> userRoleCacheApi() {
        TimedCache userRoleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new UserRoleMemoryCache(userRoleCache);
    }

    @Bean
    public CacheOperatorApi<SysRole> roleInfoCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new RoleMemoryCache(roleCache);
    }

    @Bean
    public CacheOperatorApi<SysUserOrgDTO> userOrgCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new UserOrgMemoryCache(roleCache);
    }

    @Bean
    public CacheOperatorApi<List<String>> roleResourceCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new RoleResourceMemoryCache(roleCache);
    }

    @Bean
    public CacheOperatorApi<List<Long>> roleDataScopeCacheApi() {
        TimedCache roleCache = CacheUtil.newTimedCache((long)(SystemCachesConstants.USER_CACHE_TIMEOUT_SECONDS * 1000L));
        return new RoleDataScopeMemoryCache(roleCache);
    }

    @Bean
    public CacheOperatorApi<DefaultTheme> themeCacheApi() {
        TimedCache themeCache = CacheUtil.newTimedCache((long)Long.MAX_VALUE);
        return new ThemeMemoryCache(themeCache);
    }

    @Bean
    public CacheOperatorApi<Map<Long, Integer>> requestCountCacheApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)StatisticsCacheConstants.INTERFACE_STATISTICS_CACHE_TIMEOUT_SECONDS);
        return new InterfaceStatisticsMemoryCache(timedCache);
    }
}

