/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.init.actuator;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.exception.enums.DbInitEnum;
import cn.stylefeng.roses.kernel.db.api.pojo.db.TableFieldInfo;
import cn.stylefeng.roses.kernel.db.api.pojo.db.TableInfo;
import cn.stylefeng.roses.kernel.db.api.pojo.druid.DruidProperties;
import cn.stylefeng.roses.kernel.db.api.util.DatabaseUtil;
import cn.stylefeng.roses.kernel.db.init.util.SqlExe;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbInitializer {
    private static final Logger log = LoggerFactory.getLogger(DbInitializer.class);
    private Boolean fieldValidatorExceptionFlag = true;
    @Resource
    private DruidProperties druidProperties;

    public DbInitializer() {
    }

    public DbInitializer(Boolean fieldValidatorExceptionFlag) {
        this.fieldValidatorExceptionFlag = fieldValidatorExceptionFlag;
    }

    public void dbInit() {
        this.initTable();
        this.fieldsValidate();
    }

    private void initTable() {
        String tableName = this.getTableName();
        String tableInitSql = this.getTableInitSql();
        if ((ObjectUtil.isEmpty((Object)tableName) || ObjectUtil.isEmpty((Object)tableInitSql)) && this.fieldValidatorExceptionFlag.booleanValue()) {
            throw new ServiceException((AbstractExceptionEnum)DbInitEnum.INIT_TABLE_EMPTY_PARAMS);
        }
        List tableInfos = DatabaseUtil.selectTables((DruidProperties)this.druidProperties);
        boolean haveSmsTableFlag = false;
        for (TableInfo tableInfo : tableInfos) {
            if (!tableInfo.getTableName().equalsIgnoreCase(tableName)) continue;
            haveSmsTableFlag = true;
            break;
        }
        if (!haveSmsTableFlag) {
            SqlExe.update(tableInitSql, new Object[0]);
            log.info("\u521d\u59cb\u5316" + this.getTableName() + "\u6210\u529f\uff01");
        }
    }

    private void fieldsValidate() {
        List tableFields = DatabaseUtil.getTableFields((DruidProperties)this.druidProperties, (String)this.getTableName());
        if (tableFields != null && !tableFields.isEmpty()) {
            ArrayList<String> fieldsNotInClass = new ArrayList<String>();
            List<String> classFields = this.getClassFields();
            for (TableFieldInfo tableField : tableFields) {
                String fieldName = tableField.getColumnName();
                if (classFields.contains(fieldName.toLowerCase())) continue;
                fieldsNotInClass.add(fieldName);
            }
            if (!fieldsNotInClass.isEmpty()) {
                log.error("\u5b9e\u4f53\u4e2d\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u4e0d\u4e00\u81f4\u7684\u5b57\u6bb5\u5982\u4e0b\uff1a" + JSON.toJSONString(fieldsNotInClass));
                if (this.fieldValidatorExceptionFlag.booleanValue()) {
                    throw new ServiceException((AbstractExceptionEnum)DbInitEnum.FIELD_VALIDATE_ERROR);
                }
            }
        }
    }

    private List<String> getClassFields() {
        Field[] superfields;
        Class<?> entityClass = this.getEntityClass();
        Field[] declaredFields = ClassUtil.getDeclaredFields(entityClass);
        ArrayList<String> filedNamesUnderlineCase = new ArrayList<String>();
        for (Field declaredField : declaredFields) {
            String fieldName = StrUtil.toUnderlineCase((CharSequence)declaredField.getName());
            filedNamesUnderlineCase.add(fieldName);
        }
        for (Field superfield : superfields = ReflectUtil.getFields(entityClass.getSuperclass())) {
            String fieldName = StrUtil.toUnderlineCase((CharSequence)superfield.getName());
            filedNamesUnderlineCase.add(fieldName);
        }
        return filedNamesUnderlineCase;
    }

    protected abstract String getTableInitSql();

    protected abstract String getTableName();

    protected abstract Class<?> getEntityClass();

    public Boolean getFieldValidatorExceptionFlag() {
        return this.fieldValidatorExceptionFlag;
    }

    public void setFieldValidatorExceptionFlag(Boolean fieldValidatorExceptionFlag) {
        this.fieldValidatorExceptionFlag = fieldValidatorExceptionFlag;
    }

    public void setDruidProperties(DruidProperties druidProperties) {
        this.druidProperties = druidProperties;
    }

    public DruidProperties getDruidProperties() {
        return this.druidProperties;
    }
}

