/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import cn.jpush.api.push.model.notification.WinphoneNotification;
import cn.jpush.api.utils.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Notification
implements PushModel {
    private final String alert;
    private final Set<PlatformNotification> notifications;

    private Notification(String alert, Set<PlatformNotification> notifications) {
        this.alert = alert;
        this.notifications = notifications;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Notification alert(String alert) {
        return Notification.newBuilder().setAlert(alert).build();
    }

    public static Notification android(String alert, String title, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert(alert).setTitle(title).addExtras((Map)extras)).build()).build();
    }

    public static Notification ios(String alert, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(((IosNotification.Builder)IosNotification.newBuilder().setAlert(alert).addExtras((Map)extras)).build()).build();
    }

    public static Notification ios_auto_badge() {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert("").autoBadge().build()).build();
    }

    public static Notification ios_set_badge(int badge) {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert("").setBadge(badge).build()).build();
    }

    public static Notification ios_incr_badge(int badge) {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert("").incrBadge(badge).build()).build();
    }

    public static Notification winphone(String alert, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(((WinphoneNotification.Builder)WinphoneNotification.newBuilder().setAlert(alert).addExtras((Map)extras)).build()).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.alert) {
            json.add("alert", (JsonElement)new JsonPrimitive(this.alert));
        }
        if (null != this.notifications) {
            for (PlatformNotification pn : this.notifications) {
                if (this.alert != null && pn.getAlert() == null) {
                    pn.setAlert(this.alert);
                }
                Preconditions.checkArgument(null != pn.getAlert(), "For any platform notification, alert field is needed. It can be empty string.");
                json.add(pn.getPlatform(), pn.toJSON());
            }
        }
        return json;
    }

    public static class Builder {
        private String alert;
        private Set<PlatformNotification> builder;

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addPlatformNotification(PlatformNotification notification) {
            if (null == this.builder) {
                this.builder = new HashSet<PlatformNotification>();
            }
            this.builder.add(notification);
            return this;
        }

        public Notification build() {
            Preconditions.checkArgument(null != this.builder || null != this.alert, "No notification payload is set.");
            return new Notification(this.alert, this.builder);
        }
    }
}

