/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlLog;
import cn.hutool.db.sql.SqlUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatementUtil {
    public static PreparedStatement fillParams(PreparedStatement ps, Object ... params) throws SQLException {
        if (ArrayUtil.isEmpty(params)) {
            return ps;
        }
        return StatementUtil.fillParams(ps, new ArrayIter(params));
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params) throws SQLException {
        return StatementUtil.fillParams(ps, params, null);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params, Map<Integer, Integer> nullTypeCache) throws SQLException {
        if (null == params) {
            return ps;
        }
        int paramIndex = 1;
        for (Object param : params) {
            StatementUtil.setParam(ps, paramIndex++, param, nullTypeCache);
        }
        return ps;
    }

    public static PreparedStatement prepareStatement(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        return StatementUtil.prepareStatement(conn, sqlBuilder.build(), sqlBuilder.getParamValueArray());
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Collection<Object> params) throws SQLException {
        return StatementUtil.prepareStatement(conn, sql, params.toArray(new Object[params.size()]));
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, ArrayUtil.isEmpty(params) ? null : params);
        PreparedStatement ps = StrUtil.startWithIgnoreCase(sql, "insert") ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
        return StatementUtil.fillParams(ps, params);
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        return StatementUtil.prepareStatementForBatch(conn, sql, new ArrayIter<Object[]>(paramsBatch));
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, paramsBatch);
        PreparedStatement ps = conn.prepareStatement(sql);
        for (Object[] params : paramsBatch) {
            StatementUtil.fillParams(ps, params);
            ps.addBatch();
        }
        return ps;
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, List<String> fields, Entity ... entities) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.logForBatch(sql);
        PreparedStatement ps = conn.prepareStatement(sql);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        for (Entity entity : entities) {
            StatementUtil.fillParams(ps, CollectionUtil.valuesOfKeys(entity, fields), nullTypeMap);
            ps.addBatch();
        }
        return ps;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, params);
        CallableStatement call = conn.prepareCall(sql);
        StatementUtil.fillParams((PreparedStatement)call, params);
        return call;
    }

    public static Long getGeneratedKeyOfLong(Statement ps) throws SQLException {
        try (ResultSet rs = ps.getGeneratedKeys();){
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            Long l = generatedKey;
            return l;
        }
    }

    public static List<Object> getGeneratedKeys(Statement ps) throws SQLException {
        ArrayList<Object> keys = new ArrayList<Object>();
        try (ResultSet rs = ps.getGeneratedKeys();){
            if (null != rs) {
                int i = 1;
                while (rs.next()) {
                    keys.add(rs.getObject(i++));
                }
            }
            ArrayList<Object> arrayList = keys;
            return arrayList;
        }
    }

    public static int getTypeOfNull(PreparedStatement ps, int paramIndex) {
        int sqlType = 12;
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            sqlType = pmd.getParameterType(paramIndex);
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return sqlType;
    }

    public static void setParam(PreparedStatement ps, int paramIndex, Object param) throws SQLException {
        StatementUtil.setParam(ps, paramIndex, param, null);
    }

    private static void setParam(PreparedStatement ps, int paramIndex, Object param, Map<Integer, Integer> nullTypeCache) throws SQLException {
        if (null == param) {
            Integer type;
            Integer n = type = null == nullTypeCache ? null : nullTypeCache.get(paramIndex);
            if (null == type) {
                type = StatementUtil.getTypeOfNull(ps, paramIndex);
                if (null != nullTypeCache) {
                    nullTypeCache.put(paramIndex, type);
                }
            }
            ps.setNull(paramIndex, type);
        }
        if (param instanceof java.util.Date) {
            if (param instanceof Date) {
                ps.setDate(paramIndex, (Date)param);
            } else if (param instanceof Time) {
                ps.setTime(paramIndex, (Time)param);
            } else {
                ps.setTimestamp(paramIndex, SqlUtil.toSqlTimestamp((java.util.Date)param));
            }
            return;
        }
        if (param instanceof Number) {
            if (param instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)param);
                return;
            }
            if (param instanceof BigInteger) {
                ps.setBigDecimal(paramIndex, new BigDecimal((BigInteger)param));
                return;
            }
        }
        ps.setObject(paramIndex, param);
    }
}

