/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.notify;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import cn.hippo4j.config.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.config.springboot.starter.config.NotifyPlatformProperties;
import cn.hippo4j.message.api.NotifyConfigBuilder;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.service.AlarmControlHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreNotifyConfigBuilder
implements NotifyConfigBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoreNotifyConfigBuilder.class);
    private final AlarmControlHandler alarmControlHandler;
    private final BootstrapConfigProperties configProperties;

    public Map<String, List<NotifyConfigDTO>> buildNotify() {
        HashMap<String, List<NotifyConfigDTO>> resultMap = new HashMap<String, List<NotifyConfigDTO>>();
        boolean globalAlarm = Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(each -> each.getAlarm()).orElse(true);
        List<ExecutorProperties> executors = this.configProperties.getExecutors();
        if (CollectionUtil.isEmpty(executors)) {
            log.warn("Failed to build notify, executors configuration is empty.");
            return resultMap;
        }
        List actual = executors.stream().filter(each -> Optional.ofNullable(each.getAlarm()).orElse(false)).collect(Collectors.toList());
        if (!globalAlarm && CollectionUtil.isEmpty(actual)) {
            return resultMap;
        }
        for (ExecutorProperties executorProperties : executors) {
            Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig = this.buildSingleNotifyConfig(executorProperties);
            this.initCacheAndLock(buildSingleNotifyConfig);
            resultMap.putAll(buildSingleNotifyConfig);
        }
        return resultMap;
    }

    public Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig(ExecutorProperties executorProperties) {
        HashMap<String, List<NotifyConfigDTO>> resultMap = new HashMap<String, List<NotifyConfigDTO>>();
        String threadPoolId = executorProperties.getThreadPoolId();
        String alarmBuildKey = threadPoolId + "+ALARM";
        ArrayList<NotifyConfigDTO> alarmNotifyConfigs = new ArrayList<NotifyConfigDTO>();
        List<NotifyPlatformProperties> notifyPlatforms = this.configProperties.getNotifyPlatforms();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setTpId(threadPoolId);
            notifyConfig.setType("ALARM");
            notifyConfig.setSecret(platformProperties.getSecret());
            notifyConfig.setSecretKey(this.getToken(platformProperties));
            int interval = Optional.ofNullable(executorProperties.getNotify()).map(each -> each.getInterval()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(each -> each.getNotify()).map(each -> each.getInterval()).orElse(5));
            notifyConfig.setInterval(Integer.valueOf(interval));
            notifyConfig.setReceives(this.buildReceive(executorProperties));
            alarmNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(alarmBuildKey, alarmNotifyConfigs);
        String changeBuildKey = threadPoolId + "+CONFIG";
        ArrayList<NotifyConfigDTO> changeNotifyConfigs = new ArrayList<NotifyConfigDTO>();
        for (NotifyPlatformProperties platformProperties : notifyPlatforms) {
            NotifyConfigDTO notifyConfig = new NotifyConfigDTO();
            notifyConfig.setPlatform(platformProperties.getPlatform());
            notifyConfig.setTpId(threadPoolId);
            notifyConfig.setType("CONFIG");
            notifyConfig.setSecretKey(this.getToken(platformProperties));
            notifyConfig.setSecret(platformProperties.getSecret());
            notifyConfig.setReceives(this.buildReceive(executorProperties));
            changeNotifyConfigs.add(notifyConfig);
        }
        resultMap.put(changeBuildKey, changeNotifyConfigs);
        return resultMap;
    }

    public void initCacheAndLock(Map<String, List<NotifyConfigDTO>> buildSingleNotifyConfig) {
        buildSingleNotifyConfig.forEach((key, val) -> val.stream().filter(each -> Objects.equals("ALARM", each.getType())).forEach(each -> this.alarmControlHandler.initCacheAndLock(each.getTpId(), each.getPlatform(), each.getInterval())));
    }

    private String buildReceive(ExecutorProperties executorProperties) {
        String receives = Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(each -> each.getNotify()).map(each -> each.getReceives()).orElse("");
        if (executorProperties.getNotify() != null && StringUtil.isNotEmpty((CharSequence)executorProperties.getNotify().getReceives())) {
            receives = executorProperties.getNotify().getReceives();
        }
        return receives;
    }

    private String getToken(NotifyPlatformProperties platformProperties) {
        return StringUtil.isNotBlank((CharSequence)platformProperties.getToken()) ? platformProperties.getToken() : platformProperties.getSecretKey();
    }

    @Generated
    public CoreNotifyConfigBuilder(AlarmControlHandler alarmControlHandler, BootstrapConfigProperties configProperties) {
        this.alarmControlHandler = alarmControlHandler;
        this.configProperties = configProperties;
    }
}

