/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.jd.processor;

import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.definition.SmsProperties;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import cn.herodotus.engine.sms.jd.properties.JdSmsProperties;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.auth.StaticCredentialsProvider;
import com.jdcloud.sdk.http.HttpRequestConfig;
import com.jdcloud.sdk.http.Protocol;
import com.jdcloud.sdk.service.sms.client.SmsClient;
import com.jdcloud.sdk.service.sms.model.BatchSendRequest;
import com.jdcloud.sdk.service.sms.model.BatchSendResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdSmsSendHandler
extends AbstractSmsSendHandler {
    private static final Logger log = LoggerFactory.getLogger(JdSmsSendHandler.class);
    private final SmsClient smsClient;
    private final JdSmsProperties properties;

    public JdSmsSendHandler(JdSmsProperties properties) {
        super((SmsProperties)properties);
        this.properties = properties;
        StaticCredentialsProvider credentialsProvider = new StaticCredentialsProvider(properties.getAccessKeyId(), properties.getSecretAccessKey());
        this.smsClient = SmsClient.builder().credentialsProvider((CredentialsProvider)credentialsProvider).httpRequestConfig(new HttpRequestConfig.Builder().protocol(Protocol.HTTP).build()).build();
    }

    protected String getChannel() {
        return SmsSupplier.JD_CLOUD.name();
    }

    protected boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        List templateParams = this.getOrderedParams(template);
        String templateId = this.getTemplateId(template);
        BatchSendRequest request = new BatchSendRequest();
        request.setRegionId(this.properties.getRegion());
        request.setTemplateId(templateId);
        request.setSignId(this.properties.getSignId());
        request.setPhoneList(phones);
        request.setParams(templateParams);
        BatchSendResult result = (BatchSendResult)this.smsClient.batchSend(request).getResult();
        Boolean status = result.getStatus();
        return status != null && status != false;
    }
}

