/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.rocketmq;

import com.dtp.adapter.common.AbstractDtpAdapter;
import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.properties.DtpProperties;
import com.dtp.common.util.ReflectionUtil;
import com.dtp.core.support.ExecutorWrapper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections.MapUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageConcurrentlyService;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageOrderlyService;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMqDtpAdapter
extends AbstractDtpAdapter {
    private static final Logger log = LoggerFactory.getLogger(RocketMqDtpAdapter.class);
    private static final String NAME = "rocketMqTp";
    private static final String CONSUME_EXECUTOR_FIELD_NAME = "consumeExecutor";

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(NAME, dtpProperties.getRocketMqTp(), dtpProperties.getPlatforms());
    }

    protected void initialize() {
        super.initialize();
        Map beans = ApplicationContextHolder.getBeansOfType(DefaultRocketMQListenerContainer.class);
        if (MapUtils.isEmpty((Map)beans)) {
            log.warn("Cannot find beans of type DefaultRocketMQListenerContainer.");
            return;
        }
        beans.forEach((k, v) -> {
            DefaultRocketMQListenerContainer container = v;
            DefaultMQPushConsumer consumer = container.getConsumer();
            DefaultMQPushConsumerImpl pushConsumer = (DefaultMQPushConsumerImpl)ReflectionUtil.getFieldValue(DefaultMQPushConsumer.class, (String)"defaultMQPushConsumerImpl", (Object)consumer);
            if (Objects.isNull(pushConsumer)) {
                return;
            }
            String key = container.getConsumerGroup() + "#" + container.getTopic();
            ThreadPoolExecutor executor = null;
            ConsumeMessageService consumeMessageService = pushConsumer.getConsumeMessageService();
            if (consumeMessageService instanceof ConsumeMessageConcurrentlyService) {
                executor = (ThreadPoolExecutor)ReflectionUtil.getFieldValue(ConsumeMessageConcurrentlyService.class, (String)CONSUME_EXECUTOR_FIELD_NAME, (Object)consumeMessageService);
            } else if (consumeMessageService instanceof ConsumeMessageOrderlyService) {
                executor = (ThreadPoolExecutor)ReflectionUtil.getFieldValue(ConsumeMessageOrderlyService.class, (String)CONSUME_EXECUTOR_FIELD_NAME, (Object)consumeMessageService);
            }
            if (Objects.nonNull(executor)) {
                ExecutorWrapper executorWrapper = new ExecutorWrapper(key, (Executor)executor);
                this.initNotifyItems(key, executorWrapper);
                this.executors.put(key, executorWrapper);
            }
        });
        log.info("DynamicTp adapter, rocketMq consumer executors init end, executors: {}", (Object)this.executors);
    }
}

