/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.dubbo.apache;

import com.dtp.adapter.common.AbstractDtpAdapter;
import com.dtp.adapter.dubbo.apache.DubboVersion;
import com.dtp.common.properties.DtpProperties;
import com.dtp.common.util.ReflectionUtil;
import com.dtp.core.support.ExecutorWrapper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.threadpool.manager.DefaultExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDubboDtpAdapter
extends AbstractDtpAdapter {
    private static final Logger log = LoggerFactory.getLogger(ApacheDubboDtpAdapter.class);
    private static final String NAME = "dubboTp";
    private static final String EXECUTOR_SERVICE_COMPONENT_KEY = ExecutorService.class.getName();

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(NAME, dtpProperties.getDubboTp(), dtpProperties.getPlatforms());
    }

    protected void initialize() {
        super.initialize();
        String currVersion = Version.getVersion();
        if (DubboVersion.compare("2.7.5", currVersion) > 0) {
            DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
            if (Objects.isNull(dataStore)) {
                return;
            }
            Map executorMap = dataStore.get(EXECUTOR_SERVICE_COMPONENT_KEY);
            if (MapUtils.isNotEmpty((Map)executorMap)) {
                executorMap.forEach((k, v) -> this.doInit((String)k, (ThreadPoolExecutor)v));
            }
            log.info("DynamicTp adapter, apache dubbo provider executors init end, executors: {}", (Object)this.executors);
            return;
        }
        ExecutorRepository executorRepository = DubboVersion.compare(currVersion, "3.0.3") >= 0 ? (ExecutorRepository)ApplicationModel.defaultModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension() : (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        ConcurrentMap data = (ConcurrentMap)ReflectionUtil.getFieldValue(DefaultExecutorRepository.class, (String)"data", (Object)executorRepository);
        if (Objects.isNull(data)) {
            return;
        }
        Map executorMap = (Map)data.get(EXECUTOR_SERVICE_COMPONENT_KEY);
        if (MapUtils.isNotEmpty((Map)executorMap)) {
            executorMap.forEach((k, v) -> this.doInit(k.toString(), (ThreadPoolExecutor)v));
        }
        log.info("DynamicTp adapter, apache dubbo provider executors init end, executors: {}", (Object)this.executors);
    }

    private void doInit(String port, ThreadPoolExecutor executor) {
        String name = this.genTpName(port);
        ExecutorWrapper executorWrapper = new ExecutorWrapper(name, (Executor)executor);
        this.initNotifyItems(name, executorWrapper);
        this.executors.put(name, executorWrapper);
    }

    private String genTpName(String port) {
        return "dubboTp#" + port;
    }
}

