/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.dubbo.alibaba;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.store.DataStore;
import com.dtp.adapter.common.AbstractDtpAdapter;
import com.dtp.common.properties.DtpProperties;
import com.dtp.core.support.ExecutorWrapper;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaDubboDtpAdapter
extends AbstractDtpAdapter {
    private static final Logger log = LoggerFactory.getLogger(AlibabaDubboDtpAdapter.class);
    private static final String NAME = "dubboTp";

    public void refresh(DtpProperties dtpProperties) {
        this.refresh(NAME, dtpProperties.getDubboTp(), dtpProperties.getPlatforms());
    }

    protected void initialize() {
        super.initialize();
        DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
        Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
        if (MapUtils.isNotEmpty((Map)executors)) {
            executors.forEach((k, v) -> {
                String name = this.genTpName((String)k);
                ExecutorWrapper executorWrapper = new ExecutorWrapper(name, (Executor)((ThreadPoolExecutor)v));
                this.initNotifyItems(name, executorWrapper);
                executors.put(name, executorWrapper);
            });
        }
        log.info("DynamicTp adapter, alibaba dubbo provider executors init end, executors: {}", (Object)executors);
    }

    private String genTpName(String port) {
        return "dubboTp#" + port;
    }
}

